/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SmartHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspendManagerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendManagerUtil");

    public static boolean isEvaluating(SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        for (SuspendContextImpl suspendContext : suspendManager.getEventContexts()) {
            if (!suspendContext.isEvaluating() || !thread.equals(suspendContext.getThread())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static SuspendContextImpl findContextByThread(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendManager", "com/intellij/debugger/engine/SuspendManagerUtil", "findContextByThread"));
        }
        for (SuspendContextImpl context : ((SuspendManagerImpl)suspendManager).getPausedContexts()) {
            if (context.getThread() != thread && context.getSuspendPolicy() != 2 || context.isExplicitlyResumed(thread)) continue;
            return context;
        }
        return null;
    }

    public static void assertSuspendContext(SuspendContextImpl context) {
        if (LOG.isDebugEnabled()) {
            LOG.assertTrue(context.myInProgress, (Object)"You can invoke methods only inside commands invoked for SuspendContext");
        }
    }

    @NotNull
    public static Set<SuspendContextImpl> getSuspendingContexts(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendManager", "com/intellij/debugger/engine/SuspendManagerUtil", "getSuspendingContexts"));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        SmartHashSet result2 = new SmartHashSet();
        for (SuspendContextImpl suspendContext : suspendManager.getEventContexts()) {
            if (!suspendContext.suspends(thread)) continue;
            result2.add(suspendContext);
        }
        SmartHashSet smartHashSet = result2;
        if (smartHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/SuspendManagerUtil", "getSuspendingContexts"));
        }
        return smartHashSet;
    }

    @Nullable
    public static SuspendContextImpl getSuspendingContext(@NotNull SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        if (suspendManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendManager", "com/intellij/debugger/engine/SuspendManagerUtil", "getSuspendingContext"));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        for (SuspendContextImpl suspendContext : suspendManager.getEventContexts()) {
            if (!suspendContext.suspends(thread)) continue;
            return suspendContext;
        }
        return null;
    }

    public static void restoreAfterResume(SuspendContextImpl context, Object resumeData) {
        SuspendManager suspendManager = context.getDebugProcess().getSuspendManager();
        ResumeData data = (ResumeData)resumeData;
        ThreadReferenceProxyImpl thread = context.getThread();
        if (data.myIsFrozen && !suspendManager.isFrozen(thread)) {
            suspendManager.freezeThread(thread);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RestoreAfterResume SuspendContextImpl...");
        }
        LOG.assertTrue(context.myResumedThreads == null);
        if (data.myResumedThreads != null) {
            for (ThreadReferenceProxyImpl resumedThreads : data.myResumedThreads) {
                resumedThreads.resume();
            }
            context.myResumedThreads = data.myResumedThreads;
        }
    }

    public static Object prepareForResume(SuspendContextImpl context) {
        SuspendManager suspendManager = context.getDebugProcess().getSuspendManager();
        ThreadReferenceProxyImpl thread = context.getThread();
        ResumeData resumeData = new ResumeData(suspendManager.isFrozen(thread), context.myResumedThreads);
        if (resumeData.myIsFrozen) {
            suspendManager.unfreezeThread(thread);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resuming SuspendContextImpl...");
        }
        if (context.myResumedThreads != null) {
            for (ThreadReferenceProxyImpl resumedThreads : context.myResumedThreads) {
                resumedThreads.suspend();
            }
            context.myResumedThreads = null;
        }
        return resumeData;
    }

    public static SuspendContextImpl getSuspendContextForThread(SuspendContextImpl suspendContext, ThreadReferenceProxyImpl thread) {
        if (suspendContext == null) {
            return null;
        }
        SuspendContextImpl context = SuspendManagerUtil.findContextByThread(suspendContext.getDebugProcess().getSuspendManager(), thread);
        return context != null && !context.myInProgress ? context : suspendContext;
    }

    public static SuspendContextImpl getEvaluatingContext(SuspendManager suspendManager, ThreadReferenceProxyImpl thread) {
        for (SuspendContextImpl suspendContext : suspendManager.getEventContexts()) {
            if (suspendContext.isResumed() || !suspendContext.isEvaluating() || suspendContext.getThread() != thread) continue;
            return suspendContext;
        }
        return null;
    }

    private static class ResumeData {
        final boolean myIsFrozen;
        final Set<ThreadReferenceProxyImpl> myResumedThreads;

        public ResumeData(boolean isFrozen, Set<ThreadReferenceProxyImpl> resumedThreads) {
            this.myIsFrozen = isFrozen;
            this.myResumedThreads = resumedThreads;
        }
    }
}

