/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.RemappedSourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionManagerImpl
implements PositionManager,
MultiRequestPositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcessImpl myDebugProcess;

    public PositionManagerImpl(DebugProcessImpl debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        List<Location> list;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/engine/PositionManagerImpl", "locationsOfLine"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/PositionManagerImpl", "locationsOfLine"));
        }
        try {
            int line = position.getLine() + 1;
            list = type.locationsOfLine("Java", null, line);
        }
        catch (AbsentInformationException absentInformationException) {
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/PositionManagerImpl", "locationsOfLine"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/PositionManagerImpl", "locationsOfLine"));
        }
        return list;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/PositionManagerImpl", "createPrepareRequest"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/PositionManagerImpl", "createPrepareRequest"));
        }
        throw new IllegalStateException("This class implements MultiRequestPositionManager, corresponding createPrepareRequests version should be used");
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/PositionManagerImpl", "createPrepareRequests"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/PositionManagerImpl", "createPrepareRequests"));
        }
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<ClassPrepareRequest>>(){

            public List<ClassPrepareRequest> compute() {
                ArrayList<ClassPrepareRequest> res = new ArrayList<ClassPrepareRequest>();
                for (PsiClass psiClass : PositionManagerImpl.getLineClasses(position.getFile(), position.getLine())) {
                    ClassPrepareRequest request;
                    ClassPrepareRequestor prepareRequestor = requestor;
                    String classPattern = JVMNameUtil.getNonAnonymousClassName(psiClass);
                    if (classPattern == null) {
                        String parentQName;
                        PsiClass parent = JVMNameUtil.getTopLevelParentClass(psiClass);
                        if (parent == null || (parentQName = JVMNameUtil.getNonAnonymousClassName(parent)) == null) continue;
                        classPattern = parentQName + "*";
                        prepareRequestor = new ClassPrepareRequestor(){

                            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                                CompoundPositionManager positionManager = ((DebugProcessImpl)debuggerProcess).getPositionManager();
                                List<ReferenceType> positionClasses = positionManager.getAllClasses(position);
                                if (positionClasses.contains(referenceType)) {
                                    requestor.processClassPrepare(debuggerProcess, referenceType);
                                }
                            }
                        };
                    }
                    if ((request = PositionManagerImpl.this.myDebugProcess.getRequestsManager().createClassPrepareRequest(prepareRequestor, classPattern)) == null) continue;
                    res.add(request);
                }
                return res;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/PositionManagerImpl", "createPrepareRequests"));
        }
        return list;
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        Set lambdas;
        SourcePosition position;
        int lineNumber;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (location == null) {
            return null;
        }
        PsiFile psiFile = this.getPsiFileByLocation(this.getDebugProcess().getProject(), location);
        if (psiFile == null) {
            return null;
        }
        LOG.assertTrue(this.myDebugProcess != null);
        try {
            lineNumber = location.lineNumber() - 1;
        }
        catch (InternalError e) {
            lineNumber = -1;
        }
        if (lineNumber > -1 && (position = PositionManagerImpl.calcLineMappedSourcePosition(psiFile, lineNumber)) != null) {
            return position;
        }
        Method method = location.method();
        if (psiFile instanceof PsiCompiledElement || lineNumber < 0) {
            String methodSignature = method.signature();
            if (methodSignature == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            String methodName = method.name();
            if (methodName == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            if (location.declaringType() == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            MethodFinder finder = new MethodFinder(location.declaringType().name(), methodName, methodSignature);
            psiFile.accept((PsiElementVisitor)finder);
            PsiMethod compiledMethod = finder.getCompiledMethod();
            if (compiledMethod == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            SourcePosition sourcePosition = SourcePosition.createFromElement((PsiElement)compiledMethod);
            if (lineNumber >= 0) {
                sourcePosition = new ClsSourcePosition(sourcePosition, lineNumber);
            }
            return sourcePosition;
        }
        SourcePosition sourcePosition = SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
        int lambdaOrdinal = -1;
        if (LambdaMethodFilter.isLambdaName(method.name()) && (lambdas = ContainerUtil.map2SetNotNull(this.locationsOfLine(location.declaringType(), sourcePosition), (Function)new Function<Location, Method>(){

            public Method fun(Location location) {
                Method method = location.method();
                if (LambdaMethodFilter.isLambdaName(method.name())) {
                    return method;
                }
                return null;
            }
        })).size() > 1) {
            ArrayList lambdasList = new ArrayList(lambdas);
            Collections.sort(lambdasList, DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
            lambdaOrdinal = lambdasList.indexOf(method);
        }
        return new JavaSourcePosition(sourcePosition, location.declaringType(), method, lambdaOrdinal);
    }

    private static Iterable<PsiElement> getLineElements(final PsiFile file2, int lineNumber) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null || lineNumber < 0 || lineNumber >= document.getLineCount()) {
            return EmptyIterable.getInstance();
        }
        final TextRange lineRange = DocumentUtil.getLineTextRange(document, lineNumber);
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new Iterator<PsiElement>(){
                    PsiElement myElement;
                    {
                        this.myElement = DebuggerUtilsEx.findElementAt(file2, lineRange.getStartOffset());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myElement != null;
                    }

                    @Override
                    public PsiElement next() {
                        PsiElement res = this.myElement;
                        do {
                            this.myElement = PsiTreeUtil.nextLeaf((PsiElement)this.myElement);
                            if (this.myElement != null && this.myElement.getTextOffset() <= lineRange.getEndOffset()) continue;
                            this.myElement = null;
                            break;
                        } while (this.myElement.getTextLength() == 0);
                        return res;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    private static Set<PsiClass> getLineClasses(PsiFile file2, int lineNumber) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet<PsiClass> res = new HashSet<PsiClass>();
        for (PsiElement element : PositionManagerImpl.getLineElements(file2, lineNumber)) {
            PsiClass aClass = PositionManagerImpl.getEnclosingClass(element);
            if (aClass == null) continue;
            res.add(aClass);
        }
        return res;
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project, Location location) {
        int dollar;
        GlobalSearchScope searchScope;
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalQName = refType.name();
        PsiClass psiClass = DebuggerUtils.findClass((String)originalQName, (Project)project, (GlobalSearchScope)(searchScope = this.myDebugProcess.getSearchScope()));
        if (psiClass == null && (dollar = originalQName.indexOf(36)) > 0) {
            String qName = originalQName.substring(0, dollar);
            psiClass = DebuggerUtils.findClass((String)qName, (Project)project, (GlobalSearchScope)searchScope);
        }
        if (psiClass != null) {
            PsiElement fileElement;
            PsiElement element = psiClass.getNavigationElement();
            if (element instanceof PsiCompiledElement && !((fileElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement)) {
                element = fileElement;
            }
            return element.getContainingFile();
        }
        try {
            PsiFile[] files;
            for (PsiFile file2 : files = FilenameIndex.getFilesByName(project, refType.sourceName(), GlobalSearchScope.allScope((Project)project))) {
                if (!(file2 instanceof PsiJavaFile)) continue;
                for (PsiClass cls : ((PsiJavaFile)file2).getClasses()) {
                    if (!StringUtil.equals((CharSequence)originalQName, (CharSequence)cls.getQualifiedName())) continue;
                    return file2;
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(final @NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/PositionManagerImpl", "getAllClasses"));
        }
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<ReferenceType>>(){

            public List<ReferenceType> compute() {
                ArrayList<ReferenceType> res = new ArrayList<ReferenceType>();
                for (PsiClass aClass : PositionManagerImpl.getLineClasses(position.getFile(), position.getLine())) {
                    res.addAll(PositionManagerImpl.this.getClassReferences(aClass, position));
                }
                return res;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/PositionManagerImpl", "getAllClasses"));
        }
        return list;
    }

    private List<ReferenceType> getClassReferences(final @NotNull PsiClass psiClass, SourcePosition position) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/debugger/engine/PositionManagerImpl", "getClassReferences"));
        }
        final Ref baseClassNameRef = new Ref(null);
        final Ref classAtPositionRef = new Ref(null);
        final Ref isLocalOrAnonymous = new Ref((Object)Boolean.FALSE);
        final Ref requiredDepth = new Ref((Object)0);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                classAtPositionRef.set((Object)psiClass);
                String className = JVMNameUtil.getNonAnonymousClassName(psiClass);
                if (className == null) {
                    isLocalOrAnonymous.set((Object)Boolean.TRUE);
                    PsiClass topLevelClass = JVMNameUtil.getTopLevelParentClass(psiClass);
                    if (topLevelClass != null) {
                        String parentClassName = JVMNameUtil.getNonAnonymousClassName(topLevelClass);
                        if (parentClassName != null) {
                            requiredDepth.set((Object)PositionManagerImpl.getNestingDepth(psiClass));
                            baseClassNameRef.set((Object)parentClassName);
                        }
                    } else {
                        LOG.error("Local or anonymous class has no non-local parent");
                    }
                } else {
                    baseClassNameRef.set((Object)className);
                }
            }
        });
        String className = (String)baseClassNameRef.get();
        if (className == null) {
            return Collections.emptyList();
        }
        List<ReferenceType> classes = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
        ArrayList<ReferenceType> result2 = new ArrayList<ReferenceType>(classes.size());
        if (!((Boolean)isLocalOrAnonymous.get()).booleanValue()) {
            for (ReferenceType type : classes) {
                result2.add(this.mapClass(type));
            }
        } else {
            for (ReferenceType outer : classes) {
                ReferenceType nested = this.findNested(outer, 0, (PsiClass)classAtPositionRef.get(), (Integer)requiredDepth.get(), position);
                if (nested == null) continue;
                result2.add(nested);
            }
        }
        return result2;
    }

    protected ReferenceType mapClass(ReferenceType type) {
        return type;
    }

    private static int getNestingDepth(PsiClass aClass) {
        int depth = 0;
        PsiClass enclosing = PositionManagerImpl.getEnclosingClass((PsiElement)aClass);
        while (enclosing != null) {
            ++depth;
            enclosing = PositionManagerImpl.getEnclosingClass((PsiElement)enclosing);
        }
        return depth;
    }

    @Nullable
    private static PsiClass getEnclosingClass(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement previous = null;
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (PsiClass.class.isInstance(element) && !(previous instanceof PsiExpressionList)) {
                return (PsiClass)element;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            previous = element;
        }
        return null;
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, int currentDepth, final PsiClass classToFind, int requiredDepth, final SourcePosition position) {
        VirtualMachineProxyImpl vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            try {
                if (currentDepth < requiredDepth) {
                    List<ReferenceType> nestedTypes = vmProxy.nestedTypes(fromClass);
                    for (ReferenceType nested : nestedTypes) {
                        ReferenceType found = this.findNested(nested, currentDepth + 1, classToFind, requiredDepth, position);
                        if (found == null) continue;
                        return found;
                    }
                    return null;
                }
                final ReferenceType mapped = this.mapClass(fromClass);
                int rangeBegin = Integer.MAX_VALUE;
                int rangeEnd = Integer.MIN_VALUE;
                for (Location location : mapped.allLineLocations()) {
                    Method method;
                    int lnumber = location.lineNumber();
                    if (lnumber <= 1 || (method = location.method()) == null || DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                    int locationLine = lnumber - 1;
                    PsiFile psiFile = position.getFile().getOriginalFile();
                    if (psiFile instanceof PsiCompiledFile && (locationLine = PositionManagerImpl.bytecodeToSourceLine(psiFile, locationLine)) < 0) continue;
                    rangeBegin = Math.min(rangeBegin, locationLine);
                    rangeEnd = Math.max(rangeEnd, locationLine);
                }
                int positionLine = position.getLine();
                if (positionLine >= rangeBegin && positionLine <= rangeEnd) {
                    final int finalRangeBegin = rangeBegin;
                    final int finalRangeEnd = rangeEnd;
                    return (ReferenceType)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<ReferenceType>(){

                        public ReferenceType compute() {
                            if (!classToFind.isValid()) {
                                return null;
                            }
                            int line = Math.min(finalRangeBegin + 1, finalRangeEnd);
                            Set lineClasses = PositionManagerImpl.getLineClasses(position.getFile(), line);
                            if (lineClasses.size() > 1) {
                                for (PsiClass aClass : lineClasses) {
                                    if (!classToFind.equals(aClass)) continue;
                                    return mapped;
                                }
                            } else if (!lineClasses.isEmpty()) {
                                return classToFind.equals(lineClasses.iterator().next()) ? mapped : null;
                            }
                            return null;
                        }
                    });
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static SourcePosition calcLineMappedSourcePosition(PsiFile psiFile, int originalLine) {
        int line = PositionManagerImpl.bytecodeToSourceLine(psiFile, originalLine);
        if (line > -1) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)(line - 1));
        }
        return null;
    }

    private static int bytecodeToSourceLine(PsiFile psiFile, int originalLine) {
        int line;
        LineNumbersMapping mapping;
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 != null && (mapping = (LineNumbersMapping)file2.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (line = mapping.bytecodeToSource(originalLine + 1)) > -1) {
            return line;
        }
        return -1;
    }

    private static class ClsSourcePosition
    extends RemappedSourcePosition {
        private final int myOriginalLine;

        public ClsSourcePosition(SourcePosition delegate, int originalLine) {
            super(delegate);
            this.myOriginalLine = originalLine;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition original) {
            if (this.myOriginalLine < 0) {
                return original;
            }
            SourcePosition position = PositionManagerImpl.calcLineMappedSourcePosition(this.getFile(), this.myOriginalLine);
            return position != null ? position : original;
        }
    }

    private class MethodFinder
    extends JavaRecursiveElementVisitor {
        private final String myClassName;
        private PsiClass myCompiledClass;
        private final String myMethodName;
        private final String myMethodSignature;
        private PsiMethod myCompiledMethod;

        public MethodFinder(String className, String methodName, String methodSignature) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodSignature = methodSignature;
        }

        public void visitClass(PsiClass aClass) {
            List allClasses = PositionManagerImpl.this.getClassReferences(aClass, SourcePosition.createFromElement((PsiElement)aClass));
            for (ReferenceType referenceType : allClasses) {
                if (!referenceType.name().equals(this.myClassName)) continue;
                this.myCompiledClass = aClass;
            }
            aClass.acceptChildren((PsiElementVisitor)this);
        }

        public void visitMethod(PsiMethod method) {
            try {
                String methodName = JVMNameUtil.getJVMMethodName(method);
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && containingClass.equals(this.myCompiledClass) && methodName.equals(this.myMethodName) && JVMNameUtil.getJVMSignature(method).getName(PositionManagerImpl.this.myDebugProcess).equals(this.myMethodSignature)) {
                    this.myCompiledMethod = method;
                }
            }
            catch (EvaluateException e) {
                LOG.debug((Throwable)e);
            }
        }

        public PsiClass getCompiledClass() {
            return this.myCompiledClass;
        }

        public PsiMethod getCompiledMethod() {
            return this.myCompiledMethod;
        }
    }

    private static class JavaSourcePosition
    extends RemappedSourcePosition {
        private final String myExpectedClassName;
        private final String myExpectedMethodName;
        private final int myLambdaOrdinal;

        public JavaSourcePosition(SourcePosition delegate, ReferenceType declaringType, Method method, int lambdaOrdinal) {
            super(delegate);
            this.myExpectedClassName = declaringType != null ? declaringType.name() : null;
            this.myExpectedMethodName = method != null ? method.name() : null;
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        private PsiElement remapElement(PsiElement element) {
            String name = JVMNameUtil.getClassVMName(PositionManagerImpl.getEnclosingClass(element));
            if (name != null && !name.equals(this.myExpectedClassName)) {
                return null;
            }
            PsiElement method = DebuggerUtilsEx.getContainingMethod(element);
            if (!StringUtil.isEmpty((String)this.myExpectedMethodName)) {
                if (method == null) {
                    return null;
                }
                if (method instanceof PsiMethod && this.myExpectedMethodName.equals(((PsiMethod)method).getName()) ? JavaSourcePosition.insideBody(element, (PsiElement)((PsiMethod)method).getBody()) : method instanceof PsiLambdaExpression && LambdaMethodFilter.isLambdaName(this.myExpectedMethodName) && JavaSourcePosition.insideBody(element, ((PsiLambdaExpression)method).getBody())) {
                    return element;
                }
            }
            return null;
        }

        private static boolean insideBody(@NotNull PsiElement element, @Nullable PsiElement body) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/debugger/engine/PositionManagerImpl$JavaSourcePosition", "insideBody"));
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)false)) {
                return false;
            }
            if (body instanceof PsiCodeBlock) {
                return !element.equals(((PsiCodeBlock)body).getRBrace()) && !element.equals(((PsiCodeBlock)body).getLBrace());
            }
            return true;
        }

        @Override
        public SourcePosition mapDelegate(final SourcePosition original) {
            return (SourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SourcePosition>(){

                public SourcePosition compute() {
                    PsiFile file2 = original.getFile();
                    int line = original.getLine();
                    if (LambdaMethodFilter.isLambdaName(JavaSourcePosition.this.myExpectedMethodName) && JavaSourcePosition.this.myLambdaOrdinal > -1) {
                        PsiElement firstElem;
                        List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(original, false);
                        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
                        if (document == null || line >= document.getLineCount()) {
                            return original;
                        }
                        if (JavaSourcePosition.this.myLambdaOrdinal < lambdas.size() && (firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambdas.get(JavaSourcePosition.this.myLambdaOrdinal), document, line)) != null) {
                            return SourcePosition.createFromElement((PsiElement)firstElem);
                        }
                    } else {
                        for (PsiElement elem : PositionManagerImpl.getLineElements(file2, line)) {
                            PsiElement remappedElement = JavaSourcePosition.this.remapElement(elem);
                            if (remappedElement == null) continue;
                            if (remappedElement.getTextOffset() <= original.getOffset()) break;
                            return SourcePosition.createFromElement((PsiElement)remappedElement);
                        }
                    }
                    return original;
                }
            });
        }
    }
}

