/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.MissingMethodBodyFixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemicolonFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        boolean fixed = SemicolonFixer.fixReturn(editor, psiElement) || SemicolonFixer.fixForUpdate(editor, psiElement, processor2) || SemicolonFixer.fixAfterLastValidElement(editor, psiElement);
    }

    private static boolean fixReturn(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        PsiReturnStatement stmt;
        PsiMethod method;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/smartEnter/SemicolonFixer", "fixReturn"));
        }
        if (psiElement instanceof PsiReturnStatement && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) != null && PsiType.VOID.equals((Object)method.getReturnType()) && (stmt = (PsiReturnStatement)psiElement).getReturnValue() != null) {
            Document doc = editor.getDocument();
            doc.insertString(stmt.getTextRange().getStartOffset() + "return".length(), (CharSequence)";");
            return true;
        }
        return false;
    }

    private static boolean fixForUpdate(@NotNull Editor editor, @Nullable PsiElement psiElement, @NotNull JavaSmartEnterProcessor processor2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/smartEnter/SemicolonFixer", "fixForUpdate"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/editorActions/smartEnter/SemicolonFixer", "fixForUpdate"));
        }
        if (!(psiElement instanceof PsiForStatement)) {
            return false;
        }
        PsiForStatement forStatement = (PsiForStatement)psiElement;
        PsiExpression condition = forStatement.getCondition();
        if (forStatement.getUpdate() != null || condition == null) {
            return false;
        }
        TextRange range = condition.getTextRange();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int max = forStatement.getTextRange().getEndOffset();
        for (int i = range.getEndOffset() - 1; i < max; ++i) {
            if (text.charAt(i) != ';') continue;
            return false;
        }
        String toInsert = ";";
        Project project = editor.getProject();
        if (project != null && CodeStyleSettingsManager.getSettings((Project)project).SPACE_AFTER_SEMICOLON) {
            toInsert = toInsert + " ";
        }
        document.insertString(range.getEndOffset(), (CharSequence)toInsert);
        return true;
    }

    private static boolean fixAfterLastValidElement(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/smartEnter/SemicolonFixer", "fixAfterLastValidElement"));
        }
        if (!(psiElement != null && (psiElement instanceof PsiExpressionStatement || psiElement instanceof PsiDeclarationStatement || psiElement instanceof PsiImportStatementBase || psiElement instanceof PsiDoWhileStatement || psiElement instanceof PsiReturnStatement || psiElement instanceof PsiThrowStatement || psiElement instanceof PsiBreakStatement || psiElement instanceof PsiContinueStatement || psiElement instanceof PsiAssertStatement || psiElement instanceof PsiPackageStatement || psiElement instanceof PsiField && !(psiElement instanceof PsiEnumConstant) || psiElement instanceof PsiMethod && ((PsiMethod)psiElement).getBody() == null && !MissingMethodBodyFixer.shouldHaveBody((PsiMethod)psiElement)))) {
            return false;
        }
        String text = psiElement.getText();
        int tailLength = 0;
        ASTNode leaf = TreeUtil.findLastLeaf(psiElement.getNode());
        while (leaf != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(leaf.getElementType())) {
            tailLength += leaf.getTextLength();
            leaf = TreeUtil.prevLeaf(leaf);
        }
        if (tailLength > 0) {
            text = text.substring(0, text.length() - tailLength);
        }
        if (leaf == null) {
            return false;
        }
        int insertionOffset = leaf.getTextRange().getEndOffset();
        Document doc = editor.getDocument();
        if (psiElement instanceof PsiField && ((PsiField)psiElement).hasModifierProperty("abstract")) {
            doc.insertString(insertionOffset, (CharSequence)"()");
            insertionOffset += "()".length();
        }
        if (!StringUtil.endsWithChar((CharSequence)text, (char)';')) {
            PsiElement parent = psiElement.getParent();
            String toInsert = ";";
            if (parent instanceof PsiForStatement) {
                if (((PsiForStatement)parent).getUpdate() == psiElement) {
                    return false;
                }
                Project project = editor.getProject();
                if (project != null && CodeStyleSettingsManager.getSettings((Project)project).SPACE_AFTER_SEMICOLON) {
                    toInsert = toInsert + " ";
                }
            }
            doc.insertString(insertionOffset, (CharSequence)toInsert);
            return true;
        }
        return false;
    }
}

