/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeferFinalAssignmentFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.DeferFinalAssignmentFix");
    private final PsiVariable variable;
    private final PsiReferenceExpression expression;

    public DeferFinalAssignmentFix(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/DeferFinalAssignmentFix", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/DeferFinalAssignmentFix", "<init>"));
        }
        this.variable = variable;
        this.expression = expression;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("defer.final.assignment.with.temp.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeferFinalAssignmentFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("defer.final.assignment.with.temp.text", this.variable.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/DeferFinalAssignmentFix", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DeferFinalAssignmentFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.variable.getContainingFile())) {
            return;
        }
        if (this.variable instanceof PsiField) {
            this.deferField((PsiField)this.variable);
        } else {
            this.deferLocalVariable((PsiLocalVariable)this.variable);
        }
    }

    private void deferField(PsiField field) throws IncorrectOperationException {
        PsiCodeBlock codeBlock = DeferFinalAssignmentFix.getEnclosingCodeBlock(field, (PsiElement)this.expression);
        if (codeBlock == null) {
            return;
        }
        this.deferVariable((PsiElement)codeBlock, (PsiVariable)field, null);
    }

    private static PsiCodeBlock getEnclosingCodeBlock(PsiField field, PsiElement element) {
        PsiClassInitializer[] initializers;
        PsiMethod[] constructors;
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return null;
        }
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            PsiCodeBlock body = constructor.getBody();
            if (body == null || !PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true)) continue;
            return body;
        }
        for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
            PsiCodeBlock body = initializer.getBody();
            if (!PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)true)) continue;
            return body;
        }
        return null;
    }

    private void deferLocalVariable(PsiLocalVariable variable) throws IncorrectOperationException {
        PsiElement outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        this.deferVariable(outerCodeBlock, (PsiVariable)variable, variable.getParent());
    }

    private void deferVariable(PsiElement outerCodeBlock, PsiVariable variable, PsiElement tempDeclarationAnchor) throws IncorrectOperationException {
        ControlFlow controlFlow;
        if (outerCodeBlock == null) {
            return;
        }
        ArrayList<PsiReferenceExpression> outerReferences = new ArrayList<PsiReferenceExpression>();
        DeferFinalAssignmentFix.collectReferences(outerCodeBlock, variable, outerReferences);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory();
        Project project = variable.getProject();
        String tempName = DeferFinalAssignmentFix.suggestNewName(project, variable);
        PsiDeclarationStatement tempVariableDeclaration = factory.createVariableDeclarationStatement(tempName, variable.getType(), null);
        try {
            controlFlow = ControlFlowFactory.getInstance(project).getControlFlow(outerCodeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
        }
        catch (AnalysisCanceledException e) {
            return;
        }
        int minOffset = 0;
        boolean writeReferenceOccurred = false;
        PsiReferenceExpression writeReference = null;
        for (int i = outerReferences.size() - 1; i >= 0; --i) {
            PsiReferenceExpression reference = (PsiReferenceExpression)outerReferences.get(i);
            if (!writeReferenceOccurred && !PsiUtil.isAccessedForWriting((PsiExpression)reference)) {
                outerReferences.remove(i);
                continue;
            }
            writeReferenceOccurred = true;
            writeReference = reference;
            PsiElement element = PsiUtil.getEnclosingStatement((PsiElement)reference);
            int endOffset = element == null ? -1 : controlFlow.getEndOffset(element);
            minOffset = Math.max(minOffset, endOffset);
        }
        LOG.assertTrue(writeReference != null);
        PsiStatement finalAssignment = factory.createStatementFromText(writeReference.getText() + " = " + tempName + ";", outerCodeBlock);
        if (!DeferFinalAssignmentFix.insertToDefinitelyReachedPlace(outerCodeBlock, finalAssignment, controlFlow, minOffset, outerReferences)) {
            return;
        }
        outerCodeBlock.addAfter((PsiElement)tempVariableDeclaration, tempDeclarationAnchor);
        DeferFinalAssignmentFix.replaceReferences(outerReferences, (PsiElement)factory.createExpressionFromText(tempName, outerCodeBlock));
    }

    private static boolean insertToDefinitelyReachedPlace(PsiElement codeBlock, PsiStatement finalAssignment, ControlFlow controlFlow, int minOffset, List references) throws IncorrectOperationException {
        int offset = ControlFlowUtil.getMinDefinitelyReachedOffset(controlFlow, minOffset, references);
        if (offset == controlFlow.getSize()) {
            codeBlock.add((PsiElement)finalAssignment);
            return true;
        }
        PsiElement element = null;
        while (offset < controlFlow.getSize()) {
            int startOffset;
            element = controlFlow.getElement(offset);
            if (element != null) {
                element = PsiUtil.getEnclosingStatement((PsiElement)element);
            }
            if ((startOffset = controlFlow.getStartOffset(element)) != -1 && startOffset >= minOffset && element instanceof PsiStatement) break;
            ++offset;
        }
        if (offset >= controlFlow.getSize()) {
            return false;
        }
        if (ControlFlowUtil.isInstructionReachable(controlFlow, offset, offset)) {
            return false;
        }
        codeBlock.addBefore((PsiElement)finalAssignment, element);
        return true;
    }

    private static void replaceReferences(List references, PsiElement newExpression) throws IncorrectOperationException {
        for (Object reference1 : references) {
            PsiElement reference = (PsiElement)reference1;
            reference.replace(newExpression);
        }
    }

    private static void collectReferences(PsiElement context, final PsiVariable variable, final List<PsiReferenceExpression> references) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.resolve() == variable) {
                    references.add(expression);
                }
                super.visitReferenceExpression(expression);
            }
        });
    }

    private static String suggestNewName(Project project, PsiVariable variable) {
        String name = variable.getName();
        if (name.length() > 1 && Character.isDigit(name.charAt(name.length() - 1))) {
            name = name.substring(0, name.length() - 1);
        }
        return JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(name, (PsiElement)variable, true);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/DeferFinalAssignmentFix", "isAvailable"));
        }
        return this.variable.isValid() && !(this.variable instanceof PsiParameter) && !(this.variable instanceof ImplicitVariable) && this.expression.isValid() && this.variable.getManager().isInProject((PsiElement)this.variable);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

