/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class AddMissingRequiredAnnotationParametersFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(AddMissingRequiredAnnotationParametersFix.class);
    private final PsiAnnotation myAnnotation;
    private final PsiMethod[] myAnnotationMethods;
    private final Collection<String> myMissedElements;

    public AddMissingRequiredAnnotationParametersFix(PsiAnnotation annotation, PsiMethod[] annotationMethods, Collection<String> missedElements) {
        if (missedElements.isEmpty()) {
            throw new IllegalArgumentException("missedElements can't be empty");
        }
        this.myAnnotation = annotation;
        this.myAnnotationMethods = annotationMethods;
        this.myMissedElements = missedElements;
    }

    @NotNull
    public String getText() {
        String string = this.myMissedElements.size() == 1 ? QuickFixBundle.message("add.missing.annotation.single.parameter.fix", ContainerUtil.getFirstItem(this.myMissedElements)) : QuickFixBundle.message("add.missing.annotation.parameters.fix", StringUtil.join(this.myMissedElements, (String)", "));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("annotations.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix", "isAvailable"));
        }
        return this.myAnnotation.isValid();
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingRequiredAnnotationParametersFix", "invoke"));
        }
        PsiNameValuePair[] addedParameters = this.myAnnotation.getParameterList().getAttributes();
        final TObjectIntHashMap<String> annotationsOrderMap = this.getAnnotationsOrderMap();
        TreeSet<Pair<String, PsiAnnotationMemberValue>> newParameters = new TreeSet<Pair<String, PsiAnnotationMemberValue>>(new Comparator<Pair<String, PsiAnnotationMemberValue>>(){

            @Override
            public int compare(Pair<String, PsiAnnotationMemberValue> o1, Pair<String, PsiAnnotationMemberValue> o2) {
                return annotationsOrderMap.get(o1.getFirst()) - annotationsOrderMap.get(o2.getFirst());
            }
        });
        boolean order = AddMissingRequiredAnnotationParametersFix.isAlreadyAddedOrdered(annotationsOrderMap, addedParameters);
        if (order && addedParameters.length != 0) {
            void var11_14;
            PsiAnnotationParameterList parameterList = this.myAnnotation.getParameterList();
            parameterList.deleteChildRange((PsiElement)addedParameters[0], (PsiElement)addedParameters[addedParameters.length - 1]);
            PsiNameValuePair[] psiNameValuePairArray = addedParameters;
            int n = psiNameValuePairArray.length;
            boolean bl = false;
            while (var11_14 < n) {
                PsiNameValuePair addedParameter = psiNameValuePairArray[var11_14];
                String name = addedParameter.getName();
                PsiAnnotationMemberValue value = addedParameter.getValue();
                if (name == null || value == null) {
                    LOG.error(String.format("Invalid annotation parameter name = %s, value = %s", name, value));
                } else {
                    newParameters.add((Pair<String, PsiAnnotationMemberValue>)Pair.create((Object)name, (Object)value));
                }
                ++var11_14;
            }
        }
        PsiExpression nullValue = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("null", null);
        for (String misssedParameter : this.myMissedElements) {
            newParameters.add((Pair<String, PsiAnnotationMemberValue>)Pair.create((Object)misssedParameter, (Object)nullValue));
        }
        TemplateBuilderImpl builder = null;
        for (Pair pair : newParameters) {
            PsiAnnotationMemberValue value = this.myAnnotation.setDeclaredAttributeValue((String)pair.getFirst(), (PsiAnnotationMemberValue)pair.getSecond());
            if (!this.myMissedElements.contains(pair.getFirst())) continue;
            if (builder == null) {
                builder = new TemplateBuilderImpl((PsiElement)this.myAnnotation.getParameterList());
            }
            builder.replaceElement((PsiElement)value, new EmptyExpression(), true);
        }
        editor.getCaretModel().moveToOffset(this.myAnnotation.getParameterList().getTextRange().getStartOffset());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file2);
        if (document == null) {
            throw new IllegalStateException();
        }
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        TemplateManager.getInstance(project).startTemplate(editor, builder.buildInlineTemplate(), null);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private TObjectIntHashMap<String> getAnnotationsOrderMap() {
        TObjectIntHashMap map = new TObjectIntHashMap();
        for (int i = 0; i < this.myAnnotationMethods.length; ++i) {
            map.put((Object)this.myAnnotationMethods[i].getName(), i);
        }
        return map;
    }

    private static boolean isAlreadyAddedOrdered(TObjectIntHashMap<String> orderMap, PsiNameValuePair[] addedParameters) {
        if (addedParameters.length <= 1) {
            return true;
        }
        int previousOrder = orderMap.get((Object)addedParameters[0].getName());
        for (int i = 1; i < addedParameters.length; ++i) {
            int currentOrder = orderMap.get((Object)addedParameters[i].getName());
            if (currentOrder < previousOrder) {
                return false;
            }
            previousOrder = currentOrder;
        }
        return true;
    }
}

