/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BinaryContent;

public class CompiledClass
extends UserDataHolderBase {
    @NotNull
    private final File myOutputFile;
    @NotNull
    private final File mySourceFile;
    @Nullable
    private final String myClassName;
    @NotNull
    private BinaryContent myContent;
    private boolean myIsDirty;

    public CompiledClass(@NotNull File outputFile, @NotNull File sourceFile, @Nullable String className, @NotNull BinaryContent content) {
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/jps/incremental/CompiledClass", "<init>"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/jps/incremental/CompiledClass", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/jps/incremental/CompiledClass", "<init>"));
        }
        this.myIsDirty = false;
        this.myOutputFile = outputFile;
        this.mySourceFile = sourceFile;
        this.myClassName = className;
        this.myContent = content;
    }

    public void save() throws IOException {
        this.myContent.saveToFile(this.myOutputFile);
        this.myIsDirty = false;
    }

    @NotNull
    public File getOutputFile() {
        File file = this.myOutputFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/CompiledClass", "getOutputFile"));
        }
        return file;
    }

    @NotNull
    public File getSourceFile() {
        File file = this.mySourceFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/CompiledClass", "getSourceFile"));
        }
        return file;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public BinaryContent getContent() {
        BinaryContent binaryContent = this.myContent;
        if (binaryContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/CompiledClass", "getContent"));
        }
        return binaryContent;
    }

    public void setContent(@NotNull BinaryContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/jps/incremental/CompiledClass", "setContent"));
        }
        this.myContent = content;
        this.myIsDirty = true;
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CompiledClass aClass = (CompiledClass)((Object)o);
        return FileUtil.filesEqual((File)this.myOutputFile, (File)aClass.myOutputFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myOutputFile);
    }

    public String toString() {
        return "CompiledClass{myOutputFile=" + this.myOutputFile + ", mySourceFile=" + this.mySourceFile + ", myIsDirty=" + this.myIsDirty + '}';
    }
}

