/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Charsets;
import kotlin.Sequence;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.io.LinesSequence;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"]\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0012B\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\n\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0007iQ\u0002\u0003\u0001\u000e\u0003a\u0005Q#\u0001\r\u00023\u0017!\u0011\u0001c\u0001\u000e\u0003a\u0011\u0001k!\u0001U\u0007\u000biQ\u0002\u0003\u0001\u000e\u0003a\u0019Q#\u0001M\u00043\u0017!\u0011\u0001c\u0001\u000e\u0003a\u0011\u0001k!\u0001U\u0007\u000bi)\u0003\u0003\u0003\u000e\u0003a%Q#\u0001\r\u00023\u0013AQ!D\u0001\u0019\bA\u001b\t!g\u0003\u0005\u0003!\rQ\"\u0001\r\u0003!\u000e\tAk!\u0002\u000e%!-Q\"\u0001\r\u0007+\u0005A\u0012!'\u0006\t\u000e59\u0011BA\u0005\u00021\u001fI!!C\u0001\u0019\ra9\u0001k!\u0001U\u0007\u000bi\u0019\u0002\u0003\u0005\u000e\t%\u0011\u0011\"\u0001M\b1#)\u0012\u0001'\u0001U\u0007\u000bii\u0001C\u0005\u000e\u0003aMQ#\u0001\r\u000b)\u000e\u0015QR\u0002E\u000b\u001b\u0005Az!F\u0001\u0019\u0003Q\u001b)!D\u0007\t\u00165\t\u0001tB\u000b\u00021)IZ\u0001B\u0001\t\u00175\t\u0001t\u0003)\u0004\u0002Q\u001b)!\u0004\u0007\t\u00165\t\u0001tB\u000b\u00021)IJ\u0001C\u0006\u000e\u0003a=\u0001k!\u0001U\u0007\u000bii\u0001\u0003\u0007\u000e\u0003aeQ#\u0001M\b)\u000e\u0015QB\b\u0003D!!iQ\"\u0001S\u000e#\u0011!\u0001\u0001\u0003\b\u0016\u0003au\u0011C\u0001C\u0001\u00117)\u0012\u0001\n\b\u001a\u0016!5QbB\u0005\u0003\u0013\u0005!c\"\u0003\u0002\n\u0003\u0011n\u0001d\u0002)\u0004\u0002E\u001b\u0011\u0001C\bU\u0007\u000biA\u0004B\"\u0011\u0011?i\u0011\u0001\n\b\u0012\u0005\u0011\u0001\u0001BD\u000b\u00021\u0005IZ\u0002#\u0004\u000e\u0015%)\u0011\u0002B\u0005\u0003\u0013\u0005Az\u0001'\u0005\n\u0005%\tAE\u0004\r\b!\u000e\u0005\u0011kA\u0001\t!Q\u001b)\u0001"}, strings={"buffered", "Ljava/io/BufferedReader;", "Ljava/io/Reader;", "bufferSize", "", "TextStreamsKt", "Ljava/io/BufferedWriter;", "Ljava/io/Writer;", "copyTo", "", "out", "forEachLine", "", "block", "Lkotlin/Function1;", "", "lineSequence", "Lkotlin/Sequence;", "readBytes", "", "Ljava/net/URL;", "readText", "charset", "Ljava/nio/charset/Charset;", "reader", "Ljava/io/StringReader;", "use", "R", "T", "Ljava/io/Closeable;", "(Ljava/io/Closeable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "useLines", "(Ljava/io/Reader;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;"}, moduleName="kotlin-stdlib")
@JvmName(name="TextStreamsKt")
public final class TextStreamsKt {
    @NotNull
    public static final BufferedReader buffered(Reader $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof BufferedReader ? (BufferedReader)$receiver : new BufferedReader($receiver, bufferSize);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedReader buffered$default(Reader reader, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return TextStreamsKt.buffered(reader, n);
    }

    @NotNull
    public static final BufferedWriter buffered(Writer $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof BufferedWriter ? (BufferedWriter)$receiver : new BufferedWriter($receiver, bufferSize);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedWriter buffered$default(Writer writer, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return TextStreamsKt.buffered(writer, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void forEachLine(Reader $receiver, @NotNull Function1<? super String, Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        Reader $receiver$iv = $receiver;
        Closeable $receiver$iv$iv = TextStreamsKt.buffered$default($receiver$iv, 0, 1);
        boolean closed$iv$iv = false;
        try {
            void $receiver$iv2;
            Sequence<String> it;
            BufferedReader it$iv = (BufferedReader)$receiver$iv$iv;
            Sequence<String> sequence2 = it = TextStreamsKt.lineSequence(it$iv);
            Function1<? super String, Unit> function1 = block;
            for (Object element$iv : $receiver$iv2) {
                void action$iv;
                action$iv.invoke(element$iv);
            }
            it$iv = Unit.INSTANCE;
        }
        catch (Exception e$iv$iv) {
            closed$iv$iv = true;
            try {
                $receiver$iv$iv.close();
            }
            catch (Exception closeException$iv$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv$iv;
        }
        finally {
            if (!closed$iv$iv) {
                $receiver$iv$iv.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T useLines(Reader $receiver, @NotNull Function1<? super Sequence<String>, ? extends T> block) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        Closeable $receiver$iv = TextStreamsKt.buffered$default($receiver, 0, 1);
        boolean closed$iv = false;
        try {
            it = (BufferedReader)$receiver$iv;
            it = block.invoke(TextStreamsKt.lineSequence((BufferedReader)it));
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            if (!closed$iv) {
                $receiver$iv.close();
            }
            InlineMarker.finallyEnd((int)1);
        }
        return (T)it;
    }

    @NotNull
    public static final StringReader reader(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new StringReader($receiver);
    }

    @NotNull
    public static final Sequence<String> lineSequence(BufferedReader $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.constrainOnce(new LinesSequence($receiver));
    }

    @NotNull
    public static final String readText(Reader $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringWriter buffer = new StringWriter();
        TextStreamsKt.copyTo$default($receiver, buffer, 0, 2);
        String string = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }

    public static final long copyTo(Reader $receiver, @NotNull Writer out, int bufferSize) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        long charsCopied = 0L;
        char[] buffer = new char[bufferSize];
        int chars = $receiver.read(buffer);
        while (chars >= 0) {
            out.write(buffer, 0, chars);
            charsCopied += (long)chars;
            chars = $receiver.read(buffer);
        }
        return charsCopied;
    }

    public static /* bridge */ /* synthetic */ long copyTo$default(Reader reader, Writer writer, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return TextStreamsKt.copyTo(reader, writer, n);
    }

    @NotNull
    public static final String readText(URL $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return ArraysKt.toString(TextStreamsKt.readBytes($receiver), charset);
    }

    @NotNull
    public static final String readText(URL $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return ArraysKt.toString(TextStreamsKt.readBytes($receiver), charset);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String readText$default(URL uRL, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return TextStreamsKt.readText(uRL, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] readBytes(URL $receiver) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Closeable $receiver$iv = $receiver.openStream();
        boolean closed$iv = false;
        try {
            it = (InputStream)$receiver$iv;
            it = ByteStreamsKt.readBytes$default((InputStream)it, 0, 1);
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        return (byte[])it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends Closeable, R> R use(T $receiver, @NotNull Function1<? super T, ? extends R> block) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        boolean closed = false;
        try {
            Object object = block.invoke($receiver);
            return (R)object;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            if (!closed) {
                $receiver.close();
            }
            InlineMarker.finallyEnd((int)1);
        }
    }
}

