/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;

public class LivenessAnalyzer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final int MAX_VARIABLES_SIZE = 64;
    private final PartialEvaluator partialEvaluator;
    private long[] isAliveBefore = new long[1024];
    private long[] isAliveAfter = new long[1024];
    private long[] isCategory2 = new long[1024];
    private boolean checkAgain;
    private long alive;

    public LivenessAnalyzer() {
        this(new PartialEvaluator());
    }

    public LivenessAnalyzer(PartialEvaluator partialEvaluator) {
        this.partialEvaluator = partialEvaluator;
    }

    public boolean isTraced(int instructionOffset) {
        return this.partialEvaluator.isTraced(instructionOffset);
    }

    public boolean isAliveBefore(int instructionOffset, int variableIndex) {
        return variableIndex >= 64 || (this.isAliveBefore[instructionOffset] & 1L << variableIndex) != 0L;
    }

    public void setAliveBefore(int instructionOffset, int variableIndex, boolean alive) {
        if (variableIndex < 64) {
            if (alive) {
                int n = instructionOffset;
                this.isAliveBefore[n] = this.isAliveBefore[n] | 1L << variableIndex;
            } else {
                int n = instructionOffset;
                this.isAliveBefore[n] = this.isAliveBefore[n] & (1L << variableIndex ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public boolean isAliveAfter(int instructionOffset, int variableIndex) {
        return variableIndex >= 64 || (this.isAliveAfter[instructionOffset] & 1L << variableIndex) != 0L;
    }

    public void setAliveAfter(int instructionOffset, int variableIndex, boolean alive) {
        if (variableIndex < 64) {
            if (alive) {
                int n = instructionOffset;
                this.isAliveAfter[n] = this.isAliveAfter[n] | 1L << variableIndex;
            } else {
                int n = instructionOffset;
                this.isAliveAfter[n] = this.isAliveAfter[n] & (1L << variableIndex ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public boolean isCategory2(int instructionOffset, int variableIndex) {
        return variableIndex < 64 && (this.isCategory2[instructionOffset] & 1L << variableIndex) != 0L;
    }

    public void setCategory2(int instructionOffset, int variableIndex, boolean category2) {
        if (variableIndex < 64) {
            if (category2) {
                int n = instructionOffset;
                this.isCategory2[n] = this.isCategory2[n] | 1L << variableIndex;
            } else {
                int n = instructionOffset;
                this.isCategory2[n] = this.isCategory2[n] & (1L << variableIndex ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int offset;
        this.initializeArrays(codeAttribute);
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int codeLength = codeAttribute.u4codeLength;
        int variablesSize = codeAttribute.u2maxLocals;
        if (variablesSize > 64) {
            variablesSize = 64;
        }
        do {
            this.checkAgain = false;
            this.alive = 0L;
            for (offset = codeLength - 1; offset >= 0; --offset) {
                if (!this.partialEvaluator.isTraced(offset)) continue;
                InstructionOffsetValue branchTargets = this.partialEvaluator.branchTargets(offset);
                if (branchTargets != null) {
                    this.alive = this.combinedLiveness(branchTargets);
                }
                this.alive |= this.isAliveAfter[offset];
                this.isAliveAfter[offset] = this.alive;
                codeAttribute.instructionAccept(clazz, method, offset, this);
                this.alive |= this.isAliveBefore[offset];
                if (((this.isAliveBefore[offset] ^ 0xFFFFFFFFFFFFFFFFL) & this.alive) == 0L) continue;
                this.isAliveBefore[offset] = this.alive;
                this.checkAgain |= offset < this.maxOffset(this.partialEvaluator.branchOrigins(offset));
            }
            codeAttribute.exceptionsAccept(clazz, method, this);
        } while (this.checkAgain);
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            for (int variableIndex = 0; variableIndex < variablesSize; ++variableIndex) {
                Value value;
                if (this.isAliveBefore(offset, variableIndex) && (value = this.partialEvaluator.getVariablesBefore(offset).getValue(variableIndex)) != null && value.isCategory2()) {
                    this.setCategory2(offset, variableIndex, true);
                    this.setAliveBefore(offset, variableIndex + 1, true);
                    this.setCategory2(offset, variableIndex + 1, true);
                }
                if (!this.isAliveAfter(offset, variableIndex) || (value = this.partialEvaluator.getVariablesAfter(offset).getValue(variableIndex)) == null || !value.isCategory2()) continue;
                this.setCategory2(offset, variableIndex, true);
                this.setAliveAfter(offset, variableIndex + 1, true);
                this.setCategory2(offset, variableIndex + 1, true);
            }
        }
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int variableIndex = variableInstruction.variableIndex;
        if (variableIndex < 64) {
            long livenessMask = 1L << variableIndex;
            if (variableInstruction.isLoad()) {
                this.alive |= livenessMask;
            } else {
                this.alive &= livenessMask ^ 0xFFFFFFFFFFFFFFFFL;
                int n = offset;
                this.isAliveAfter[n] = this.isAliveAfter[n] | livenessMask;
            }
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (offset == this.partialEvaluator.superInitializationOffset()) {
            this.alive |= 1L;
        }
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        long alive = this.isAliveBefore[exceptionInfo.u2handlerPC];
        if (alive != 0L) {
            int startOffset = exceptionInfo.u2startPC;
            int endOffset = exceptionInfo.u2endPC;
            for (int offset = startOffset; offset < endOffset; ++offset) {
                if (!this.partialEvaluator.isTraced(offset) || ((this.isAliveBefore[offset] & this.isAliveAfter[offset] ^ 0xFFFFFFFFFFFFFFFFL) & alive) == 0L) continue;
                int n = offset;
                this.isAliveBefore[n] = this.isAliveBefore[n] | alive;
                int n2 = offset;
                this.isAliveAfter[n2] = this.isAliveAfter[n2] | alive;
                this.checkAgain = true;
            }
        }
    }

    private void initializeArrays(CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        if (this.isAliveBefore.length < codeLength) {
            this.isAliveBefore = new long[codeLength];
            this.isAliveAfter = new long[codeLength];
            this.isCategory2 = new long[codeLength];
        } else {
            for (int index = 0; index < codeLength; ++index) {
                this.isAliveBefore[index] = 0L;
                this.isAliveAfter[index] = 0L;
                this.isCategory2[index] = 0L;
            }
        }
    }

    private long combinedLiveness(InstructionOffsetValue instructionOffsetValue) {
        long alive = 0L;
        int count = instructionOffsetValue.instructionOffsetCount();
        for (int index = 0; index < count; ++index) {
            alive |= this.isAliveBefore[instructionOffsetValue.instructionOffset(index)];
        }
        return alive;
    }

    private int minOffset(Value instructionOffsets) {
        return this.minOffset(instructionOffsets, Integer.MAX_VALUE);
    }

    private int minOffset(Value instructionOffsets, int minOffset) {
        if (instructionOffsets != null) {
            InstructionOffsetValue instructionOffsetValue = instructionOffsets.instructionOffsetValue();
            int count = instructionOffsetValue.instructionOffsetCount();
            for (int index = 0; index < count; ++index) {
                int offset = instructionOffsetValue.instructionOffset(index);
                if (minOffset <= offset) continue;
                minOffset = offset;
            }
        }
        return minOffset;
    }

    private int maxOffset(Value instructionOffsets) {
        return this.maxOffset(instructionOffsets, Integer.MIN_VALUE);
    }

    private int maxOffset(Value instructionOffsets, int maxOffset) {
        if (instructionOffsets != null) {
            InstructionOffsetValue instructionOffsetValue = instructionOffsets.instructionOffsetValue();
            int count = instructionOffsetValue.instructionOffsetCount();
            for (int index = 0; index < count; ++index) {
                int offset = instructionOffsetValue.instructionOffset(index);
                if (maxOffset >= offset) continue;
                maxOffset = offset;
            }
        }
        return maxOffset;
    }
}

