/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.InjectedBindingClassField;
import android.databinding.tool.reflection.InjectedBindingClassMethod;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelField;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class InjectedBindingClass
extends ModelClass {
    private final String mClassName;
    private final String mSuperClass;
    private final Map<String, String> mVariables;
    private final Map<String, String> mFields;

    public InjectedBindingClass(String className, String superClass, Map<String, String> variables2, Map<String, String> fields) {
        this.mClassName = className;
        this.mSuperClass = superClass;
        this.mVariables = variables2;
        this.mFields = fields;
    }

    @Override
    public String toJavaCode() {
        return this.mClassName;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public ModelClass getComponentType() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isChar() {
        return false;
    }

    @Override
    public boolean isByte() {
        return false;
    }

    @Override
    public boolean isShort() {
        return false;
    }

    @Override
    public boolean isInt() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public List<ModelClass> getTypeArguments() {
        return null;
    }

    @Override
    public boolean isTypeVar() {
        return false;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isVoid() {
        return false;
    }

    @Override
    public ModelClass unbox() {
        return this;
    }

    @Override
    public ModelClass box() {
        return this;
    }

    @Override
    public boolean isObservable() {
        return this.getSuperclass().isObservable();
    }

    @Override
    public boolean isAssignableFrom(ModelClass that) {
        ModelClass superClass = that;
        while (superClass != null && !superClass.isObject()) {
            if (!superClass.toJavaCode().equals(this.mClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModelClass getSuperclass() {
        return ModelAnalyzer.getInstance().findClass(this.mSuperClass, null);
    }

    @Override
    public ModelClass erasure() {
        return this;
    }

    @Override
    public String getJniDescription() {
        return TypeUtil.getInstance().getDescription(this);
    }

    @Override
    protected ModelField[] getDeclaredFields() {
        ModelClass superClass = this.getSuperclass();
        ModelField[] superFields = superClass.getDeclaredFields();
        int fieldCount = superFields.length + this.mFields.size();
        ModelField[] fields = Arrays.copyOf(superFields, fieldCount);
        int index = superFields.length;
        for (String fieldName2 : this.mFields.keySet()) {
            String fieldType = this.mFields.get(fieldName2);
            fields[index++] = new InjectedBindingClassField(fieldName2, fieldType);
        }
        return fields;
    }

    @Override
    protected ModelMethod[] getDeclaredMethods() {
        ModelClass superClass = this.getSuperclass();
        ModelMethod[] superMethods = superClass.getDeclaredMethods();
        int methodCount = superMethods.length + this.mVariables.size() * 2;
        ModelMethod[] methods = Arrays.copyOf(superMethods, methodCount);
        int index = superMethods.length;
        for (String variableName : this.mVariables.keySet()) {
            String variableType = this.mVariables.get(variableName);
            String getterName2 = "get" + StringUtils.capitalize(variableName);
            methods[index++] = new InjectedBindingClassMethod(this, getterName2, variableType, null);
            String setterName2 = "set" + StringUtils.capitalize(variableName);
            methods[index++] = new InjectedBindingClassMethod(this, setterName2, "void", variableType);
        }
        return methods;
    }

    public String toString() {
        return "Injected Class: " + this.mClassName;
    }
}

