/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.BindingBuildInfo;
import android.databinding.tool.store.LayoutFileParser;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.JavaFileWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.xml.sax.SAXException;

public class LayoutXmlProcessor {
    public static final String RESOURCE_BUNDLE_PACKAGE = "android.databinding.layouts";
    public static final String CLASS_NAME = "DataBindingInfo";
    private final JavaFileWriter mFileWriter;
    private final ResourceBundle mResourceBundle;
    private final int mMinSdk;
    private boolean mProcessingComplete;
    private boolean mWritten;
    private final boolean mIsLibrary;
    private final String mBuildId = UUID.randomUUID().toString();
    private final OriginalFileLookup mOriginalFileLookup;
    private static final FilenameFilter layoutFolderFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("layout");
        }
    };
    private static final FilenameFilter xmlFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".xml");
        }
    };

    public LayoutXmlProcessor(String applicationPackage, JavaFileWriter fileWriter, int minSdk, boolean isLibrary, OriginalFileLookup originalFileLookup) {
        this.mFileWriter = fileWriter;
        this.mResourceBundle = new ResourceBundle(applicationPackage);
        this.mMinSdk = minSdk;
        this.mIsLibrary = isLibrary;
        this.mOriginalFileLookup = originalFileLookup;
    }

    private static void processIncrementalInputFiles(ResourceInput input, ProcessFileCallback callback) throws IOException, ParserConfigurationException, XPathExpressionException, SAXException {
        LayoutXmlProcessor.processExistingIncrementalFiles(input.getRootInputFolder(), input.getAdded(), callback);
        LayoutXmlProcessor.processExistingIncrementalFiles(input.getRootInputFolder(), input.getChanged(), callback);
        LayoutXmlProcessor.processRemovedIncrementalFiles(input.getRootInputFolder(), input.getRemoved(), callback);
    }

    private static void processExistingIncrementalFiles(File inputRoot, List<File> files, ProcessFileCallback callback) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        for (File file : files) {
            File parent = file.getParentFile();
            if (inputRoot.equals(parent)) {
                callback.processOtherRootFile(file);
                continue;
            }
            if (layoutFolderFilter.accept(parent, parent.getName())) {
                callback.processLayoutFile(file);
                continue;
            }
            callback.processOtherFile(parent, file);
        }
    }

    private static void processRemovedIncrementalFiles(File inputRoot, List<File> files, ProcessFileCallback callback) throws IOException {
        for (File file : files) {
            File parent = file.getParentFile();
            if (inputRoot.equals(parent)) {
                callback.processRemovedOtherRootFile(file);
                continue;
            }
            if (layoutFolderFilter.accept(parent, parent.getName())) {
                callback.processRemovedLayoutFile(file);
                continue;
            }
            callback.processRemovedOtherFile(parent, file);
        }
    }

    private static void processAllInputFiles(ResourceInput input, ProcessFileCallback callback) throws IOException, XPathExpressionException, SAXException, ParserConfigurationException {
        FileUtils.deleteDirectory((File)input.getRootOutputFolder());
        Preconditions.check(input.getRootOutputFolder().mkdirs(), "out dir should be re-created", new Object[0]);
        Preconditions.check(input.getRootInputFolder().isDirectory(), "it must be a directory", new Object[0]);
        for (File firstLevel : input.getRootInputFolder().listFiles()) {
            if (firstLevel.isDirectory()) {
                if (layoutFolderFilter.accept(firstLevel, firstLevel.getName())) {
                    callback.processLayoutFolder(firstLevel);
                    for (File xmlFile : firstLevel.listFiles(xmlFileFilter)) {
                        callback.processLayoutFile(xmlFile);
                    }
                    continue;
                }
                callback.processOtherFolder(firstLevel);
                for (File file : firstLevel.listFiles()) {
                    callback.processOtherFile(firstLevel, file);
                }
                continue;
            }
            callback.processOtherRootFile(firstLevel);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.mResourceBundle;
    }

    public boolean processResources(final ResourceInput input) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (this.mProcessingComplete) {
            return false;
        }
        final LayoutFileParser layoutFileParser = new LayoutFileParser();
        final URI inputRootUri = input.getRootInputFolder().toURI();
        ProcessFileCallback callback = new ProcessFileCallback(){

            private File convertToOutFile(File file) {
                String subPath = LayoutXmlProcessor.toSystemDependentPath(inputRootUri.relativize(file.toURI()).getPath());
                return new File(input.getRootOutputFolder(), subPath);
            }

            @Override
            public void processLayoutFile(File file) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
                File output = this.convertToOutFile(file);
                ResourceBundle.LayoutFileBundle bindingLayout = layoutFileParser.parseXml(file, output, LayoutXmlProcessor.this.mResourceBundle.getAppPackage(), LayoutXmlProcessor.this.mOriginalFileLookup);
                if (bindingLayout != null && !bindingLayout.isEmpty()) {
                    LayoutXmlProcessor.this.mResourceBundle.addLayoutBundle(bindingLayout);
                }
            }

            @Override
            public void processOtherFile(File parentFolder, File file) throws IOException {
                File outParent = this.convertToOutFile(parentFolder);
                FileUtils.copyFile((File)file, (File)new File(outParent, file.getName()));
            }

            @Override
            public void processRemovedLayoutFile(File file) {
                LayoutXmlProcessor.this.mResourceBundle.addRemovedFile(file);
            }

            @Override
            public void processRemovedOtherFile(File parentFolder, File file) throws IOException {
                File outParent = this.convertToOutFile(parentFolder);
                FileUtils.forceDelete((File)new File(outParent, file.getName()));
            }

            @Override
            public void processOtherFolder(File folder) {
                this.convertToOutFile(folder).mkdirs();
            }

            @Override
            public void processLayoutFolder(File folder) {
                this.convertToOutFile(folder).mkdirs();
            }

            @Override
            public void processOtherRootFile(File file) throws IOException {
                File outFile = this.convertToOutFile(file);
                if (file.isDirectory()) {
                    FileUtils.copyDirectory((File)file, (File)outFile);
                } else {
                    FileUtils.copyFile((File)file, (File)outFile);
                }
            }

            @Override
            public void processRemovedOtherRootFile(File file) throws IOException {
                File outFile = this.convertToOutFile(file);
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory((File)outFile);
                } else {
                    FileUtils.deleteQuietly((File)outFile);
                }
            }
        };
        if (input.isIncremental()) {
            LayoutXmlProcessor.processIncrementalInputFiles(input, callback);
        } else {
            LayoutXmlProcessor.processAllInputFiles(input, callback);
        }
        this.mProcessingComplete = true;
        return true;
    }

    public static String toSystemDependentPath(String path) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return path;
    }

    public void writeLayoutInfoFiles(File xmlOutDir) throws JAXBException {
        if (this.mWritten) {
            return;
        }
        for (List<ResourceBundle.LayoutFileBundle> layouts : this.mResourceBundle.getLayoutBundles().values()) {
            for (ResourceBundle.LayoutFileBundle layout : layouts) {
                this.writeXmlFile(xmlOutDir, layout);
            }
        }
        for (File file : this.mResourceBundle.getRemovedFiles()) {
            String exportFileName = LayoutXmlProcessor.generateExportFileName(file);
            FileUtils.deleteQuietly((File)new File(xmlOutDir, exportFileName));
        }
        this.mWritten = true;
    }

    private void writeXmlFile(File xmlOutDir, ResourceBundle.LayoutFileBundle layout) throws JAXBException {
        String filename = LayoutXmlProcessor.generateExportFileName(layout);
        this.mFileWriter.writeToFile(new File(xmlOutDir, filename), layout.toXML());
    }

    public String getInfoClassFullName() {
        return "android.databinding.layouts.DataBindingInfo";
    }

    private static String generateExportFileName(ResourceBundle.LayoutFileBundle layout) {
        return LayoutXmlProcessor.generateExportFileName(layout.getFileName(), layout.getDirectory());
    }

    private static String generateExportFileName(File file) {
        String fileName = file.getName();
        return LayoutXmlProcessor.generateExportFileName(fileName.substring(0, fileName.lastIndexOf(46)), file.getParentFile().getName());
    }

    public static String generateExportFileName(String fileName, String dirName) {
        return fileName + '-' + dirName + ".xml";
    }

    public static String exportLayoutNameFromInfoFileName(String infoFileName) {
        return infoFileName.substring(0, infoFileName.indexOf(45));
    }

    public void writeInfoClass(File sdkDir, File xmlOutDir, File exportClassListTo) {
        this.writeInfoClass(sdkDir, xmlOutDir, exportClassListTo, false, false);
    }

    public String getPackage() {
        return this.mResourceBundle.getAppPackage();
    }

    public void writeInfoClass(File sdkDir, File xmlOutDir, File exportClassListTo, boolean enableDebugLogs, boolean printEncodedErrorLogs) {
        String sdkPath = sdkDir == null ? null : StringEscapeUtils.escapeJava((String)sdkDir.getAbsolutePath());
        Class<BindingBuildInfo> annotation = BindingBuildInfo.class;
        String layoutInfoPath = StringEscapeUtils.escapeJava((String)xmlOutDir.getAbsolutePath());
        String exportClassListToPath = exportClassListTo == null ? "" : StringEscapeUtils.escapeJava((String)exportClassListTo.getAbsolutePath());
        String classString = "package android.databinding.layouts;\n\nimport " + annotation.getCanonicalName() + ";\n\n" + "@" + annotation.getSimpleName() + "(buildId=\"" + this.mBuildId + "\", " + "modulePackage=\"" + this.mResourceBundle.getAppPackage() + "\", " + "sdkRoot=" + "\"" + (sdkPath == null ? "" : sdkPath) + "\"," + "layoutInfoDir=\"" + layoutInfoPath + "\"," + "exportClassListTo=\"" + exportClassListToPath + "\"," + "isLibrary=" + this.mIsLibrary + "," + "minSdk=" + this.mMinSdk + "," + "enableDebugLogs=" + enableDebugLogs + "," + "printEncodedError=" + printEncodedErrorLogs + ")\n" + "public class " + CLASS_NAME + " {}\n";
        this.mFileWriter.writeToFile("android.databinding.layouts.DataBindingInfo", classString);
    }

    private static interface ProcessFileCallback {
        public void processLayoutFile(File var1) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException;

        public void processOtherFile(File var1, File var2) throws IOException;

        public void processRemovedLayoutFile(File var1);

        public void processRemovedOtherFile(File var1, File var2) throws IOException;

        public void processOtherFolder(File var1);

        public void processLayoutFolder(File var1);

        public void processOtherRootFile(File var1) throws IOException;

        public void processRemovedOtherRootFile(File var1) throws IOException;
    }

    public static class ResourceInput {
        private final boolean mIncremental;
        private final File mRootInputFolder;
        private final File mRootOutputFolder;
        private List<File> mAdded = new ArrayList<File>();
        private List<File> mRemoved = new ArrayList<File>();
        private List<File> mChanged = new ArrayList<File>();

        public ResourceInput(boolean incremental, File rootInputFolder, File rootOutputFolder) {
            this.mIncremental = incremental;
            this.mRootInputFolder = rootInputFolder;
            this.mRootOutputFolder = rootOutputFolder;
        }

        public void added(File file) {
            this.mAdded.add(file);
        }

        public void removed(File file) {
            this.mRemoved.add(file);
        }

        public void changed(File file) {
            this.mChanged.add(file);
        }

        public boolean shouldCopy() {
            return !this.mRootInputFolder.equals(this.mRootOutputFolder);
        }

        List<File> getAdded() {
            return this.mAdded;
        }

        List<File> getRemoved() {
            return this.mRemoved;
        }

        List<File> getChanged() {
            return this.mChanged;
        }

        File getRootInputFolder() {
            return this.mRootInputFolder;
        }

        File getRootOutputFolder() {
            return this.mRootOutputFolder;
        }

        public boolean isIncremental() {
            return this.mIncremental;
        }
    }

    public static interface OriginalFileLookup {
        public File getOriginalFileFor(File var1);
    }
}

