/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.testframework;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SettingsController;
import com.android.repository.testframework.MockFileOp;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class FakeDownloader
implements Downloader {
    private final MockFileOp mFileOp;

    public FakeDownloader(MockFileOp fop) {
        this.mFileOp = fop;
    }

    public void registerUrl(URL url, byte[] data) {
        String filename = this.getFileName(url);
        this.mFileOp.recordExistingFile(filename, data);
    }

    public void registerUrl(URL url, InputStream content) throws IOException {
        byte[] data = ByteStreams.toByteArray((InputStream)content);
        String filename = this.getFileName(url);
        this.mFileOp.recordExistingFile(filename, data);
    }

    public String getFileName(URL url) {
        return "/tmp" + url.getFile();
    }

    @Override
    public InputStream downloadAndStream(URL url, SettingsController controller, ProgressIndicator indicator) throws IOException {
        InputStream toWrap = null;
        try {
            toWrap = this.mFileOp.newFileInputStream(new File(this.getFileName(url)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (toWrap != null) {
            return new ReopeningInputStream(toWrap);
        }
        throw new IOException("Failed to open " + url);
    }

    @Override
    public File downloadFully(URL url, SettingsController settings, ProgressIndicator indicator) throws IOException {
        return new File(this.getFileName(url));
    }

    static class ReopeningInputStream
    extends InputStream {
        private InputStream mWrapped;

        public ReopeningInputStream(InputStream toWrap) {
            toWrap.mark(Integer.MAX_VALUE);
            this.mWrapped = toWrap;
        }

        @Override
        public int read() throws IOException {
            return this.mWrapped.read();
        }

        @Override
        public void close() throws IOException {
            this.mWrapped.reset();
        }

        public void reallyClose() throws IOException {
            this.mWrapped.close();
        }
    }
}

