/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.build.gradle.internal.core.MergedNdkConfig;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.core.VariantType;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GradleVariantConfiguration
extends VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> {
    private Boolean enableInstantRunOverride = null;
    private final MergedNdkConfig mMergedNdkConfig = new MergedNdkConfig();

    public GradleVariantConfiguration(CoreProductFlavor defaultConfig, SourceProvider defaultSourceProvider, CoreBuildType buildType, SourceProvider buildTypeSourceProvider, VariantType type, SigningConfig signingConfigOverride) {
        super((ProductFlavor)defaultConfig, defaultSourceProvider, (BuildType)buildType, buildTypeSourceProvider, type, signingConfigOverride);
        this.computeNdkConfig();
    }

    public GradleVariantConfiguration(VariantConfiguration testedConfig, CoreProductFlavor defaultConfig, SourceProvider defaultSourceProvider, CoreBuildType buildType, SourceProvider buildTypeSourceProvider, VariantType type, SigningConfig signingConfigOverride) {
        super((ProductFlavor)defaultConfig, defaultSourceProvider, (BuildType)buildType, buildTypeSourceProvider, type, testedConfig, signingConfigOverride);
        this.computeNdkConfig();
    }

    public VariantConfiguration addProductFlavor(CoreProductFlavor productFlavor, SourceProvider sourceProvider, String dimensionName) {
        Preconditions.checkNotNull((Object)productFlavor);
        Preconditions.checkNotNull((Object)sourceProvider);
        Preconditions.checkNotNull((Object)dimensionName);
        super.addProductFlavor((ProductFlavor)productFlavor, sourceProvider, dimensionName);
        this.computeNdkConfig();
        return this;
    }

    public CoreNdkOptions getNdkConfig() {
        return this.mMergedNdkConfig;
    }

    public Set<String> getSupportedAbis() {
        return this.mMergedNdkConfig.getAbiFilters();
    }

    public boolean isMinifyEnabled() {
        VariantType type = this.getType();
        return ((CoreBuildType)this.getBuildType()).isMinifyEnabled() && (!type.isForTesting() || this.getTestedConfig().getType() != VariantType.LIBRARY);
    }

    public boolean getUseJack() {
        Boolean value = ((CoreBuildType)this.getBuildType()).getJackOptions().isEnabled();
        if (value != null) {
            return value;
        }
        for (CoreProductFlavor productFlavor : this.getProductFlavors()) {
            value = productFlavor.getJackOptions().isEnabled();
            if (value == null) continue;
            return value;
        }
        value = ((CoreProductFlavor)this.getDefaultConfig()).getJackOptions().isEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public boolean isJackInProcess() {
        Boolean value = ((CoreBuildType)this.getBuildType()).getJackOptions().isJackInProcess();
        if (value != null) {
            return value;
        }
        for (CoreProductFlavor productFlavor : this.getProductFlavors()) {
            value = productFlavor.getJackOptions().isJackInProcess();
            if (value == null) continue;
            return value;
        }
        value = ((CoreProductFlavor)this.getDefaultConfig()).getJackOptions().isJackInProcess();
        if (value != null) {
            return value;
        }
        return true;
    }

    private void computeNdkConfig() {
        this.mMergedNdkConfig.reset();
        if (((CoreProductFlavor)this.getDefaultConfig()).getNdkConfig() != null) {
            this.mMergedNdkConfig.append(((CoreProductFlavor)this.getDefaultConfig()).getNdkConfig());
        }
        List flavors = this.getProductFlavors();
        for (int i = flavors.size() - 1; i >= 0; --i) {
            CoreNdkOptions ndkConfig = ((CoreProductFlavor)flavors.get(i)).getNdkConfig();
            if (ndkConfig == null) continue;
            this.mMergedNdkConfig.append(ndkConfig);
        }
        if (((CoreBuildType)this.getBuildType()).getNdkConfig() != null && !this.getType().isForTesting()) {
            this.mMergedNdkConfig.append(((CoreBuildType)this.getBuildType()).getNdkConfig());
        }
    }

    public boolean isInstantRunSupported() {
        if (this.enableInstantRunOverride != null) {
            return this.enableInstantRunOverride;
        }
        return ((CoreBuildType)this.getBuildType()).isDebuggable() && !this.getType().isForTesting() && !this.getUseJack();
    }

    public void setEnableInstantRunOverride(Boolean enableInstantRunOverride) {
        this.enableInstantRunOverride = enableInstantRunOverride;
    }

    public List<String> getDefautGlslcArgs() {
        HashMap optionMap = Maps.newHashMap();
        for (String option : ((CoreProductFlavor)this.getDefaultConfig()).getShaders().getGlslcArgs()) {
            optionMap.put(GradleVariantConfiguration.getKey(option), option);
        }
        List flavors = this.getProductFlavors();
        for (int i = flavors.size() - 1; i >= 0; --i) {
            for (String option : ((CoreProductFlavor)flavors.get(i)).getShaders().getGlslcArgs()) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
        }
        for (String option : ((CoreBuildType)this.getBuildType()).getShaders().getGlslcArgs()) {
            optionMap.put(GradleVariantConfiguration.getKey(option), option);
        }
        return Lists.newArrayList(optionMap.values());
    }

    public Map<String, List<String>> getScopedGlslcArgs() {
        HashMap scopedArgs = Maps.newHashMap();
        Set<String> keys = this.getScopedGlslcKeys();
        for (String key : keys) {
            HashMap optionMap = Maps.newHashMap();
            for (String option : ((CoreProductFlavor)this.getDefaultConfig()).getShaders().getGlslcArgs()) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            for (String option : ((CoreProductFlavor)this.getDefaultConfig()).getShaders().getScopedGlslcArgs().get((Object)key)) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            List flavors = this.getProductFlavors();
            for (int i = flavors.size() - 1; i >= 0; --i) {
                for (String option : ((CoreProductFlavor)flavors.get(i)).getShaders().getGlslcArgs()) {
                    optionMap.put(GradleVariantConfiguration.getKey(option), option);
                }
                for (String option : ((CoreProductFlavor)flavors.get(i)).getShaders().getScopedGlslcArgs().get((Object)key)) {
                    optionMap.put(GradleVariantConfiguration.getKey(option), option);
                }
            }
            for (String option : ((CoreBuildType)this.getBuildType()).getShaders().getGlslcArgs()) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            for (String option : ((CoreBuildType)this.getBuildType()).getShaders().getScopedGlslcArgs().get((Object)key)) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            scopedArgs.put(key, ImmutableList.copyOf(optionMap.values()));
        }
        return scopedArgs;
    }

    private Set<String> getScopedGlslcKeys() {
        HashSet keys = Sets.newHashSet();
        keys.addAll(((CoreProductFlavor)this.getDefaultConfig()).getShaders().getScopedGlslcArgs().keySet());
        for (CoreProductFlavor flavor : this.getProductFlavors()) {
            keys.addAll(flavor.getShaders().getScopedGlslcArgs().keySet());
        }
        keys.addAll(((CoreBuildType)this.getBuildType()).getShaders().getScopedGlslcArgs().keySet());
        return keys;
    }

    private static String getKey(String fullOption) {
        int pos = fullOption.lastIndexOf(61);
        if (pos == -1) {
            return fullOption;
        }
        return fullOption.substring(0, pos);
    }
}

