/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.ConfigurationProvider;
import com.android.build.gradle.internal.ConfigurationProviderImpl;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.builder.core.VariantType;
import org.gradle.api.Project;

public class VariantDimensionData {
    private final DefaultAndroidSourceSet sourceSet;
    private final DefaultAndroidSourceSet androidTestSourceSet;
    private final DefaultAndroidSourceSet unitTestSourceSet;
    private final ConfigurationProvider mainProvider;
    private final ConfigurationProvider androidTestProvider;
    private final ConfigurationProvider unitTestProvider;

    public VariantDimensionData(DefaultAndroidSourceSet sourceSet, DefaultAndroidSourceSet androidTestSourceSet, DefaultAndroidSourceSet unitTestSourceSet, Project project) {
        this.sourceSet = sourceSet;
        this.androidTestSourceSet = androidTestSourceSet;
        this.unitTestSourceSet = unitTestSourceSet;
        this.mainProvider = new ConfigurationProviderImpl(project, sourceSet);
        this.androidTestProvider = androidTestSourceSet != null ? new ConfigurationProviderImpl(project, androidTestSourceSet) : null;
        this.unitTestProvider = unitTestSourceSet != null ? new ConfigurationProviderImpl(project, unitTestSourceSet) : null;
    }

    public ConfigurationProvider getMainProvider() {
        return this.mainProvider;
    }

    public DefaultAndroidSourceSet getSourceSet() {
        return this.sourceSet;
    }

    public DefaultAndroidSourceSet getTestSourceSet(VariantType type) {
        switch (type) {
            case ANDROID_TEST: {
                return this.androidTestSourceSet;
            }
            case UNIT_TEST: {
                return this.unitTestSourceSet;
            }
        }
        throw VariantDimensionData.unknownTestType(type);
    }

    public ConfigurationProvider getTestConfigurationProvider(VariantType type) {
        switch (type) {
            case ANDROID_TEST: {
                return this.androidTestProvider;
            }
            case UNIT_TEST: {
                return this.unitTestProvider;
            }
        }
        throw VariantDimensionData.unknownTestType(type);
    }

    private static RuntimeException unknownTestType(VariantType type) {
        throw new IllegalArgumentException(String.format("Unknown test variant type %s", type));
    }
}

