/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.LibraryJarTransform;
import com.android.build.gradle.internal.tasks.LibraryJniLibsTransform;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.LibVariantOutputData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.MergeResources;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantConfiguration;
import com.android.builder.dependency.LibraryBundle;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.dependency.ManifestDependency;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.profile.ExecutionType;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class LibraryTaskManager
extends TaskManager {
    private static final String ANNOTATIONS = "annotations";
    private Task assembleDefault;

    public LibraryTaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry) {
        super(project, androidBuilder, dataBindingBuilder, extension, sdkHandler, ndkHandler, dependencyManager, toolingRegistry);
    }

    @Override
    public void createTasksForVariantData(final TaskFactory tasks, final BaseVariantData<? extends BaseVariantOutputData> variantData) {
        LibraryVariantData libVariantData = (LibraryVariantData)variantData;
        final GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        final CoreBuildType buildType = (CoreBuildType)variantConfig.getBuildType();
        final VariantScope variantScope = variantData.getScope();
        GlobalScope globalScope = variantScope.getGlobalScope();
        File intermediatesDir = globalScope.getIntermediatesDir();
        Collection variantDirectorySegments = variantConfig.getDirectorySegments();
        final File variantBundleDir = FileUtils.join((File)intermediatesDir, (Iterable)StringHelper.toStrings((Object[])new Object[]{"bundles", variantDirectorySegments}));
        this.createAnchorTasks(tasks, variantScope);
        this.createDependencyStreams(variantScope);
        this.createCheckManifestTask(tasks, variantScope);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createGenerateResValuesTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createMergeLibManifestsTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createRenderscriptTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        AndroidTask packageRes = (AndroidTask)ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, (Recorder.Block)new Recorder.Block<AndroidTask<MergeResources>>(){

            public AndroidTask<MergeResources> call() throws Exception {
                AndroidTask<MergeResources> mergeResourceTask = LibraryTaskManager.this.basicCreateMergeResourcesTask(tasks, variantScope, "package", FileUtils.join((File)variantBundleDir, (String[])new String[]{"res"}), false, false);
                if (variantData.getVariantDependency().hasNonOptionalLibraries()) {
                    LibraryTaskManager.this.createMergeResourcesTask(tasks, variantScope);
                }
                mergeResourceTask.configure(tasks, new Action<Task>(){

                    public void execute(Task task) {
                        MergeResources mergeResourcesTask = (MergeResources)task;
                        mergeResourcesTask.setPublicFile(FileUtils.join((File)variantBundleDir, (String[])new String[]{"public.txt"}));
                    }
                });
                return mergeResourceTask;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                LibraryTaskManager.this.createMergeAssetsTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createBuildConfigTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_PROCESS_RES_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createProcessResTask(tasks, variantScope, variantBundleDir, false);
                LibraryTaskManager.this.createProcessJavaResTasks(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_AIDL_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createAidlTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_SHADER_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() {
                LibraryTaskManager.this.createShaderTask(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_COMPILE_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                AndroidTask<? extends JavaCompile> javacTask = LibraryTaskManager.this.createJavacTask(tasks, variantScope);
                TaskManager.setJavaCompilerTask(javacTask, tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
        if (this.extension.getDataBinding().isEnabled()) {
            this.createDataBindingTasks(tasks, variantScope);
        }
        if (!this.isComponentModelPlugin) {
            ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_NDK_TASK, (Recorder.Block)new Recorder.Block<Void>(){

                public Void call() throws Exception {
                    LibraryTaskManager.this.createNdkTasks(variantScope);
                    return null;
                }
            }, new Recorder.Property[0]);
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.createMergeJniLibFoldersTasks(tasks, variantScope);
        Sync packageRenderscript = (Sync)ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_PACKAGING_TASK, (Recorder.Block)new Recorder.Block<Sync>(){

            public Sync call() throws Exception {
                Sync packageRenderscript = (Sync)LibraryTaskManager.this.project.getTasks().create(variantScope.getTaskName("package", "Renderscript"), Sync.class);
                packageRenderscript.from(new Object[]{variantConfig.getRenderscriptSourceList()}).include(new String[]{"**/*.rsh"});
                packageRenderscript.into((Object)new File(variantBundleDir, "rs"));
                return packageRenderscript;
            }
        }, new Recorder.Property[0]);
        MergeFileTask mergeProGuardFileTask = (MergeFileTask)((Object)ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_MERGE_PROGUARD_FILE_TASK, (Recorder.Block)new Recorder.Block<MergeFileTask>(){

            public MergeFileTask call() throws Exception {
                MergeFileTask mergeProGuardFileTask = (MergeFileTask)LibraryTaskManager.this.project.getTasks().create(variantScope.getTaskName("merge", "ProguardFiles"), MergeFileTask.class);
                mergeProGuardFileTask.setVariantName(variantConfig.getFullName());
                mergeProGuardFileTask.setInputFiles(LibraryTaskManager.this.project.files(new Object[]{variantConfig.getConsumerProguardFiles()}).getFiles());
                mergeProGuardFileTask.setOutputFile(new File(variantBundleDir, "proguard.txt"));
                return mergeProGuardFileTask;
            }
        }, new Recorder.Property[0]));
        Copy lintCopy = (Copy)this.project.getTasks().create(variantScope.getTaskName("copy", "Lint"), Copy.class);
        lintCopy.dependsOn(new Object[]{"compileLint"});
        lintCopy.from(new Object[]{new File(globalScope.getIntermediatesDir(), "lint/lint.jar")});
        lintCopy.into((Object)variantBundleDir);
        final Zip bundle = (Zip)this.project.getTasks().create(variantScope.getTaskName("bundle"), Zip.class);
        if (variantData.getVariantDependency().isAnnotationsPresent()) {
            libVariantData.generateAnnotationsTask = this.createExtractAnnotations(this.project, variantData);
        }
        if (libVariantData.generateAnnotationsTask != null) {
            bundle.dependsOn(new Object[]{libVariantData.generateAnnotationsTask});
        }
        final boolean instrumented = ((CoreBuildType)variantConfig.getBuildType()).isTestCoverageEnabled();
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_POST_COMPILATION_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                String packageName;
                TransformManager transformManager = variantScope.getTransformManager();
                if (instrumented) {
                    LibraryTaskManager.this.createJacocoTransform(tasks, variantScope);
                }
                List<Transform> customTransforms = LibraryTaskManager.this.extension.getTransforms();
                List<List<Object>> customTransformsDependencies = LibraryTaskManager.this.extension.getTransformsDependencies();
                int count = customTransforms.size();
                for (int i = 0; i < count; ++i) {
                    AndroidTask<TransformTask> task;
                    Transform transform = customTransforms.get(i);
                    Sets.SetView difference = Sets.difference((Set)transform.getScopes(), TransformManager.SCOPE_FULL_LIBRARY);
                    if (!difference.isEmpty()) {
                        String scopes = difference.toString();
                        LibraryTaskManager.this.androidBuilder.getErrorReporter().handleSyncError("", 0, String.format("Transforms with scopes '%s' cannot be applied to library projects.", scopes));
                    }
                    if ((task = transformManager.addTransform(tasks, variantScope, transform)) == null) continue;
                    List<Object> deps = customTransformsDependencies.get(i);
                    if (!deps.isEmpty()) {
                        task.dependsOn(tasks, deps);
                    }
                    if (!transform.getScopes().isEmpty()) continue;
                    variantData.assembleVariantTask.dependsOn(new Object[]{tasks, task});
                }
                if (buildType.isMinifyEnabled()) {
                    LibraryTaskManager.this.createMinifyTransform(tasks, variantScope, false);
                }
                if ((packageName = variantConfig.getPackageFromManifest()) == null) {
                    throw new BuildException("Failed to read manifest", null);
                }
                LibraryJarTransform transform = new LibraryJarTransform(new File(variantBundleDir, "classes.jar"), new File(variantBundleDir, "libs"), packageName, LibraryTaskManager.this.getExtension().getPackageBuildConfig());
                LibraryTaskManager.this.excludeDataBindingClassesIfNecessary(variantScope, transform);
                AndroidTask<TransformTask> jarPackagingTask = transformManager.addTransform(tasks, variantScope, transform);
                bundle.dependsOn(new Object[]{jarPackagingTask.getName()});
                LibraryJniLibsTransform jniTransform = new LibraryJniLibsTransform(new File(variantBundleDir, "jni"));
                AndroidTask<TransformTask> jniPackagingTask = transformManager.addTransform(tasks, variantScope, jniTransform);
                bundle.dependsOn(new Object[]{jniPackagingTask.getName()});
                return null;
            }
        }, new Recorder.Property[0]);
        bundle.dependsOn(new Object[]{packageRes.getName(), packageRenderscript, lintCopy, mergeProGuardFileTask});
        bundle.dependsOn(new Object[]{variantScope.getNdkBuildable()});
        bundle.setDescription("Assembles a bundle containing the library in " + variantConfig.getFullName() + ".");
        bundle.setDestinationDir(new File(globalScope.getOutputsDir(), "aar"));
        bundle.setArchiveName(globalScope.getProjectBaseName() + "-" + variantConfig.getBaseName() + "." + "aar");
        bundle.setExtension("aar");
        bundle.from(new Object[]{variantBundleDir});
        bundle.from(new Object[]{FileUtils.join((File)intermediatesDir, (Iterable)StringHelper.toStrings((Object[])new Object[]{ANNOTATIONS, variantDirectorySegments}))});
        LibVariantOutputData variantOutputData = (LibVariantOutputData)libVariantData.getOutputs().get(0);
        variantOutputData.packageLibTask = bundle;
        variantData.assembleVariantTask.dependsOn(new Object[]{bundle});
        variantOutputData.assembleTask = variantData.assembleVariantTask;
        if (this.getExtension().getDefaultPublishConfig().equals(variantConfig.getFullName())) {
            VariantHelper.setupDefaultConfig(this.project, variantData.getVariantDependency().getPackageConfiguration());
            this.project.getArtifacts().add("default", (Object)bundle);
            this.getAssembleDefault().dependsOn(new Object[]{variantData.assembleVariantTask});
        }
        if (this.getExtension().getPublishNonDefault()) {
            this.project.getArtifacts().add(variantData.getVariantDependency().getPublishConfiguration().getName(), (Object)bundle);
            bundle.setClassifier(variantData.getVariantDependency().getPublishConfiguration().getName());
        }
        variantConfig.setOutput((LibraryDependency)new LibraryBundle(bundle.getArchivePath(), variantBundleDir, variantData.getName(), this.project.getPath()){

            public String getProjectVariant() {
                return variantData.getName();
            }

            public List<LibraryDependency> getDependencies() {
                return variantConfig.getDirectLibraries();
            }

            public List<? extends AndroidLibrary> getLibraryDependencies() {
                return variantConfig.getDirectLibraries();
            }

            public List<? extends ManifestDependency> getManifestDependencies() {
                return variantConfig.getDirectLibraries();
            }

            public MavenCoordinates getRequestedCoordinates() {
                return null;
            }

            public MavenCoordinates getResolvedCoordinates() {
                return null;
            }

            protected File getJarsRootFolder() {
                return this.getFolder();
            }

            public boolean isOptional() {
                return false;
            }
        });
        ThreadRecorder.get().record(ExecutionType.LIB_TASK_MANAGER_CREATE_LINT_TASK, (Recorder.Block)new Recorder.Block<Void>(){

            public Void call() throws Exception {
                LibraryTaskManager.this.createLintTasks(tasks, variantScope);
                return null;
            }
        }, new Recorder.Property[0]);
    }

    private void excludeDataBindingClassesIfNecessary(final VariantScope variantScope, LibraryJarTransform transform) {
        if (!this.extension.getDataBinding().isEnabled()) {
            return;
        }
        transform.addExcludeListProvider(new LibraryJarTransform.ExcludeListProvider(){

            @Override
            public List<String> getExcludeList() {
                File excludeFile = variantScope.getVariantData().getType().isExportDataBindingClassList() ? variantScope.getGeneratedClassListOutputFileForDataBinding() : null;
                return LibraryTaskManager.this.dataBindingBuilder.getJarExcludeList(variantScope.getVariantData().getLayoutXmlProcessor(), excludeFile);
            }
        });
    }

    @Override
    protected Set<QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        if (variantScope.getTestedVariantData() != null) {
            return TransformManager.SCOPE_FULL_PROJECT;
        }
        return TransformManager.SCOPE_FULL_LIBRARY;
    }

    public ExtractAnnotations createExtractAnnotations(final Project project, BaseVariantData variantData) {
        final GradleVariantConfiguration config = variantData.getVariantConfiguration();
        ExtractAnnotations task = (ExtractAnnotations)project.getTasks().create(variantData.getScope().getTaskName("extract", "Annotations"), ExtractAnnotations.class);
        task.setDescription("Extracts Android annotations for the " + variantData.getVariantConfiguration().getFullName() + " variant into the archive file");
        task.setGroup("build");
        task.variant = variantData;
        task.setDestinationDir(new File(variantData.getScope().getGlobalScope().getIntermediatesDir(), "annotations/" + config.getDirName()));
        task.output = new File(task.getDestinationDir(), "annotations.zip");
        task.classDir = new File(variantData.getScope().getGlobalScope().getIntermediatesDir(), "classes/" + variantData.getVariantConfiguration().getDirName());
        task.setSource(variantData.getJavaSources());
        task.encoding = this.getExtension().getCompileOptions().getEncoding();
        task.setSourceCompatibility(this.getExtension().getCompileOptions().getSourceCompatibility().toString());
        ConventionMappingHelper.map((Task)task, "classpath", new Callable<ConfigurableFileCollection>(){

            @Override
            public ConfigurableFileCollection call() throws Exception {
                return project.files(new Object[]{LibraryTaskManager.this.androidBuilder.getCompileClasspath((VariantConfiguration)config)});
            }
        });
        task.dependsOn(new Object[]{variantData.getScope().getJavacTask().getName()});
        task.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                if (task instanceof ExtractAnnotations) {
                    ExtractAnnotations extractAnnotations = (ExtractAnnotations)task;
                    extractAnnotations.bootClasspath = LibraryTaskManager.this.androidBuilder.getBootClasspathAsStrings(false);
                }
            }
        });
        return task;
    }

    private Task getAssembleDefault() {
        if (this.assembleDefault == null) {
            this.assembleDefault = (Task)this.project.getTasks().findByName("assembleDefault");
        }
        return this.assembleDefault;
    }
}

