/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.ui;

import com.google.gct.testing.ui.WipePanelCallback;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.MatteBorder;

public class WipePanel
extends JPanel {
    private long start;
    private float percentRevealed;
    private int fullHeight;
    private int fullWidth;
    private BufferedImage buffer;
    private State state = State.hidden;

    public WipePanel() {
        this.setLayout(new BorderLayout());
    }

    public void setContentPanel(JPanel contents) {
        this.add(contents);
    }

    @Override
    public void paint(Graphics g) {
        if (this.state == State.hidden) {
            this.setVisible(false);
        } else if (this.state == State.revealing || this.state == State.hiding) {
            this.setVisible(true);
            int width = (int)((float)this.fullWidth * this.percentRevealed);
            this.setSize(width, this.fullHeight);
            g.clearRect(0, 0, this.fullWidth, this.fullHeight);
            g.drawImage(this.buffer, 0, 0, this);
        } else {
            this.setVisible(true);
            super.paint(g);
        }
    }

    public void instantReveal(final WipePanelCallback callBack) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WipePanel.this.reveal(-1, callBack);
            }
        });
    }

    public void reveal(final WipePanelCallback callBack) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WipePanel.this.reveal(300, callBack);
            }
        });
    }

    public void unReveal(final WipePanelCallback callBack) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WipePanel.this.unReveal(300, callBack);
            }
        });
    }

    private void reveal(final int totalTimeMillis, final WipePanelCallback callBack) {
        this.start = System.currentTimeMillis();
        this.state = State.revealed;
        this.buffer = UIUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)2);
        this.print(this.buffer.getGraphics());
        this.state = State.revealing;
        this.fullWidth = this.buffer.getWidth();
        this.fullHeight = this.buffer.getHeight();
        this.percentRevealed = 0.01f;
        final Timer t = new Timer(10, null);
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long elapsed = System.currentTimeMillis() - WipePanel.this.start;
                if (elapsed > (long)totalTimeMillis) {
                    WipePanel.this.setSize(WipePanel.this.fullWidth, WipePanel.this.fullHeight);
                    t.stop();
                    WipePanel.this.state = State.revealed;
                    if (callBack != null) {
                        callBack.panelRevealed();
                    }
                } else {
                    WipePanel.this.percentRevealed = (float)elapsed / (float)totalTimeMillis;
                }
                WipePanel.this.repaint();
            }
        });
        t.start();
    }

    private void unReveal(final int millis, final WipePanelCallback callBack) {
        this.start = System.currentTimeMillis();
        this.state = State.revealed;
        this.buffer = UIUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)2);
        this.print(this.buffer.getGraphics());
        this.state = State.hiding;
        this.fullWidth = this.buffer.getWidth();
        this.fullHeight = this.buffer.getHeight();
        this.percentRevealed = 0.99f;
        final WipePanel thisPanel = this;
        final Timer t = new Timer(10, null);
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long elapsed = System.currentTimeMillis() - WipePanel.this.start;
                if (elapsed > (long)millis) {
                    t.stop();
                    WipePanel.this.setSize(WipePanel.this.fullWidth, WipePanel.this.fullHeight);
                    WipePanel.this.setVisible(false);
                    WipePanel.this.state = State.hidden;
                    if (callBack != null) {
                        callBack.panelHidden(thisPanel);
                    }
                } else {
                    WipePanel.this.percentRevealed = 1.0f - (float)elapsed / (float)millis;
                }
                WipePanel.this.repaint();
            }
        });
        t.start();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JFrame frame = new JFrame(WipePanel.class.getSimpleName());
                    frame.setDefaultCloseOperation(3);
                    JPanel mainPanel = new JPanel(new BorderLayout());
                    frame.add(mainPanel);
                    JPanel centerPanel = new JPanel(new FlowLayout());
                    mainPanel.add((Component)centerPanel, "Center");
                    final WipePanel wipe = new WipePanel();
                    centerPanel.add(wipe);
                    JPanel contentsPanel = new JPanel();
                    contentsPanel.setBorder(new MatteBorder(2, 2, 2, 2, Color.BLUE));
                    wipe.setContentPanel(contentsPanel);
                    JTextField textfield = new JTextField(50);
                    JLabel image = new JLabel(new ImageIcon(new URL("http://helios.gsfc.nasa.gov/image_mag_stamp.jpg")));
                    contentsPanel.add(textfield);
                    contentsPanel.add(image);
                    JButton button = new JButton("Show");
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            wipe.reveal(null);
                        }
                    });
                    JButton button2 = new JButton("Hide");
                    button2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            wipe.unReveal(null);
                        }
                    });
                    JPanel buttonPanel = new JPanel(new FlowLayout());
                    buttonPanel.add(button);
                    buttonPanel.add(button2);
                    mainPanel.add((Component)buttonPanel, "South");
                    JLabel image2 = new JLabel(new ImageIcon(new URL("http://img2.wikia.nocookie.net/__cb20110226214654/logopedia/images/a/ab/Google_logo_Sept-Oct_1998.png")));
                    centerPanel.add(image2);
                    frame.pack();
                    frame.setVisible(true);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static enum State {
        hidden,
        revealing,
        hiding,
        revealed;

    }
}

