/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.config;

import com.google.gct.testing.config.GoogleCloudTestingDeveloperSettings;
import com.google.gct.testing.launcher.CloudAuthenticator;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingDeveloperConfigurable
implements OptionalConfigurable,
SearchableConfigurable,
Configurable.NoScroll {
    public static final String SHOW_GOOGLE_CLOUD_TESTING_SETTINGS = "show.google.cloud.testing.settings";
    private final Project project;
    private JPanel panel;
    private JCheckBox useFakeBucketCheckbox = new JCheckBox();
    private JTextField fakeBucketNameField = new JTextField();
    private JRadioButton useProd = new JRadioButton("Prod");
    private JTextField prodUrlField = new JTextField("https://testing.googleapis.com");
    private JRadioButton useStaging = new JRadioButton("Staging");
    private JTextField stagingUrlField = new JTextField("https://staging-testing.sandbox.googleapis.com");
    private JRadioButton useTest = new JRadioButton("Test");
    private JTextField testUrlField = new JTextField("https://test-testing.sandbox.googleapis.com");
    private JRadioButton useCustom = new JRadioButton("Custom");
    private JTextField customUrlField = new JTextField("");

    public GoogleCloudTestingDeveloperConfigurable(Project project) {
        this.project = project;
    }

    @Nls
    public String getDisplayName() {
        return "Google Cloud Testing Developer";
    }

    @Nullable
    public String getHelpTopic() {
        return "google.cloud.testing.developer";
    }

    public JComponent createComponent() {
        this.panel = new JPanel(new BorderLayout(5, 10));
        JPanel content = new JPanel(new GridBagLayout());
        this.panel.add((Component)content, "North");
        this.useFakeBucketCheckbox.setText("Use fake bucket:");
        content.add((Component)this.useFakeBucketCheckbox, this.createSettingsGbc(0, 1));
        content.add((Component)this.fakeBucketNameField, this.createSettingsGbc(1, 1));
        ButtonGroup urlGroup = new ButtonGroup();
        urlGroup.add(this.useProd);
        urlGroup.add(this.useStaging);
        urlGroup.add(this.useTest);
        urlGroup.add(this.useCustom);
        this.prodUrlField.setEditable(false);
        this.stagingUrlField.setEditable(false);
        this.testUrlField.setEditable(false);
        content.add((Component)new JLabel("Backend URL to use for test requests:"), this.createSettingsGbc(0, 2));
        content.add((Component)this.useProd, this.createSettingsGbc(0, 3));
        content.add((Component)this.prodUrlField, this.createSettingsGbc(1, 3));
        content.add((Component)this.useStaging, this.createSettingsGbc(0, 4));
        content.add((Component)this.stagingUrlField, this.createSettingsGbc(1, 4));
        content.add((Component)this.useTest, this.createSettingsGbc(0, 5));
        content.add((Component)this.testUrlField, this.createSettingsGbc(1, 5));
        content.add((Component)this.useCustom, this.createSettingsGbc(0, 6));
        content.add((Component)this.customUrlField, this.createSettingsGbc(1, 6));
        return this.panel;
    }

    private GridBagConstraints createGbc(int x, int y, int gridheight, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.anchor = x == 0 ? 17 : 17;
        gbc.weightx = x == 0 ? 0.0 : 1.0;
        gbc.weighty = weighty;
        gbc.gridheight = gridheight;
        return gbc;
    }

    private GridBagConstraints createSettingsGbc(int x, int y) {
        return this.createGbc(x, y, 1, 0.0);
    }

    public boolean isModified() {
        GoogleCloudTestingDeveloperState state = this.getSavedSettings().getState();
        String stateFakeBucketName = state == null ? "" : state.fakeBucketName;
        boolean stateShouldUseFakeBucket = state == null ? false : state.shouldUseFakeBucket;
        int backendOption = state == null ? 0 : state.backendOption;
        String customUrl = state == null ? "" : state.customUrl;
        return !stateFakeBucketName.equals(this.fakeBucketNameField.getText()) || stateShouldUseFakeBucket != this.useFakeBucketCheckbox.isSelected() || backendOption != this.getBackendOption().ordinal() || !customUrl.equals(this.customUrlField.getText());
    }

    public void apply() throws ConfigurationException {
        GoogleCloudTestingDeveloperState state = new GoogleCloudTestingDeveloperState();
        state.fakeBucketName = this.fakeBucketNameField.getText();
        state.shouldUseFakeBucket = this.useFakeBucketCheckbox.isSelected();
        state.backendOption = this.getBackendOption().ordinal();
        state.backendUrl = this.getTestBackendUrl();
        state.customUrl = this.customUrlField.getText();
        this.getSavedSettings().loadState(state);
        CloudAuthenticator.recreateTestAndToolResults(this.getTestBackendUrl(), this.getToolResultsBackendUrl());
    }

    public void reset() {
        GoogleCloudTestingDeveloperState state = this.getSavedSettings().getState();
        this.fakeBucketNameField.setText(state == null ? "" : state.fakeBucketName);
        this.useFakeBucketCheckbox.setSelected(state == null ? false : state.shouldUseFakeBucket);
        this.setBackendOption(BackendOption.values()[state == null ? 0 : state.backendOption]);
        this.customUrlField.setText(state == null ? "" : state.customUrl);
        CloudAuthenticator.recreateTestAndToolResults(this.getTestBackendUrl(), this.getToolResultsBackendUrl());
    }

    private BackendOption getBackendOption() {
        if (this.useProd.isSelected()) {
            return BackendOption.PROD;
        }
        if (this.useStaging.isSelected()) {
            return BackendOption.STAGING;
        }
        if (this.useTest.isSelected()) {
            return BackendOption.TEST;
        }
        if (this.useCustom.isSelected()) {
            return BackendOption.CUSTOM;
        }
        throw new RuntimeException("No URL option is selected!");
    }

    private String getTestBackendUrl() {
        switch (this.getBackendOption()) {
            case PROD: {
                return this.prodUrlField.getText();
            }
            case STAGING: {
                return this.stagingUrlField.getText();
            }
            case TEST: {
                return this.testUrlField.getText();
            }
            case CUSTOM: {
                return this.customUrlField.getText();
            }
        }
        throw new RuntimeException("No URL option is selected!");
    }

    private String getToolResultsBackendUrl() {
        switch (this.getBackendOption()) {
            case STAGING: 
            case TEST: {
                return "https://www-googleapis-test.sandbox.google.com/";
            }
        }
        return "https://www.googleapis.com/";
    }

    private void setBackendOption(BackendOption backendOption) {
        switch (backendOption) {
            case PROD: {
                this.useProd.setSelected(true);
                break;
            }
            case STAGING: {
                this.useStaging.setSelected(true);
                break;
            }
            case TEST: {
                this.useTest.setSelected(true);
                break;
            }
            case CUSTOM: {
                this.useCustom.setSelected(true);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported backend option: " + (Object)((Object)backendOption));
            }
        }
    }

    private GoogleCloudTestingDeveloperSettings getSavedSettings() {
        return GoogleCloudTestingDeveloperSettings.getInstance(this.project);
    }

    public void disposeUIResources() {
        this.panel = null;
        this.useFakeBucketCheckbox = null;
        this.fakeBucketNameField = null;
        this.useProd = null;
        this.prodUrlField = null;
        this.useStaging = null;
        this.stagingUrlField = null;
        this.useTest = null;
        this.testUrlField = null;
        this.useCustom = null;
        this.customUrlField = null;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/config/GoogleCloudTestingDeveloperConfigurable", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    public boolean needDisplay() {
        return Boolean.getBoolean(SHOW_GOOGLE_CLOUD_TESTING_SETTINGS);
    }

    public static class GoogleCloudTestingDeveloperState {
        public String fakeBucketName = "";
        public boolean shouldUseFakeBucket = false;
        public int backendOption = 0;
        public String backendUrl = "";
        public String customUrl = "";
    }

    static enum BackendOption {
        PROD,
        STAGING,
        TEST,
        CUSTOM;

    }
}

