/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.gct.testing.CloudConfigurationHelper;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CloudOptionEnablementChecker
implements ApplicationComponent {
    private static final String ENABLE_CLOUD_TESTING_REMOTELY = "com.google.gct.enable.cloud.testing";
    private static final String ENABLE_CLOUD_DEBUGGING_REMOTELY = "com.google.gct.enable.cloud.debugging";
    private static final String LOCAL_ENABLE_CLOUD_TESTING_FLAG = "enable.google.cloud.testing.plugin";
    private static final String LOCAL_ENABLE_CLOUD_DEBUGGING_FLAG = "enable.google.cloud.debugging";

    public void initComponent() {
        this.scheduleCheckingCloudOption(false);
        this.scheduleCheckingCloudOption(true);
    }

    private void scheduleCheckingCloudOption(boolean isDebugging) {
        if (!CloudOptionEnablementChecker.isCloudOptionEnabled(isDebugging)) {
            JobScheduler.getScheduler().schedule(new CloudOptionEnablementCheckerRunnable(isDebugging), 20L, TimeUnit.SECONDS);
        }
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("CloudOptionEnablementChecker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/CloudOptionEnablementChecker", "getComponentName"));
        }
        return "CloudOptionEnablementChecker";
    }

    public static boolean isCloudTestingEnabled() {
        return CloudOptionEnablementChecker.isCloudOptionEnabled(false);
    }

    public static boolean isCloudDebuggingEnabled() {
        return CloudOptionEnablementChecker.isCloudOptionEnabled(true);
    }

    private static boolean isCloudOptionEnabled(boolean isDebugging) {
        String localFlag = isDebugging ? LOCAL_ENABLE_CLOUD_DEBUGGING_FLAG : LOCAL_ENABLE_CLOUD_TESTING_FLAG;
        String remoteFlag = isDebugging ? ENABLE_CLOUD_DEBUGGING_REMOTELY : ENABLE_CLOUD_TESTING_REMOTELY;
        return Boolean.getBoolean(localFlag) || PropertiesComponent.getInstance().getBoolean(remoteFlag, false);
    }

    private class CloudOptionEnablementCheckerRunnable
    implements Runnable {
        private final boolean isDebugging;
        private final String remoteFlag;

        CloudOptionEnablementCheckerRunnable(boolean isDebugging) {
            this.isDebugging = isDebugging;
            this.remoteFlag = isDebugging ? CloudOptionEnablementChecker.ENABLE_CLOUD_DEBUGGING_REMOTELY : CloudOptionEnablementChecker.ENABLE_CLOUD_TESTING_REMOTELY;
        }

        @Override
        public void run() {
            if (!CloudOptionEnablementChecker.isCloudOptionEnabled(this.isDebugging)) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        if (CloudConfigurationHelper.isCloudOptionEnabledRemotely(CloudOptionEnablementCheckerRunnable.this.isDebugging)) {
                            PropertiesComponent.getInstance().setValue(CloudOptionEnablementCheckerRunnable.this.remoteFlag, "true");
                        }
                    }
                });
                JobScheduler.getScheduler().schedule(this, 30L, TimeUnit.MINUTES);
            }
        }
    }
}

