/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.AndroidConfigHelper;
import com.android.build.gradle.internal.ExecutionConfigurationUtil;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.JniLibsLanguageTransform;
import com.android.build.gradle.internal.LibraryCache;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NativeDependencyLinkage;
import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.NdkOptionsHelper;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.coverage.JacocoPlugin;
import com.android.build.gradle.internal.dependency.AndroidNativeDependencySpec;
import com.android.build.gradle.internal.dependency.NativeDependencyResolveResult;
import com.android.build.gradle.internal.dependency.NativeDependencyResolver;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.process.GradleJavaProcessExecutor;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.managed.BuildType;
import com.android.build.gradle.managed.DataBindingOptions;
import com.android.build.gradle.managed.NdkConfig;
import com.android.build.gradle.managed.NdkOptions;
import com.android.build.gradle.managed.ProductFlavor;
import com.android.build.gradle.managed.SigningConfig;
import com.android.build.gradle.managed.VectorDrawablesOptions;
import com.android.build.gradle.managed.adaptor.AndroidConfigAdaptor;
import com.android.build.gradle.managed.adaptor.BuildTypeAdaptor;
import com.android.build.gradle.managed.adaptor.DataBindingOptionsAdapter;
import com.android.build.gradle.managed.adaptor.ProductFlavorAdaptor;
import com.android.build.gradle.model.AndroidBinary;
import com.android.build.gradle.model.AndroidComponentModelPlugin;
import com.android.build.gradle.model.AndroidComponentSpec;
import com.android.build.gradle.model.AndroidLanguageSourceSet;
import com.android.build.gradle.model.ComponentModelBuilder;
import com.android.build.gradle.model.JniLibsSourceSet;
import com.android.build.gradle.model.NdkComponentModelPlugin;
import com.android.build.gradle.model.TaskModelMapAdaptor;
import com.android.build.gradle.model.internal.AndroidBinaryInternal;
import com.android.build.gradle.model.internal.AndroidComponentSpecInternal;
import com.android.build.gradle.tasks.JillTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.internal.compiler.JackConversionCache;
import com.android.builder.internal.compiler.PreDexCache;
import com.android.builder.profile.ProcessRecorderFactory;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.internal.ExecutorSingleton;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.prefs.AndroidLocation;
import com.android.resources.Density;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.model.Defaults;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class BaseComponentModelPlugin
implements Plugin<Project> {
    private ToolingModelBuilderRegistry toolingRegistry;
    private ModelRegistry modelRegistry;

    @Inject
    protected BaseComponentModelPlugin(ToolingModelBuilderRegistry toolingRegistry, ModelRegistry modelRegistry) {
        this.toolingRegistry = toolingRegistry;
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project project) {
        ExecutionConfigurationUtil.setThreadPoolSize((Project)project);
        try {
            String benchmarkMode;
            ArrayList propertyList = Lists.newArrayList((Object[])new Recorder.Property[]{new Recorder.Property("plugin_version", "2.1.0-beta3"), new Recorder.Property("next_gen_plugin", "true"), new Recorder.Property("gradle_version", project.getGradle().getGradleVersion())});
            String benchmarkName = AndroidGradleOptions.getBenchmarkName((Project)project);
            if (benchmarkName != null) {
                propertyList.add(new Recorder.Property("benchmark_name", benchmarkName));
            }
            if ((benchmarkMode = AndroidGradleOptions.getBenchmarkMode((Project)project)) != null) {
                propertyList.add(new Recorder.Property("benchmark_mode", benchmarkMode));
            }
            ProcessRecorderFactory.initialize((ILogger)new LoggerWrapper(project.getLogger()), (File)project.getRootProject().file((Object)("profiler" + System.currentTimeMillis() + ".json")), (List)propertyList);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize ProcessRecorderFactory");
        }
        project.getGradle().addListener((Object)new RecordingBuildListener(ThreadRecorder.get()));
        project.getPlugins().apply(AndroidComponentModelPlugin.class);
        project.getPlugins().apply(JavaBasePlugin.class);
        project.getPlugins().apply(JacocoPlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        BaseComponentModelPlugin.createConfiguration(configurations, "compile", "Classpath for compiling the default sources.");
        BaseComponentModelPlugin.createConfiguration(configurations, "testCompile", "Classpath for compiling the test sources.");
        BaseComponentModelPlugin.createConfiguration(configurations, "androidTestCompile", "Classpath for compiling the androidTest sources.");
        BaseComponentModelPlugin.createConfiguration(configurations, "default-metadata", "Metadata for published APKs");
        BaseComponentModelPlugin.createConfiguration(configurations, "default-mapping", "Metadata for published APKs");
        project.getPlugins().apply(NdkComponentModelPlugin.class);
        this.modelRegistry.register(ModelRegistrations.bridgedInstance((ModelReference)ModelReference.of((String)"projectModel", Project.class), (Object)project).descriptor("Model of project.").build());
        this.toolingRegistry.register((ToolingModelBuilder)new ComponentModelBuilder(this.modelRegistry));
        this.modelRegistry.register(ModelRegistrations.bridgedInstance((ModelReference)ModelReference.of((String)"toolingRegistry", ToolingModelBuilderRegistry.class), (Object)this.toolingRegistry).descriptor("Tooling model builder model registry.").build());
        SdkHandler sdkHandler = this.createSdkHandler(project);
        this.modelRegistry.register(ModelRegistrations.bridgedInstance((ModelReference)ModelReference.of((String)"createSdkHandler", SdkHandler.class), (Object)sdkHandler).descriptor("SDK handler.").build());
    }

    private SdkHandler createSdkHandler(final Project project) {
        LoggerWrapper logger = new LoggerWrapper(project.getLogger());
        final SdkHandler sdkHandler = new SdkHandler(project, (ILogger)logger);
        project.getGradle().buildFinished((Closure)new Closure<Object>((Object)this, (Object)this, (ILogger)logger){
            final /* synthetic */ ILogger val$logger;
            {
                this.val$logger = iLogger;
                super(x0, x1);
            }

            public void doCall(Object it) {
                ExecutorSingleton.shutdown();
                sdkHandler.unload();
                try {
                    PreDexCache.getCache().clear(project.getRootProject().file((Object)(String.valueOf(project.getRootProject().getBuildDir()) + "/" + "intermediates" + "/dex-cache/cache.xml")), this.val$logger);
                    JackConversionCache.getCache().clear(project.getRootProject().file((Object)(String.valueOf(project.getRootProject().getBuildDir()) + "/" + "intermediates" + "/jack-cache/cache.xml")), this.val$logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                LibraryCache.getCache().unload();
            }
        });
        project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Void>((Object)this, (Object)this){

            public void doCall(TaskExecutionGraph taskGraph) {
                for (Task task : taskGraph.getAllTasks()) {
                    if (task instanceof TransformTask) {
                        if (!(((TransformTask)task).getTransform() instanceof DexTransform)) continue;
                        PreDexCache.getCache().load(project.getRootProject().file((Object)(String.valueOf(project.getRootProject().getBuildDir()) + "/" + "intermediates" + "/dex-cache/cache.xml")));
                        break;
                    }
                    if (!(task instanceof JillTask)) continue;
                    JackConversionCache.getCache().load(project.getRootProject().file((Object)(String.valueOf(project.getRootProject().getBuildDir()) + "/" + "intermediates" + "/jack-cache/cache.xml")));
                    break;
                }
            }
        });
        for (final File file : sdkHandler.getSdkLoader().getRepositories()) {
            project.getRepositories().maven((Action)new Action<MavenArtifactRepository>(){

                public void execute(MavenArtifactRepository repo) {
                    repo.setUrl((Object)file.toURI());
                }
            });
        }
        return sdkHandler;
    }

    private static void createConfiguration(ConfigurationContainer configurations, String configurationName, String configurationDescription) {
        Configuration configuration = (Configuration)configurations.findByName(configurationName);
        if (configuration == null) {
            configuration = (Configuration)configurations.create(configurationName);
        }
        configuration.setVisible(false);
        configuration.setDescription(configurationDescription);
    }

    public static class Rules
    extends RuleSource {
        @Mutate
        public static void registerLanguageTransform(LanguageTransformContainer languages, ServiceRegistry serviceRegistry, NdkHandler ndkHandler) {
            languages.add((Object)new JniLibsLanguageTransform(ndkHandler));
        }

        @Defaults
        public static void configureAndroidModel(com.android.build.gradle.managed.AndroidConfig androidModel, ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            AndroidConfigHelper.configure(androidModel, instantiator);
        }

        @Defaults
        public static void initSigningConfigs(@Path(value="android.signingConfigs") ModelMap<SigningConfig> signingConfigs) {
            signingConfigs.beforeEach((Action)new Action<SigningConfig>(){

                public void execute(SigningConfig signingConfig) {
                    signingConfig.setStoreType(KeyStore.getDefaultType());
                }
            });
            signingConfigs.create("debug", (Action)new Action<SigningConfig>(){

                public void execute(SigningConfig signingConfig) {
                    try {
                        signingConfig.setStoreFile(new File(KeystoreHelper.defaultDebugKeystoreLocation()));
                        signingConfig.setStorePassword("android");
                        signingConfig.setKeyAlias("AndroidDebugKey");
                        signingConfig.setKeyPassword("android");
                    }
                    catch (AndroidLocation.AndroidLocationException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        @Defaults
        public static void copyNdkConfig(@Path(value="android.defaultConfig.ndk") NdkOptions defaultNdkConfig, @Path(value="android.ndk") NdkConfig pluginNdkConfig) {
            NdkOptionsHelper.merge(defaultNdkConfig, (NdkOptions)pluginNdkConfig);
        }

        @Defaults
        public static void configureDefaultDataBindingOptions(@Path(value="android.dataBinding") DataBindingOptions dataBindingOptions) {
            dataBindingOptions.setEnabled(false);
            dataBindingOptions.setAddDefaultAdapters(true);
        }

        @Model(value="extraModelInfo")
        public static ExtraModelInfo createExtraModelInfo(Project project, @Path(value="isApplication") Boolean isApplication) {
            return new ExtraModelInfo(project, isApplication.booleanValue());
        }

        @Model
        public static DataBindingBuilder createDataBindingBuilder() {
            return new DataBindingBuilder();
        }

        @Model(value="androidBuilder")
        public static AndroidBuilder createAndroidBuilder(Project project, ExtraModelInfo extraModelInfo) {
            String creator = "Android Gradle";
            LoggerWrapper logger = new LoggerWrapper(project.getLogger());
            return new AndroidBuilder(project.equals(project.getRootProject()) ? project.getName() : project.getPath(), creator, (ProcessExecutor)new GradleProcessExecutor(project), (JavaProcessExecutor)new GradleJavaProcessExecutor(project), (ErrorReporter)extraModelInfo, (ILogger)logger, project.getLogger().isEnabled(LogLevel.INFO));
        }

        @Defaults
        public static void initDebugBuildTypes(@Path(value="android.buildTypes") ModelMap<BuildType> buildTypes, final @Path(value="android.signingConfigs") ModelMap<SigningConfig> signingConfigs) {
            buildTypes.beforeEach((Action)new Action<BuildType>(){

                public void execute(BuildType buildType) {
                    Rules.initBuildType(buildType);
                }
            });
            buildTypes.named("debug", (Action)new Action<BuildType>(){

                public void execute(BuildType buildType) {
                    buildType.setSigningConfig((SigningConfig)signingConfigs.get("debug"));
                }
            });
        }

        private static void initBuildType(BuildType buildType) {
            buildType.setDebuggable(false);
            buildType.setTestCoverageEnabled(false);
            buildType.setPseudoLocalesEnabled(false);
            buildType.setRenderscriptDebuggable(false);
            buildType.setRenderscriptOptimLevel(3);
            buildType.setMinifyEnabled(false);
            buildType.setUseProguard(true);
            buildType.setZipAlignEnabled(true);
            buildType.setEmbedMicroApp(true);
            buildType.setShrinkResources(false);
        }

        @Defaults
        public static void initDefaultConfigVectorDrawables(@Path(value="android.defaultConfig.vectorDrawables") VectorDrawablesOptions vectorDrawablesOptions) {
            vectorDrawablesOptions.setUseSupportLibrary(false);
            Set densities = Density.getRecommendedValuesForDevice();
            HashSet strings = Sets.newHashSetWithExpectedSize((int)densities.size());
            for (Density density : densities) {
                strings.add(density.getResourceValue());
            }
            vectorDrawablesOptions.setGeneratedDensities(strings);
        }

        @Defaults
        public static void addDefaultAndroidSourceSet(@Path(value="android.sources") ModelMap<FunctionalSourceSet> sources) {
            sources.all((Action)new Action<FunctionalSourceSet>(){

                public void execute(FunctionalSourceSet sourceSet) {
                    sourceSet.create("resources", AndroidLanguageSourceSet.class);
                    sourceSet.create("java", AndroidLanguageSourceSet.class);
                    sourceSet.create("manifest", AndroidLanguageSourceSet.class);
                    sourceSet.create("res", AndroidLanguageSourceSet.class);
                    sourceSet.create("assets", AndroidLanguageSourceSet.class);
                    sourceSet.create("aidl", AndroidLanguageSourceSet.class);
                    sourceSet.create("renderscript", AndroidLanguageSourceSet.class);
                    sourceSet.create("jniLibs", JniLibsSourceSet.class);
                    sourceSet.named("manifest", (Action)new Action<LanguageSourceSet>(){

                        public void execute(LanguageSourceSet manifest) {
                            manifest.getSource().setIncludes((Iterable)ImmutableList.of((Object)"AndroidManifest.xml"));
                        }
                    });
                }
            });
        }

        @Mutate
        public void androidConfigImplicitDependencies(com.android.build.gradle.managed.AndroidConfig androidConfig, @Path(value="android.dataBinding") DataBindingOptions dataBindingOptions) {
        }

        @Model(value="androidConfigAdaptor")
        public static AndroidConfig createModelAdaptor(ServiceRegistry serviceRegistry, com.android.build.gradle.managed.AndroidConfig androidExtension, Project project, @Path(value="isApplication") Boolean isApplication) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return new AndroidConfigAdaptor(androidExtension, AndroidConfigHelper.createSourceSetsContainer(project, instantiator, isApplication == false));
        }

        @Model(value="jniLibsDependencies")
        public static Multimap<String, NativeDependencyResolveResult> resolveJniLibsDependencies(ModelMap<AndroidBinary> androidBinary, @Path(value="android.sources") ModelMap<FunctionalSourceSet> sources, ServiceRegistry serviceRegistry) {
            ArrayListMultimap dependencies = ArrayListMultimap.create();
            for (AndroidBinary binary : androidBinary.values()) {
                DomainObjectSet jniSources = binary.getInputs().withType(JniLibsSourceSet.class);
                for (JniLibsSourceSet sourceSet : jniSources) {
                    dependencies.put((Object)binary.getName(), (Object)new NativeDependencyResolver(serviceRegistry, sourceSet.getDependencies(), new AndroidNativeDependencySpec(null, null, binary.getBuildType().getName(), ProductFlavorCombo.getFlavorComboName(binary.getProductFlavors()), NativeDependencyLinkage.SHARED)).resolve());
                }
            }
            return dependencies;
        }

        @Mutate
        public static void createAndroidComponents(ComponentSpecContainer androidSpecs, ServiceRegistry serviceRegistry, com.android.build.gradle.managed.AndroidConfig androidExtension, AndroidConfig adaptedModel, @Path(value="android.buildTypes") ModelMap<BuildType> buildTypes, @Path(value="android.productFlavors") ModelMap<ProductFlavor> productFlavors, @Path(value="android.signingConfigs") ModelMap<SigningConfig> signingConfigs, VariantFactory variantFactory, TaskManager taskManager, Project project, AndroidBuilder androidBuilder, SdkHandler sdkHandler, ExtraModelInfo extraModelInfo, @Path(value="isApplication") Boolean isApplication) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            TargetInfo targetInfo = androidBuilder.getTargetInfo();
            if (targetInfo == null) {
                sdkHandler.initTarget(androidExtension.getCompileSdkVersion(), androidExtension.getBuildToolsRevision(), androidExtension.getLibraryRequests(), androidBuilder, SdkHandler.useCachedSdk((Project)project));
            }
            VariantManager variantManager = new VariantManager(project, androidBuilder, adaptedModel, variantFactory, taskManager, instantiator);
            variantFactory.validateModel((VariantModel)variantManager);
            for (BuildType buildType : buildTypes.values()) {
                variantManager.addBuildType((CoreBuildType)new BuildTypeAdaptor(buildType));
            }
            for (ProductFlavor productFlavor : productFlavors.values()) {
                variantManager.addProductFlavor((CoreProductFlavor)new ProductFlavorAdaptor(productFlavor));
            }
            AndroidComponentSpecInternal spec = (AndroidComponentSpecInternal)androidSpecs.get("android");
            spec.setExtension(androidExtension);
            spec.setVariantManager(variantManager);
        }

        @Mutate
        public static void createVariantData(ModelMap<AndroidBinaryInternal> binaries, ModelMap<AndroidComponentSpec> specs, TaskManager taskManager) {
            final VariantManager variantManager = ((AndroidComponentSpecInternal)specs.get("android")).getVariantManager();
            binaries.afterEach((Action)new Action<AndroidBinaryInternal>(){

                public void execute(AndroidBinaryInternal binary) {
                    ArrayList adaptedFlavors = Lists.newArrayList();
                    for (ProductFlavor flavor : binary.getProductFlavors()) {
                        adaptedFlavors.add(new ProductFlavorAdaptor(flavor));
                    }
                    binary.setVariantData(variantManager.createVariantData((com.android.builder.model.BuildType)new BuildTypeAdaptor(binary.getBuildType()), (List)adaptedFlavors));
                    binary.getVariantData().getVariantConfiguration().setEnableInstantRunOverride(Boolean.valueOf(false));
                    variantManager.getVariantDataList().add(binary.getVariantData());
                }
            });
        }

        @Mutate
        public static void createLifeCycleTasks(ModelMap<Task> tasks, TaskManager taskManager) {
            taskManager.createTasksBeforeEvaluate((TaskFactory)new TaskModelMapAdaptor(tasks));
        }

        @Mutate
        public void addDataBindingDependenciesIfNecessary(TaskManager taskManager, @Path(value="android.dataBinding") DataBindingOptions dataBindingOptions) {
            taskManager.addDataBindingDependenciesIfNecessary((com.android.builder.model.DataBindingOptions)new DataBindingOptionsAdapter(dataBindingOptions));
        }

        @Mutate
        public static void createAndroidTasks(ModelMap<Task> tasks, ModelMap<AndroidComponentSpec> androidSpecs, TaskManager taskManager, SdkHandler sdkHandler, Project project, @Path(value="android.sources") ModelMap<FunctionalSourceSet> androidSources) {
            for (final File file : sdkHandler.getSdkLoader().getRepositories()) {
                project.getRepositories().maven((Action)new Action<MavenArtifactRepository>(){

                    public void execute(MavenArtifactRepository repo) {
                        repo.setUrl((Object)file.toURI());
                    }
                });
            }
        }

        @Mutate
        public static void createBinaryTasks(ModelMap<Task> tasks, ModelMap<AndroidBinaryInternal> binaries, ModelMap<AndroidComponentSpec> specs, TaskManager taskManager) {
            VariantManager variantManager = ((AndroidComponentSpecInternal)specs.get("android")).getVariantManager();
            for (AndroidBinaryInternal binary : binaries) {
                variantManager.createTasksForVariantData((TaskFactory)new TaskModelMapAdaptor(tasks), binary.getVariantData());
            }
        }

        @Mutate
        public static void createRemainingTasks(ModelMap<Task> tasks, TaskManager taskManager, ModelMap<AndroidComponentSpec> spec) {
            VariantManager variantManager = ((AndroidComponentSpecInternal)spec.get("android")).getVariantManager();
            taskManager.createTopLevelTestTasks((TaskFactory)new TaskModelMapAdaptor(tasks), !variantManager.getProductFlavors().isEmpty());
        }

        @Mutate
        public static void createReportTasks(ModelMap<Task> tasks, ModelMap<AndroidComponentSpecInternal> specs) {
            final VariantManager variantManager = ((AndroidComponentSpecInternal)specs.get("android")).getVariantManager();
            tasks.create("androidDependencies", DependencyReportTask.class, (Action)new Action<DependencyReportTask>(){

                public void execute(DependencyReportTask dependencyReportTask) {
                    dependencyReportTask.setDescription("Displays the Android dependencies of the project");
                    dependencyReportTask.setVariants((Collection)variantManager.getVariantDataList());
                    dependencyReportTask.setGroup("Android");
                }
            });
            tasks.create("signingReport", SigningReportTask.class, (Action)new Action<SigningReportTask>(){

                public void execute(SigningReportTask signingReportTask) {
                    signingReportTask.setDescription("Displays the signing info for each variant");
                    signingReportTask.setVariants((Collection)variantManager.getVariantDataList());
                    signingReportTask.setGroup("Android");
                }
            });
        }

        @Mutate
        public static void modifyAssembleTaskDescription(@Path(value="tasks.assemble") Task assembleTask) {
            assembleTask.setDescription("Assembles all variants of all applications and secondary packages.");
        }
    }
}

