/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.CommitToIcsDialog;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ProjectId;
import org.jetbrains.settingsRepository.actions.ProjectChangeCollectConsumer;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"5\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001C\b\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!$\t\u0005\u0003!\u0001Q\"\u0001M\u00013\u0019A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u00023\rA)!D\u0001\u0019\u0007Q\u001b9!$\u0006\u0005\u0003!!QB\u0001G\u00011\u0013I2\u0001C\u0003\u000e\u0003a-Aka\u0002\u000e\u001e\u0011\t\u0001BB\u0007\u00021\u001bIB\u0001C\u0004\u000e\u00051\u0005\u0001tB\r\u0004\u0011\u0015i\u0011\u0001g\u0003U\u0007\u000fi)\u0003B\u0001\t\u00115\t\u0001\u0014A\r\u0004\u0011\u0015i\u0011\u0001g\u0003\u001a\u0007!\u0015Q\"\u0001\r\u00043\u0011A\t\"\u0004\u0002\r\u0002a%Aka\u0002"}, strings={"collectProjectChanges", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "collectConsumer", "Lorg/jetbrains/settingsRepository/actions/ProjectChangeCollectConsumer;", "CommitToIcsActionKt", "getProjectId", "", "project", "Lcom/intellij/openapi/project/Project;", "isProjectConfigFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "showDialog", "projectId"}, moduleName="settings-repository")
public final class CommitToIcsActionKt {
    private static final String getProjectId(Project project) {
        ProjectId projectId;
        Object object = ServiceManager.getService((Project)project, ProjectId.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if ((projectId = (ProjectId)object).getUid() == null && ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Settings Server Project Mapping", (String)"Project is not mapped on Settings Server. Would you like to map?").project(project)).doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.PropertyDoNotAskOption(""){

            public void setToBeShown(boolean value, int exitCode) {
                IcsManagerKt.getIcsManager().getSettings().setDoNoAskMapProject(!value);
            }

            public boolean isToBeShown() {
                return !IcsManagerKt.getIcsManager().getSettings().getDoNoAskMapProject();
            }

            public boolean canBeHidden() {
                return true;
            }
        })).show() == 0) {
            projectId.setUid(UUID.randomUUID().toString());
        }
        return projectId.getUid();
    }

    private static final void showDialog(Project project, ProjectChangeCollectConsumer collectConsumer, String projectId) {
        if (!collectConsumer.hasResult()) {
            return;
        }
        String effectiveProjectId = projectId;
        if (effectiveProjectId == null && (effectiveProjectId = CommitToIcsActionKt.getProjectId(project)) == null) {
            return;
        }
        new CommitToIcsDialog(project, effectiveProjectId, collectConsumer.getResult()).show();
    }

    private static final void collectProjectChanges(Collection<? extends Change> changes, ProjectChangeCollectConsumer collectConsumer) {
        for (Change change : changes) {
            collectConsumer.consume(change);
        }
    }

    private static final boolean isProjectConfigFile(VirtualFile file, Project project) {
        if (file == null) {
            return false;
        }
        String string = project.getBasePath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return FileUtil.isAncestor((String)string, (String)file.getPath(), (boolean)true);
    }

    public static final /* synthetic */ void access$collectProjectChanges(@NotNull Collection changes, @NotNull ProjectChangeCollectConsumer collectConsumer) {
        CommitToIcsActionKt.collectProjectChanges(changes, collectConsumer);
    }

    public static final /* synthetic */ void access$showDialog(@NotNull Project project, @NotNull ProjectChangeCollectConsumer collectConsumer, @Nullable String projectId) {
        CommitToIcsActionKt.showDialog(project, collectConsumer, projectId);
    }

    public static final /* synthetic */ boolean access$isProjectConfigFile(@Nullable VirtualFile file, @NotNull Project project) {
        return CommitToIcsActionKt.isProjectConfigFile(file, project);
    }

    @Nullable
    public static final /* synthetic */ String access$getProjectId(@NotNull Project project) {
        return CommitToIcsActionKt.getProjectId(project);
    }
}

