/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreAwareProjectManagerKt;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.UpdateResult;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"=\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\u0001Q!\u0001E\u0012\u000b\u0005Aq!\u0002\u0001\u0006\u0003!yQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"AG\u0018\t\u0005A\u0019!D\u0001\u0019\u0005e1\u0001RA\u0007\u0005\u0013\tI\u0011\u0001g\u0002\u0019\u0007e1\u0001\u0002B\u0007\u0005\u0013\tI\u0011\u0001G\u0003\u0019\ne\u0019\u00012B\u0007\u00021\u0019!6!AG\u0012\t\u0001Ai!D\u0001\u0019\re\u0019\u0001bB\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003aE\u0011d\u0001\u0005\n\u001b\u0005A\u001a\u0002V\u0002\u0002##!\u0011\t\u0003\u0005\u0001\u001b\u0005A\n!U\u0002\u0002\u000b\u0001!6!\u0001"}, strings={"LOG_1", "Lcom/intellij/openapi/diagnostic/Logger;", "SyncKt", "updateStateStorage", "", "changedComponentNames", "", "", "stateStorages", "", "Lcom/intellij/openapi/components/StateStorage;", "deleted", "", "updateStoragesFromStreamProvider", "store", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "updateResult", "Lorg/jetbrains/settingsRepository/UpdateResult;", "messageBus", "Lcom/intellij/util/messages/MessageBus;"}, moduleName="settings-repository")
public final class SyncKt {
    private static final Logger LOG_1 = IcsManagerKt.getLOG();

    /*
     * WARNING - void declaration
     */
    public static final boolean updateStoragesFromStreamProvider(@NotNull ComponentStoreImpl store, @NotNull UpdateResult updateResult, @NotNull MessageBus messageBus) {
        void deleted;
        void changed;
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull((Object)updateResult, (String)"updateResult");
        Intrinsics.checkParameterIsNotNull((Object)messageBus, (String)"messageBus");
        LinkedHashSet changedComponentNames = new LinkedHashSet();
        StateStorageManager stateStorageManager = store.getStorageManager();
        if (stateStorageManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        }
        Pair pair = ((StateStorageManagerImpl)stateStorageManager).getCachedFileStorages(updateResult.getChanged(), updateResult.getDeleted());
        Collection collection = (Collection)pair.component1();
        Collection collection2 = (Collection)pair.component2();
        pair = null;
        if (changed.isEmpty() && deleted.isEmpty()) {
            return false;
        }
        Object object = UIUtil.invokeAndWaitIfNeeded((Computable)((Computable)new Computable<Boolean>(changedComponentNames, (Collection)changed, (Collection)deleted, store, messageBus){
            final /* synthetic */ LinkedHashSet $changedComponentNames;
            final /* synthetic */ Collection $changed;
            final /* synthetic */ Collection $deleted;
            final /* synthetic */ ComponentStoreImpl $store;
            final /* synthetic */ MessageBus $messageBus;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean compute() {
                SyncKt.access$updateStateStorage(this.$changedComponentNames, this.$changed, false);
                SyncKt.access$updateStateStorage(this.$changedComponentNames, this.$deleted, true);
                if (this.$changedComponentNames.isEmpty()) {
                    return false;
                }
                Collection notReloadableComponents = this.$store.getNotReloadableComponents((Collection)this.$changedComponentNames);
                THashSet changedStorageSet = new THashSet(this.$changed);
                changedStorageSet.addAll(this.$deleted);
                MessageBus messageBus$iv = this.$messageBus;
                BatchUpdateListener publisher$iv = (BatchUpdateListener)messageBus$iv.syncPublisher(BatchUpdateListener.TOPIC);
                publisher$iv.onBatchUpdateStarted();
                try {
                    this.$store.reinitComponents((Set)this.$changedComponentNames, (Set)changedStorageSet, notReloadableComponents);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    publisher$iv.onBatchUpdateFinished();
                }
                if (notReloadableComponents.isEmpty()) {
                    return false;
                }
                return StoreAwareProjectManagerKt.askToRestart((IComponentStore)((IComponentStore)this.$store), (Collection)notReloadableComponents, (Set)null, (boolean)true);
            }
            {
                this.$changedComponentNames = linkedHashSet;
                this.$changed = collection;
                this.$deleted = collection2;
                this.$store = componentStoreImpl;
                this.$messageBus = messageBus;
            }
        }));
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (Boolean)object;
    }

    private static final void updateStateStorage(Set<String> changedComponentNames, Collection<? extends StateStorage> stateStorages, boolean deleted) {
        for (StateStorage stateStorage : stateStorages) {
            try {
                StateStorage stateStorage2 = stateStorage;
                if (stateStorage2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.XmlElementStorage");
                }
                ((XmlElementStorage)stateStorage2).updatedFromStreamProvider(changedComponentNames, deleted);
            }
            catch (Throwable e) {
                LOG_1.error(e);
            }
        }
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG_1$p() {
        return LOG_1;
    }

    public static final /* synthetic */ void access$updateStateStorage(@NotNull Set changedComponentNames, @NotNull Collection stateStorages, boolean deleted) {
        SyncKt.updateStateStorage(changedComponentNames, stateStorages, deleted);
    }
}

