/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.LibraryDependency;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;

public class JavaCompileConfigAction
implements TaskConfigAction<JavaCompile> {
    private VariantScope scope;

    public JavaCompileConfigAction(VariantScope scope) {
        this.scope = scope;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("compile", "JavaWithJavac");
    }

    @Override
    public Class<JavaCompile> getType() {
        return JavaCompile.class;
    }

    @Override
    public void execute(JavaCompile javacTask) {
        final BaseVariantData testedVariantData = this.scope.getTestedVariantData();
        this.scope.getVariantData().javacTask = javacTask;
        javacTask.setSource((Object)this.scope.getVariantData().getJavaSources());
        ConventionMappingHelper.map((Task)javacTask, "classpath", new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                FileCollection classpath = JavaCompileConfigAction.this.scope.getJavaClasspath();
                Project project = JavaCompileConfigAction.this.scope.getGlobalScope().getProject();
                if (testedVariantData != null) {
                    LibraryDependency libraryDependency;
                    if (!testedVariantData.getType().equals((Object)VariantType.LIBRARY) || JavaCompileConfigAction.this.scope.getVariantData().getType().equals((Object)VariantType.UNIT_TEST)) {
                        classpath = classpath.plus((FileCollection)project.files(new Object[]{testedVariantData.getScope().getJavaClasspath(), testedVariantData.getScope().getJavaOutputDir(), testedVariantData.getScope().getJavaDependencyCache()}));
                    }
                    if (JavaCompileConfigAction.this.scope.getVariantData().getType().equals((Object)VariantType.UNIT_TEST) && testedVariantData.getType().equals((Object)VariantType.LIBRARY) && (libraryDependency = testedVariantData.getVariantConfiguration().getOutput()) != null) {
                        File jarFile = libraryDependency.getJarFile();
                        classpath = classpath.minus((FileCollection)project.files(new Object[]{jarFile}));
                    }
                }
                return classpath;
            }
        });
        javacTask.setDestinationDir(this.scope.getJavaOutputDir());
        javacTask.setDependencyCacheDir(this.scope.getJavaDependencyCache());
        CompileOptions compileOptions = this.scope.getGlobalScope().getExtension().getCompileOptions();
        AbstractCompilesUtil.configureLanguageLevel((AbstractCompile)javacTask, compileOptions, this.scope.getGlobalScope().getExtension().getCompileSdkVersion());
        javacTask.getOptions().setEncoding(compileOptions.getEncoding());
        javacTask.getOptions().setBootClasspath(Joiner.on((String)File.pathSeparator).join((Iterable)this.scope.getGlobalScope().getAndroidBuilder().getBootClasspathAsStrings(false)));
    }
}

