/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.OutputFile;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.annotations.ApkFile;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.FilterableStreamCollection;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.ValidateSigningTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.tooling.BuildException;

@ParallelizableTask
public class PackageApplication
extends IncrementalTask
implements FileSupplier {
    public static final FilterableStreamCollection.StreamFilter sDexFilter = new FilterableStreamCollection.StreamFilter(){

        @Override
        public boolean accept(Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes) {
            return types.contains((Object)ExtendedContentType.DEX);
        }
    };
    public static final FilterableStreamCollection.StreamFilter sResFilter = new FilterableStreamCollection.StreamFilter(){

        @Override
        public boolean accept(Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes) {
            return types.contains(QualifiedContent.DefaultContentType.RESOURCES) && !scopes.contains(QualifiedContent.Scope.PROVIDED_ONLY) && !scopes.contains(QualifiedContent.Scope.TESTED_CODE);
        }
    };
    public static final FilterableStreamCollection.StreamFilter sNativeLibsFilter = new FilterableStreamCollection.StreamFilter(){

        @Override
        public boolean accept(Set<QualifiedContent.ContentType> types, Set<QualifiedContent.Scope> scopes) {
            return types.contains((Object)ExtendedContentType.NATIVE_LIBS) && !scopes.contains(QualifiedContent.Scope.PROVIDED_ONLY) && !scopes.contains(QualifiedContent.Scope.TESTED_CODE);
        }
    };
    private File resourceFile;
    private Set<File> dexFolders;
    private Set<File> javaResourceFiles;
    private Set<File> jniFolders;
    @ApkFile
    private File outputFile;
    private Set<String> abiFilters;
    private boolean jniDebugBuild;
    private CoreSigningConfig signingConfig;
    private PackagingOptions packagingOptions;

    @InputFile
    public File getResourceFile() {
        return this.resourceFile;
    }

    public void setResourceFile(File resourceFile) {
        this.resourceFile = resourceFile;
    }

    @org.gradle.api.tasks.OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Input
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public void setAbiFilters(Set<String> abiFilters) {
        this.abiFilters = abiFilters;
    }

    @InputFiles
    @Optional
    public Collection<File> getJavaResourceFiles() {
        return this.javaResourceFiles;
    }

    @InputFiles
    @Optional
    public Collection<File> getJniFolders() {
        return this.jniFolders;
    }

    @InputFiles
    public Set<File> getDexFolders() {
        return this.dexFolders;
    }

    @Input
    public boolean getJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public boolean isJniDebugBuild() {
        return this.jniDebugBuild;
    }

    public void setJniDebugBuild(boolean jniDebugBuild) {
        this.jniDebugBuild = jniDebugBuild;
    }

    @Nested
    @Optional
    public CoreSigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(CoreSigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Nested
    public PackagingOptions getPackagingOptions() {
        return this.packagingOptions;
    }

    public void setPackagingOptions(PackagingOptions packagingOptions) {
        this.packagingOptions = packagingOptions;
    }

    @Override
    protected void doFullTaskAction() {
        try {
            Collection<File> javaResourceFiles = this.getJavaResourceFiles();
            this.getBuilder().packageApk(this.getResourceFile().getAbsolutePath(), this.getDexFolders(), (Collection)(javaResourceFiles == null ? ImmutableList.of() : javaResourceFiles), this.getJniFolders(), this.getAbiFilters(), this.getJniDebugBuild(), (SigningConfig)this.getSigningConfig(), this.getOutputFile().getAbsolutePath());
        }
        catch (DuplicateFileException e) {
            Logger logger = this.getLogger();
            logger.error("Error: duplicate files during packaging of APK " + this.getOutputFile().getAbsolutePath());
            logger.error("\tPath in archive: " + e.getArchivePath());
            int index = 1;
            for (File file : e.getSourceFiles()) {
                logger.error("\tOrigin " + index++ + ": " + file);
            }
            logger.error("You can ignore those files in your build.gradle:");
            logger.error("\tandroid {");
            logger.error("\t  packagingOptions {");
            logger.error("\t    exclude '" + e.getArchivePath() + "'");
            logger.error("\t  }");
            logger.error("\t}");
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public File get() {
        return this.getOutputFile();
    }

    @Override
    public Task getTask() {
        return this;
    }

    public static class ConfigAction
    implements TaskConfigAction<PackageApplication> {
        private VariantOutputScope scope;

        public ConfigAction(VariantOutputScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        public void execute(PackageApplication packageApp) {
            final VariantScope variantScope = this.scope.getVariantScope();
            final ApkVariantData variantData = (ApkVariantData)variantScope.getVariantData();
            final ApkVariantOutputData variantOutputData = (ApkVariantOutputData)this.scope.getVariantOutputData();
            final GradleVariantConfiguration config = variantScope.getVariantConfiguration();
            variantOutputData.packageApplicationTask = packageApp;
            packageApp.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            packageApp.setVariantName(variantScope.getVariantConfiguration().getFullName());
            if (config.isMinifyEnabled() && ((CoreBuildType)config.getBuildType()).isShrinkResources() && !config.getUseJack()) {
                ConventionMappingHelper.map((Task)packageApp, "resourceFile", new Callable<File>(){

                    @Override
                    public File call() {
                        return ConfigAction.this.scope.getCompressedResourceFile();
                    }
                });
            } else {
                ConventionMappingHelper.map((Task)packageApp, "resourceFile", new Callable<File>(){

                    @Override
                    public File call() {
                        return variantOutputData.processResourcesTask.getPackageOutputFile();
                    }
                });
            }
            ConventionMappingHelper.map((Task)packageApp, "dexFolders", new Callable<Set<File>>(){

                @Override
                public Set<File> call() {
                    if (config.getUseJack()) {
                        return ImmutableSet.of((Object)variantScope.getJackDestinationDir());
                    }
                    return variantScope.getTransformManager().getPipelineOutput(sDexFilter).keySet();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "javaResourceFiles", new Callable<Set<File>>(){

                @Override
                public Set<File> call() throws Exception {
                    return variantScope.getTransformManager().getPipelineOutput(sResFilter).keySet();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "jniFolders", new Callable<Set<File>>(){

                @Override
                public Set<File> call() {
                    if (variantData.getSplitHandlingPolicy() == BaseVariantData.SplitHandlingPolicy.PRE_21_POLICY) {
                        return variantScope.getTransformManager().getPipelineOutput(sNativeLibsFilter).keySet();
                    }
                    ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(ConfigAction.this.scope.getGlobalScope().getExtension().getSplits().getAbiFilters());
                    return filters.isEmpty() ? variantScope.getTransformManager().getPipelineOutput(sNativeLibsFilter).keySet() : Collections.emptySet();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "abiFilters", new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    if (variantOutputData.getMainOutputFile().getFilter(OutputFile.ABI) != null) {
                        return ImmutableSet.of((Object)variantOutputData.getMainOutputFile().getFilter(OutputFile.ABI));
                    }
                    Set<String> supportedAbis = config.getSupportedAbis();
                    if (supportedAbis != null) {
                        return supportedAbis;
                    }
                    return ImmutableSet.of();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "jniDebugBuild", new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ((CoreBuildType)config.getBuildType()).isJniDebuggable();
                }
            });
            CoreSigningConfig sc = (CoreSigningConfig)config.getSigningConfig();
            packageApp.setSigningConfig(sc);
            if (sc != null) {
                String validateSigningTaskName = "validate" + StringHelper.capitalize((String)sc.getName()) + "Signing";
                ValidateSigningTask validateSigningTask = (ValidateSigningTask)((Object)this.scope.getGlobalScope().getProject().getTasks().findByName(validateSigningTaskName));
                if (validateSigningTask == null) {
                    validateSigningTask = (ValidateSigningTask)this.scope.getGlobalScope().getProject().getTasks().create("validate" + StringHelper.capitalize((String)sc.getName()) + "Signing", ValidateSigningTask.class);
                    validateSigningTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
                    validateSigningTask.setVariantName(variantScope.getVariantConfiguration().getFullName());
                    validateSigningTask.setSigningConfig(sc);
                }
                packageApp.dependsOn(new Object[]{validateSigningTask});
            }
            ConventionMappingHelper.map((Task)packageApp, "packagingOptions", new Callable<PackagingOptions>(){

                @Override
                public PackagingOptions call() throws Exception {
                    return ConfigAction.this.scope.getGlobalScope().getExtension().getPackagingOptions();
                }
            });
            ConventionMappingHelper.map((Task)packageApp, "outputFile", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return ConfigAction.this.scope.getPackageApk();
                }
            });
        }

        private static File getOptionalDir(File dir) {
            if (dir.isDirectory()) {
                return dir;
            }
            return null;
        }
    }
}

