/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.util.containers.ContainerUtil;
import git4idea.push.GitPushRepoResult;
import git4idea.repo.GitRepository;
import java.util.HashMap;
import java.util.Map;

class GroupedPushResult {
    final Map<GitRepository, GitPushRepoResult> successful;
    final Map<GitRepository, GitPushRepoResult> errors;
    final Map<GitRepository, GitPushRepoResult> rejected;

    private GroupedPushResult(Map<GitRepository, GitPushRepoResult> successful, Map<GitRepository, GitPushRepoResult> errors, Map<GitRepository, GitPushRepoResult> rejected) {
        this.successful = successful;
        this.errors = errors;
        this.rejected = rejected;
    }

    static GroupedPushResult group(Map<GitRepository, GitPushRepoResult> results) {
        HashMap successful = ContainerUtil.newHashMap();
        HashMap rejected = ContainerUtil.newHashMap();
        HashMap errors = ContainerUtil.newHashMap();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : results.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult result = entry.getValue();
            if (result.getType() == GitPushRepoResult.Type.REJECTED) {
                rejected.put(repository, result);
                continue;
            }
            if (result.getType() == GitPushRepoResult.Type.ERROR) {
                errors.put(repository, result);
                continue;
            }
            successful.put(repository, result);
        }
        return new GroupedPushResult(successful, errors, rejected);
    }
}

