/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.browser;

import git4idea.GitBranch;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import java.util.Collection;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class SymbolicRefs
implements SymbolicRefsI {
    private GitBranch myCurrent;
    private final TreeSet<String> myLocalBranches = new TreeSet();
    private final TreeSet<String> myRemoteBranches = new TreeSet();
    private String myTrackedRemoteName;
    private String myUsername;
    private AbstractHash myHeadHash;

    public void addRemote(String branch) {
        this.myRemoteBranches.add(branch);
    }

    public void addLocal(String branch) {
        this.myLocalBranches.add(branch);
    }

    public void addLocals(Collection<String> value) {
        this.myLocalBranches.addAll(value);
    }

    public void addRemotes(Collection<String> value) {
        this.myRemoteBranches.addAll(value);
    }

    public TreeSet<String> getLocalBranches() {
        return this.myLocalBranches;
    }

    public TreeSet<String> getRemoteBranches() {
        return this.myRemoteBranches;
    }

    @Override
    @Nullable
    public String getCurrentName() {
        return this.myCurrent == null ? null : this.myCurrent.getName();
    }

    @Override
    public GitBranch getCurrent() {
        return this.myCurrent;
    }

    public void setCurrent(GitBranch current) {
        this.myCurrent = current;
    }

    @Override
    public Kind getKind(String s) {
        if (this.myLocalBranches.contains(s)) {
            return Kind.LOCAL;
        }
        if (this.myRemoteBranches.contains(s)) {
            return Kind.REMOTE;
        }
        return Kind.TAG;
    }

    public void clear() {
        this.myLocalBranches.clear();
        this.myRemoteBranches.clear();
    }

    public void setTrackedRemote(String trackedRemoteName) {
        this.myTrackedRemoteName = trackedRemoteName;
    }

    @Override
    public String getTrackedRemoteName() {
        return this.myTrackedRemoteName;
    }

    @Override
    public String getUsername() {
        return this.myUsername;
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    public void setHead(AbstractHash hash) {
        this.myHeadHash = hash;
    }

    @Override
    public AbstractHash getHeadHash() {
        return this.myHeadHash;
    }

    public static enum Kind {
        TAG,
        LOCAL,
        REMOTE;

    }
}

