/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.ndk.internal.AbstractNativeToolSpecification;
import com.android.build.gradle.ndk.internal.StlConfiguration;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.nativeplatform.platform.NativePlatform;

public class StlNativeToolSpecification
extends AbstractNativeToolSpecification {
    private NdkHandler ndkHandler;
    private String stl;
    private String stlName;
    private String stlVersion;
    private Boolean isStatic;
    private NativePlatform platform;

    public StlNativeToolSpecification(NdkHandler ndkHandler, String stl, String stlVersion, NativePlatform platform) {
        this.ndkHandler = ndkHandler;
        this.stl = stl;
        this.stlVersion = stlVersion;
        this.stlName = stl.equals("system") ? stl : stl.substring(0, stl.indexOf(95));
        this.isStatic = stl.endsWith("_static");
        this.platform = platform;
    }

    @Override
    public Iterable<String> getCFlags() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<String> getCppFlags() {
        ArrayList cppFlags = Lists.newArrayList();
        if (this.stlName.equals("c++")) {
            cppFlags.add("-std=c++11");
        }
        List includeDirs = this.ndkHandler.getStlIncludes(this.stlName, this.stlVersion, Abi.getByName((String)this.platform.getName()));
        for (File dir : includeDirs) {
            cppFlags.add("-I" + dir.toString());
        }
        return cppFlags;
    }

    @Override
    public Iterable<String> getLdFlags() {
        if (this.stl.equals("system")) {
            return Collections.emptyList();
        }
        ArrayList flags = Lists.newArrayList();
        for (File stlLib : this.getStlLib(this.platform.getName())) {
            flags.add("-L" + stlLib.getParent());
            flags.add("-l" + stlLib.getName().substring(3, stlLib.getName().lastIndexOf(46)));
        }
        return flags;
    }

    public Collection<File> getStlLib(String abiName) {
        String stlLib;
        ArrayList libs = Lists.newArrayList();
        Abi abi = Abi.getByName((String)abiName);
        if (this.stlName.equals("stlport")) {
            stlLib = "stlport";
        } else if (this.stlName.equals("gnustl")) {
            String version = this.stlVersion != null ? this.stlVersion : this.ndkHandler.getGccToolchainVersion(abi);
            stlLib = "gnu-libstdc++/" + version;
        } else if (this.stlName.equals("gabi++")) {
            stlLib = "gabi++";
        } else if (this.stlName.equals("c++")) {
            stlLib = "llvm-libc++";
        } else {
            throw new AssertionError((Object)"Unreachable.  Either stl is invalid or stl is \"system\", in which case there is no library file and getStlLib should not be called.");
        }
        libs.add(this.getLibFile(stlLib, "lib" + this.stl + (this.isStatic != false ? ".a" : ".so")));
        if (this.ndkHandler.getRevision() != null && this.ndkHandler.getRevision().getMajor() >= 12 && this.stlName.equals("c++")) {
            if (this.isStatic.booleanValue()) {
                libs.add(this.getLibFile(stlLib, "libc++abi.a"));
                if (abi == Abi.ARMEABI || abi == Abi.ARMEABI_V7A) {
                    libs.add(this.getLibFile(stlLib, "libunwind.a"));
                }
                libs.add(this.getLibFile(stlLib, "libandroid_support.a"));
            } else if (abi == Abi.ARMEABI || abi == Abi.ARMEABI_V7A) {
                libs.add(this.getLibFile(stlLib, "libunwind.a"));
            }
        }
        return libs;
    }

    private File getLibFile(String stlLib, String name) {
        return new File(StlConfiguration.getStlBaseDirectory(this.ndkHandler), stlLib + "/libs/" + this.platform.getName() + "/" + name);
    }
}

