/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class ByteOrderMarkDetector
extends ResourceXmlDetector {
    public static final Issue BOM = Issue.create((String)"ByteOrderMark", (String)"Byte order mark inside files", (String)"Lint will flag any byte-order-mark (BOM) characters it finds in the middle of a file. Since we expect files to be encoded with UTF-8 (see the EnforceUTF8 issue), the BOM characters are not necessary, and they are not handled correctly by all tools. For example, if you have a BOM as part of a resource name in one particular translation, that name will not be considered identical to the base resource's name and the translation will not be used.", (Category)Category.I18N, (int)8, (Severity)Severity.FATAL, (Implementation)new Implementation(ByteOrderMarkDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("http://en.wikipedia.org/wiki/Byte_order_mark");

    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Nullable
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("name");
    }

    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String name = attribute.getValue();
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (c != '\ufeff') continue;
            Location location = context.getLocation((Node)attribute);
            String message = "Found byte-order-mark in the middle of a file";
            context.report(BOM, null, location, message);
            break;
        }
    }
}

