/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.annotations.NotNull;

public abstract class ActionRunner {
    public static void runInsideWriteAction(final @NotNull InterruptibleRunnable runnable) throws Exception {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/ActionRunner", "runInsideWriteAction"));
        }
        RunResult result = new WriteAction(){

            @Override
            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/ActionRunner$1", "run"));
                }
                runnable.run();
            }
        }.execute();
        if (result.getThrowable() instanceof Exception) {
            throw (Exception)result.getThrowable();
        }
        result.throwException();
    }

    public static <T> T runInsideWriteAction(final @NotNull InterruptibleRunnableWithResult<T> runnable) throws Exception {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/ActionRunner", "runInsideWriteAction"));
        }
        RunResult result = new WriteAction<T>(){

            @Override
            protected void run(@NotNull Result<T> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/ActionRunner$2", "run"));
                }
                result.setResult(runnable.run());
            }
        }.execute();
        if (result.getThrowable() instanceof Exception) {
            throw (Exception)result.getThrowable();
        }
        return result.throwException().getResultObject();
    }

    public static void runInsideReadAction(final @NotNull InterruptibleRunnable runnable) throws Exception {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/ActionRunner", "runInsideReadAction"));
        }
        ApplicationManager.getApplication().runReadAction(new ThrowableComputable<Void, Exception>(){

            public Void compute() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public static interface InterruptibleRunnableWithResult<T> {
        public T run() throws Exception;
    }

    public static interface InterruptibleRunnable {
        public void run() throws Exception;
    }
}

