/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import java.util.concurrent.atomic.AtomicReference;

public class ThreadSafeTransparentlyFailedValue<T, E extends Exception>
implements TransparentlyFailedValueI<T, E> {
    private final AtomicReference<ThrowableComputable<T, E>> myRef = new AtomicReference();

    @Override
    public void set(T t) {
        if (t != null) {
            this.myRef.set(new Value(t));
        }
    }

    @Override
    public void fail(E e) {
        this.myRef.set(new ExceptionHolder((Exception)e, null));
    }

    @Override
    public void failRuntime(RuntimeException e) {
        this.myRef.set(new RuntimeExceptionHolder(e));
    }

    @Override
    public T get() throws E {
        return (T)(this.myRef.get() == null ? null : this.myRef.get().compute());
    }

    @Override
    public boolean haveSomething() {
        return this.myRef.get() != null;
    }

    private static class RuntimeExceptionHolder<T, E extends Exception>
    implements ThrowableComputable<T, E> {
        private final RuntimeException myException;

        private RuntimeExceptionHolder(RuntimeException exception) {
            this.myException = exception;
        }

        public T compute() throws E {
            throw this.myException;
        }
    }

    private static class ExceptionHolder<T, E extends Exception>
    implements ThrowableComputable<T, E> {
        private final E myE;

        private ExceptionHolder(E e) {
            this.myE = e;
        }

        public T compute() throws E {
            throw this.myE;
        }

        /* synthetic */ ExceptionHolder(Exception x0, 1 x1) {
            this(x0);
        }
    }

    private static class Value<T, E extends Exception>
    implements ThrowableComputable<T, E> {
        private final T myT;

        private Value(T t) {
            this.myT = t;
        }

        public T compute() throws E {
            return this.myT;
        }
    }
}

