/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class AllInPackageGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    public AllInPackageGradleConfigurationProducer() {
        super((ConfigurationType)GradleExternalTaskConfigurationType.getInstance());
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiPackage psiPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)context.getPsiLocation());
        if (psiPackage == null) {
            return false;
        }
        sourceElement.set((Object)psiPackage);
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)module.getOptionValue("external.system.id"), (CharSequence)GradleConstants.SYSTEM_ID.toString())) {
            return false;
        }
        String linkedGradleProject = module.getOptionValue("external.linked.project.path");
        if (linkedGradleProject == null) {
            return false;
        }
        configuration.getSettings().setExternalProjectPath(linkedGradleProject);
        configuration.getSettings().setTaskNames(TEST_SOURCE_SET_TASKS);
        if (psiPackage.getQualifiedName().isEmpty()) {
            configuration.getSettings().setScriptParameters("--tests *");
        } else {
            configuration.getSettings().setScriptParameters(String.format("--tests %s.*", psiPackage.getQualifiedName()));
        }
        configuration.setName(AllInPackageGradleConfigurationProducer.suggestName(psiPackage, module));
        return true;
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        PsiPackage psiPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)context.getPsiLocation());
        if (psiPackage == null) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)context.getModule().getOptionValue("external.linked.project.path"), (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        if (!configuration.getSettings().getTaskNames().containsAll(TEST_SOURCE_SET_TASKS)) {
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        return psiPackage.getQualifiedName().isEmpty() ? scriptParameters.contains("--tests * ") : scriptParameters.contains(String.format("--tests %s.* ", psiPackage.getQualifiedName()));
    }

    private static String suggestName(@NotNull PsiPackage aPackage, @NotNull Module module) {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/plugins/gradle/execution/test/runner/AllInPackageGradleConfigurationProducer", "suggestName"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/gradle/execution/test/runner/AllInPackageGradleConfigurationProducer", "suggestName"));
        }
        return aPackage.getQualifiedName().isEmpty() ? ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{module.getName()}) : ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{aPackage.getQualifiedName()});
    }
}

