/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HgCommandProcessHandler
extends OSProcessHandler {
    private final boolean myBinary;
    private final ByteArrayOutputStream myBinaryOutput;

    public HgCommandProcessHandler(@NotNull GeneralCommandLine commandLine, boolean binary) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "org/zmlx/hg4idea/execution/HgCommandProcessHandler", "<init>"));
        }
        super(commandLine);
        this.myBinary = binary;
        this.myBinaryOutput = new ByteArrayOutputStream();
    }

    @NotNull
    protected BaseDataReader createOutputDataReader(BaseDataReader.SleepingPolicy sleepingPolicy) {
        MyBinaryOutputReader myBinaryOutputReader = this.myBinary ? new MyBinaryOutputReader(this.myProcess.getInputStream(), sleepingPolicy) : super.createOutputDataReader(sleepingPolicy);
        if (myBinaryOutputReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandProcessHandler", "createOutputDataReader"));
        }
        return myBinaryOutputReader;
    }

    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        ByteArrayOutputStream byteArrayOutputStream = this.myBinaryOutput;
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/HgCommandProcessHandler", "getBinaryOutput"));
        }
        return byteArrayOutputStream;
    }

    private class MyBinaryOutputReader
    extends BinaryOutputReader {
        public MyBinaryOutputReader(@Nullable InputStream stream, BaseDataReader.SleepingPolicy simple) {
            if (stream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/zmlx/hg4idea/execution/HgCommandProcessHandler$MyBinaryOutputReader", "<init>"));
            }
            super(stream, simple);
            this.start();
        }

        protected void onBinaryAvailable(@NotNull byte[] data, int size) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/zmlx/hg4idea/execution/HgCommandProcessHandler$MyBinaryOutputReader", "onBinaryAvailable"));
            }
            HgCommandProcessHandler.this.myBinaryOutput.write(data, 0, size);
        }

        protected Future<?> executeOnPooledThread(Runnable runnable) {
            return HgCommandProcessHandler.this.executeOnPooledThread(runnable);
        }
    }
}

