/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.branch.HgBranchUtil;
import org.zmlx.hg4idea.command.HgBookmarkCommand;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgTaskHandler
extends DvcsTaskHandler<HgRepository> {
    public HgTaskHandler(@NotNull HgRepositoryManager repositoryManager, @NotNull Project project) {
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "org/zmlx/hg4idea/HgTaskHandler", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/HgTaskHandler", "<init>"));
        }
        super((AbstractRepositoryManager)repositoryManager, project, "bookmark");
    }

    protected void checkout(@NotNull String taskName, @NotNull List<HgRepository> repos, @Nullable Runnable callInAwtLater) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "org/zmlx/hg4idea/HgTaskHandler", "checkout"));
        }
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repos", "org/zmlx/hg4idea/HgTaskHandler", "checkout"));
        }
        HgUpdateCommand.updateTo(!HgBranchUtil.getCommonBookmarks(repos).contains(taskName) ? "head() and not bookmark() and branch(" + taskName + ")" : taskName, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(@NotNull String name, @NotNull List<HgRepository> repositories) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/HgTaskHandler", "checkoutAsNewBranch"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/HgTaskHandler", "checkoutAsNewBranch"));
        }
        HgBookmarkCommand.createBookmark(repositories, name, true);
    }

    protected String getActiveBranch(HgRepository repository) {
        String bookmark = repository.getCurrentBookmark();
        return bookmark == null ? repository.getCurrentBranch() : bookmark;
    }

    @NotNull
    protected Iterable<String> getAllBranches(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/HgTaskHandler", "getAllBranches"));
        }
        Iterable iterable = ContainerUtil.concat((Iterable[])new Iterable[]{HgUtil.getSortedNamesWithoutHashes(repository.getBookmarks()), repository.getOpenedBranches()});
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgTaskHandler", "getAllBranches"));
        }
        return iterable;
    }

    protected void mergeAndClose(final @NotNull String branch, @NotNull List<HgRepository> repositories) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/zmlx/hg4idea/HgTaskHandler", "mergeAndClose"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "org/zmlx/hg4idea/HgTaskHandler", "mergeAndClose"));
        }
        String bookmarkRevisionArg = "bookmark(\"" + branch + "\")";
        FileDocumentManager.getInstance().saveAllDocuments();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (final HgRepository repository : repositories) {
            HgMergeCommand.mergeWith(repository, bookmarkRevisionArg, updatedFiles, new Runnable(){

                @Override
                public void run() {
                    Project project = repository.getProject();
                    VirtualFile repositoryRoot = repository.getRoot();
                    try {
                        new HgCommitCommand(project, repository, "Automated merge with " + branch).execute();
                        new HgBookmarkCommand(project, repositoryRoot, branch).deleteBookmark();
                    }
                    catch (HgCommandException e) {
                        HgErrorUtil.handleException(project, e);
                    }
                    catch (VcsException e) {
                        VcsNotifier.getInstance((Project)project).notifyError("Exception during merge commit with " + branch, e.getMessage());
                    }
                }
            });
        }
    }

    protected boolean hasBranch(@NotNull HgRepository repository, @NotNull String name) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/HgTaskHandler", "hasBranch"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/zmlx/hg4idea/HgTaskHandler", "hasBranch"));
        }
        return HgUtil.getNamesWithoutHashes(repository.getBookmarks()).contains(name) || repository.getOpenedBranches().contains(name);
    }
}

