/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class MockableJarGenerator {
    private static final int EMPTY_FLAGS = 0;
    private static final String CONSTRUCTOR = "<init>";
    private static final String CLASS_CONSTRUCTOR = "<clinit>";
    private static final ImmutableSet<String> ENUM_METHODS = ImmutableSet.of((Object)"<clinit>", (Object)"valueOf", (Object)"values");
    private static final ImmutableSet<Type> INTEGER_LIKE_TYPES = ImmutableSet.of((Object)Type.INT_TYPE, (Object)Type.BYTE_TYPE, (Object)Type.BOOLEAN_TYPE, (Object)Type.CHAR_TYPE, (Object)Type.SHORT_TYPE);
    private final boolean returnDefaultValues;
    private final ImmutableSet<String> prefixesToSkip = ImmutableSet.of((Object)"java.", (Object)"javax.", (Object)"org.xml.", (Object)"org.w3c.", (Object)"junit.", (Object)"org.apache.commons.logging", (Object[])new String[0]);

    public MockableJarGenerator(boolean returnDefaultValues) {
        this.returnDefaultValues = returnDefaultValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMockableJar(File input, File output) throws IOException {
        Preconditions.checkState((boolean)output.createNewFile(), (String)"Output file [%s] already exists.", (Object[])new Object[]{output.getAbsolutePath()});
        JarFile androidJar = null;
        ZipOutputStream outputStream = null;
        try {
            androidJar = new JarFile(input);
            outputStream = new JarOutputStream(new FileOutputStream(output));
            for (JarEntry entry : Collections.list(androidJar.entries())) {
                InputStream inputStream = androidJar.getInputStream(entry);
                if (entry.getName().endsWith(".class")) {
                    if (!this.skipClass(entry.getName().replace("/", "."))) {
                        this.rewriteClass(entry, inputStream, (JarOutputStream)outputStream);
                    }
                } else {
                    ((JarOutputStream)outputStream).putNextEntry(entry);
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                inputStream.close();
            }
        }
        finally {
            if (androidJar != null) {
                androidJar.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private boolean skipClass(String className) {
        for (String prefix : this.prefixesToSkip) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void rewriteClass(JarEntry entry, InputStream inputStream, JarOutputStream outputStream) throws IOException {
        ClassReader classReader = new ClassReader(inputStream);
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        this.modifyClass(classNode);
        ClassWriter classWriter = new ClassWriter(3);
        classNode.accept((ClassVisitor)classWriter);
        outputStream.putNextEntry(new ZipEntry(entry.getName()));
        outputStream.write(classWriter.toByteArray());
    }

    private void modifyClass(ClassNode classNode) {
        classNode.access &= 0xFFFFFFEF;
        List methodNodes = classNode.methods;
        for (MethodNode methodNode : methodNodes) {
            methodNode.access &= 0xFFFFFFEF;
            this.fixMethodBody(methodNode, classNode);
        }
        List fieldNodes = classNode.fields;
        for (FieldNode fieldNode : fieldNodes) {
            if ((fieldNode.access & 1) == 0 || (fieldNode.access & 8) != 0) continue;
            fieldNode.access &= 0xFFFFFFEF;
        }
        List innerClasses = classNode.innerClasses;
        for (InnerClassNode innerClassNode : innerClasses) {
            innerClassNode.access &= 0xFFFFFFEF;
        }
    }

    private void fixMethodBody(MethodNode methodNode, ClassNode classNode) {
        if ((methodNode.access & 0x100) != 0 || (methodNode.access & 0x400) != 0) {
            return;
        }
        if ((classNode.access & 0x4000) != 0 && ENUM_METHODS.contains((Object)methodNode.name)) {
            return;
        }
        Type returnType = Type.getReturnType((String)methodNode.desc);
        InsnList instructions = methodNode.instructions;
        if (methodNode.name.equals(CONSTRUCTOR)) {
            boolean deadCode = false;
            for (AbstractInsnNode instruction : instructions.toArray()) {
                if (!deadCode) {
                    if (instruction.getOpcode() != 183) continue;
                    instructions.insert(instruction, (AbstractInsnNode)new InsnNode(177));
                    deadCode = true;
                    continue;
                }
                instructions.remove(instruction);
            }
        } else {
            instructions.clear();
            if (this.returnDefaultValues || methodNode.name.equals(CLASS_CONSTRUCTOR)) {
                if (INTEGER_LIKE_TYPES.contains((Object)returnType)) {
                    instructions.add((AbstractInsnNode)new InsnNode(3));
                } else if (returnType.equals((Object)Type.LONG_TYPE)) {
                    instructions.add((AbstractInsnNode)new InsnNode(9));
                } else if (returnType.equals((Object)Type.FLOAT_TYPE)) {
                    instructions.add((AbstractInsnNode)new InsnNode(11));
                } else if (returnType.equals((Object)Type.DOUBLE_TYPE)) {
                    instructions.add((AbstractInsnNode)new InsnNode(14));
                } else {
                    instructions.add((AbstractInsnNode)new InsnNode(1));
                }
                instructions.add((AbstractInsnNode)new InsnNode(returnType.getOpcode(172)));
            } else {
                instructions.insert(MockableJarGenerator.throwExceptionsList(methodNode, classNode));
            }
        }
    }

    private static InsnList throwExceptionsList(MethodNode methodNode, ClassNode classNode) {
        try {
            String runtimeException = Type.getInternalName(RuntimeException.class);
            Constructor constructor = RuntimeException.class.getConstructor(String.class);
            InsnList instructions = new InsnList();
            instructions.add((AbstractInsnNode)new TypeInsnNode(187, runtimeException));
            instructions.add((AbstractInsnNode)new InsnNode(89));
            String className = classNode.name.replace('/', '.');
            instructions.add((AbstractInsnNode)new LdcInsnNode((Object)("Method " + methodNode.name + " in " + className + " not mocked. " + "See http://g.co/androidstudio/not-mocked for details.")));
            instructions.add((AbstractInsnNode)new MethodInsnNode(183, runtimeException, CONSTRUCTOR, Type.getType(constructor).getDescriptor(), false));
            instructions.add((AbstractInsnNode)new InsnNode(191));
            return instructions;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

