/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedProtocolVersionException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.IPasswordRetriever;
import com.glavsoft.rfb.IRfbSessionListener;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.transport.BaudrateMeter;
import com.glavsoft.transport.Transport;
import com.glavsoft.utils.ViewerControlApi;
import com.glavsoft.viewer.ConnectionErrorException;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.RfbConnectionWorker;
import com.glavsoft.viewer.UiSettings;
import com.glavsoft.viewer.VncKeepAliveThread;
import com.glavsoft.viewer.swing.ClipboardControllerImpl;
import com.glavsoft.viewer.swing.SwingViewerWindow;
import com.glavsoft.viewer.swing.SwingViewerWindowFactory;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class SwingRfbConnectionWorker
extends SwingWorker<Void, String>
implements RfbConnectionWorker,
IRfbSessionListener {
    private String predefinedPassword;
    private ConnectionPresenter presenter;
    private SwingViewerWindowFactory viewerWindowFactory;
    private Logger logger;
    private volatile boolean isStoppingProcess;
    private SwingViewerWindow viewerWindow;
    private String connectionString;
    protected String configurationName;
    private VncKeepAliveThread vncKeepAliveThread;
    private Protocol workingProtocol;
    private Socket workingSocket;
    private ProtocolSettings rfbSettings;
    private UiSettings uiSettings;
    private ViewerControlApi viewerControlApi;

    @Override
    public Void doInBackground() throws Exception {
        if (null == this.workingSocket) {
            throw new ConnectionErrorException("Null socket");
        }
        this.workingSocket.setTcpNoDelay(true);
        Transport transport = new Transport(this.workingSocket);
        BaudrateMeter baudrateMeter = new BaudrateMeter();
        transport.setBaudrateMeter(baudrateMeter);
        this.workingProtocol = new Protocol(transport, new PasswordChooser(), this.rfbSettings);
        this.viewerControlApi = new ViewerControlApi(this.workingProtocol, baudrateMeter);
        String message = "Handshaking with remote host";
        this.logger.info(message);
        this.publish(message);
        this.workingProtocol.handshake();
        return null;
    }

    public SwingRfbConnectionWorker(String predefinedPassword, ConnectionPresenter presenter, SwingViewerWindowFactory viewerWindowFactory) {
        this.predefinedPassword = predefinedPassword;
        this.presenter = presenter;
        this.viewerWindowFactory = viewerWindowFactory;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @Override
    protected void process(List<String> strings) {
        String message = strings.get(strings.size() - 1);
        this.presenter.showMessage(message);
    }

    @Override
    protected void done() {
        try {
            this.get();
            this.presenter.showMessage("Handshake established");
            ClipboardControllerImpl clipboardController = new ClipboardControllerImpl(this.workingProtocol, this.rfbSettings.getRemoteCharsetName());
            clipboardController.setEnabled(this.rfbSettings.isAllowClipboardTransfer());
            this.rfbSettings.addListener(clipboardController);
            this.viewerWindow = this.viewerWindowFactory.createViewerWindow(this.workingProtocol, this.rfbSettings, this.uiSettings, this.connectionString, this.configurationName, this.vncKeepAliveThread, this.presenter);
            this.workingProtocol.startNormalHandling(this, this.viewerWindow.getRepaintController(), clipboardController);
            this.presenter.showMessage("Started");
            this.presenter.successfulRfbConnection();
        }
        catch (CancellationException e) {
            this.logger.info("Cancelled");
            this.presenter.showMessage("Cancelled");
            this.presenter.connectionCancelled();
        }
        catch (InterruptedException e) {
            this.logger.info("Interrupted");
            this.presenter.showMessage("Interrupted");
            this.presenter.connectionFailed();
        }
        catch (ExecutionException ee) {
            String errorMessage;
            String errorTitle;
            try {
                throw ee.getCause();
            }
            catch (UnsupportedProtocolVersionException e) {
                errorTitle = "Unsupported Protocol Version";
                errorMessage = e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (UnsupportedSecurityTypeException e) {
                errorTitle = "Unsupported Security Type";
                errorMessage = e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (AuthenticationFailedException e) {
                errorTitle = "Authentication Failed";
                errorMessage = e.getMessage();
                this.logger.severe(errorMessage);
                this.presenter.clearPredefinedPassword();
            }
            catch (TransportException e) {
                errorTitle = "Connection Error";
                String string = String.valueOf(e.getMessage());
                errorMessage = string.length() != 0 ? "Connection Error: ".concat(string) : new String("Connection Error: ");
                this.logger.severe(errorMessage);
                this.logger.throwing("", "", e);
            }
            catch (IOException e) {
                errorTitle = "Connection Error";
                String string = String.valueOf(e.getMessage());
                errorMessage = string.length() != 0 ? "Connection Error:  ".concat(string) : new String("Connection Error:  ");
                this.logger.severe(errorMessage);
            }
            catch (FatalException e) {
                errorTitle = "Connection Error";
                String string = String.valueOf(e.getMessage());
                errorMessage = string.length() != 0 ? "Connection Error:   ".concat(string) : new String("Connection Error:   ");
                this.logger.severe(errorMessage);
            }
            catch (Throwable e) {
                errorTitle = "Error";
                String string = String.valueOf(e.getMessage());
                errorMessage = string.length() != 0 ? "Error: ".concat(string) : new String("Error: ");
                this.logger.severe(errorMessage);
            }
            this.presenter.showReconnectDialog(errorTitle, errorMessage);
            this.presenter.clearMessage();
            this.presenter.connectionFailed();
        }
    }

    @Override
    public void rfbSessionStopped(final String reason) {
        if (this.workingProtocol != null) {
            this.workingProtocol.cleanUpSession();
        }
        if (this.isStoppingProcess) {
            return;
        }
        this.cleanUpUISessionAndConnection();
        String string = String.valueOf(reason);
        this.logger.info(string.length() != 0 ? "Rfb session stopped: ".concat(string) : new String("Rfb session stopped: "));
        if (this.presenter.needReconnection()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingRfbConnectionWorker.this.presenter.showReconnectDialog("Connection error", reason);
                    SwingRfbConnectionWorker.this.presenter.reconnect(SwingRfbConnectionWorker.this.predefinedPassword);
                }
            });
        }
    }

    @Override
    public boolean cancel() {
        boolean res = super.cancel(true);
        if (res && this.workingProtocol != null) {
            this.workingProtocol.cleanUpSession();
        }
        this.cleanUpUISessionAndConnection();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpUISessionAndConnection() {
        SwingRfbConnectionWorker swingRfbConnectionWorker = this;
        synchronized (swingRfbConnectionWorker) {
            this.isStoppingProcess = true;
        }
        if (this.workingSocket != null && this.workingSocket.isConnected()) {
            try {
                this.workingSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.viewerWindow != null) {
            this.viewerWindow.close();
        }
        swingRfbConnectionWorker = this;
        synchronized (swingRfbConnectionWorker) {
            this.vncKeepAliveThread.setCrashed();
            this.isStoppingProcess = false;
        }
    }

    @Override
    public void setWorkingSocket(Socket workingSocket) {
        this.workingSocket = workingSocket;
    }

    @Override
    public void setRfbSettings(ProtocolSettings rfbSettings) {
        this.rfbSettings = rfbSettings;
    }

    @Override
    public void setUiSettings(UiSettings uiSettings) {
        this.uiSettings = uiSettings;
    }

    @Override
    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    @Override
    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    @Override
    public void setVncKeepAliveThread(VncKeepAliveThread vncKeepAliveThread) {
        this.vncKeepAliveThread = vncKeepAliveThread;
    }

    @Override
    public ViewerControlApi getViewerControlApi() {
        return this.viewerControlApi;
    }

    private class PasswordChooser
    implements IPasswordRetriever {
        private PasswordChooser() {
        }

        @Override
        public String getPassword() {
            return SwingRfbConnectionWorker.this.predefinedPassword;
        }
    }
}

