/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.viewer.CancelConnectionException;
import com.glavsoft.viewer.CancelConnectionQuietlyException;
import com.glavsoft.viewer.ConnectionErrorException;
import com.glavsoft.viewer.ConnectionPresenter;
import com.glavsoft.viewer.NetworkConnectionWorker;
import com.glavsoft.viewer.VncKeepAliveThread;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.ssh.SshConnectionManager;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public class SwingNetworkConnectionWorker
extends SwingWorker<Socket, String>
implements NetworkConnectionWorker {
    public static final int MAX_HOSTNAME_LENGTH_FOR_MESSAGES = 40;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean hasSshSupport;
    private ConnectionParams connectionParams;
    private ConnectionPresenter presenter;
    private VncKeepAliveThread vncKeepAliveThread;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Socket doInBackground() throws Exception {
        String host;
        int port;
        String message;
        block5: {
            String string = this.connectionParams.hostName;
            int n = this.connectionParams.getPortNumber();
            String s = new StringBuilder(19 + String.valueOf(string).length()).append("<b>").append(string).append("</b>:").append(n).toString();
            if (this.connectionParams.useSsh()) {
                string = String.valueOf(s);
                String string2 = this.connectionParams.sshUserName;
                String string3 = this.connectionParams.sshHostName;
                int n2 = this.connectionParams.getSshPortNumber();
                s = new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(" <i>(via ssh://").append(string2).append("@").append(string3).append(":").append(n2).append(")</i>").toString();
            }
            String string4 = s;
            message = new StringBuilder(34 + String.valueOf(string4).length()).append("<html>Trying to connect to ").append(string4).append("</html>").toString();
            this.logger.info(message.replaceAll("<[^<>]+?>", ""));
            this.publish(message);
            if (this.hasSshSupport && this.connectionParams.useSsh()) {
                SshConnectionManager sshConnectionManager = new SshConnectionManager(null);
                String string5 = this.connectionParams.sshHostName;
                int n3 = this.connectionParams.getSshPortNumber();
                message = new StringBuilder(35 + String.valueOf(string5).length()).append("Creating SSH tunnel to ").append(string5).append(":").append(n3).toString();
                this.logger.info(message);
                this.publish(message);
                port = sshConnectionManager.connect(this.connectionParams);
                if (sshConnectionManager.isConnected()) {
                    host = "127.0.0.1";
                    message = new StringBuilder(36 + String.valueOf(host).length()).append("SSH tunnel established: ").append(host).append(":").append(port).toString();
                    this.logger.info(message);
                    this.publish(message);
                    break block5;
                } else {
                    String string6;
                    String string7 = String.valueOf(sshConnectionManager.getErrorMessage());
                    if (string7.length() != 0) {
                        string6 = "Could not create SSH tunnel: ".concat(string7);
                        throw new ConnectionErrorException(string6);
                    }
                    string6 = new String("Could not create SSH tunnel: ");
                    throw new ConnectionErrorException(string6);
                }
            }
            host = this.connectionParams.hostName;
            port = this.connectionParams.getPortNumber();
        }
        String string = this.connectionParams.useSsh() ? " (tunneled)" : "";
        message = new StringBuilder(31 + String.valueOf(host).length() + String.valueOf(string).length()).append("Connecting to host ").append(host).append(":").append(port).append(string).toString();
        this.logger.info(message);
        this.publish(message);
        return new Socket(host, port);
    }

    private String formatHostString(String hostName) {
        if (hostName.length() <= 40) {
            return hostName;
        }
        return String.valueOf(hostName.substring(0, 40)).concat("...");
    }

    @Override
    protected void process(List<String> strings) {
        String message = strings.get(strings.size() - 1);
        this.presenter.showMessage(message);
    }

    @Override
    protected void done() {
        try {
            Socket socket = (Socket)this.get();
            this.presenter.successfulNetworkConnection(socket);
        }
        catch (CancellationException e) {
            this.logger.info("Cancelled");
            this.presenter.showMessage("Cancelled");
            this.presenter.connectionFailed();
        }
        catch (InterruptedException e) {
            this.logger.info("Interrupted");
            this.presenter.showMessage("Interrupted");
            this.presenter.connectionFailed();
        }
        catch (ExecutionException e) {
            String errorMessage = null;
            try {
                throw e.getCause();
            }
            catch (UnknownHostException uhe) {
                String string = String.valueOf(this.connectionParams.hostName);
                this.logger.severe(string.length() != 0 ? "Unknown host: ".concat(string) : new String("Unknown host: "));
                String string2 = this.formatHostString(this.connectionParams.hostName);
                errorMessage = new StringBuilder(16 + String.valueOf(string2).length()).append("Unknown host: '").append(string2).append("'").toString();
            }
            catch (IOException ioe) {
                String string = this.connectionParams.hostName;
                int n = this.connectionParams.getPortNumber();
                String string3 = String.valueOf(ioe.getMessage());
                this.logger.severe(new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Couldn't connect to '").append(string).append(":").append(n).append("':\n").append(string3).toString());
                string = this.connectionParams.hostName;
                n = this.connectionParams.getPortNumber();
                string3 = String.valueOf(ioe.getMessage());
                this.logger.log(Level.FINEST, new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Couldn't connect to '").append(string).append(":").append(n).append("':\n").append(string3).toString(), ioe);
                string = this.formatHostString(this.connectionParams.hostName);
                n = this.connectionParams.getPortNumber();
                string3 = String.valueOf(ioe.getMessage());
                errorMessage = new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Couldn't connect to '").append(string).append(":").append(n).append("':\n").append(string3).toString();
            }
            catch (CancelConnectionQuietlyException cce) {
                String string = String.valueOf(cce.getMessage());
                this.logger.warning(string.length() != 0 ? "Cancelled by user: ".concat(string) : new String("Cancelled by user: "));
            }
            catch (CancelConnectionException cce) {
                String string = String.valueOf(cce.getMessage());
                this.logger.severe(string.length() != 0 ? "Cancelled: ".concat(string) : new String("Cancelled: "));
                errorMessage = cce.getMessage();
            }
            catch (AccessControlException ace) {
                String string = this.connectionParams.hostName;
                int n = this.connectionParams.getPortNumber();
                String string4 = String.valueOf(ace.getMessage());
                this.logger.severe(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string4).length()).append("Couldn't connect to: ").append(string).append(":").append(n).append(": ").append(string4).toString());
                string = this.connectionParams.hostName;
                n = this.connectionParams.getPortNumber();
                string4 = String.valueOf(ace.getMessage());
                this.logger.log(Level.FINEST, new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string4).length()).append("Couldn't connect to: ").append(string).append(":").append(n).append(": ").append(string4).toString(), ace);
                errorMessage = "Access control error";
            }
            catch (ConnectionErrorException cee) {
                String string = String.valueOf(cee.getMessage());
                String string5 = this.connectionParams.hostName;
                int n = this.connectionParams.getPortNumber();
                this.logger.severe(new StringBuilder(19 + String.valueOf(string).length() + String.valueOf(string5).length()).append(string).append(" host: ").append(string5).append(":").append(n).toString());
                string = String.valueOf(cee.getMessage());
                string5 = this.formatHostString(this.connectionParams.hostName);
                n = this.connectionParams.getPortNumber();
                errorMessage = new StringBuilder(19 + String.valueOf(string).length() + String.valueOf(string5).length()).append(string).append("\nHost: ").append(string5).append(":").append(n).toString();
            }
            catch (Throwable throwable) {
                String string = this.formatHostString(this.connectionParams.hostName);
                int n = this.connectionParams.getPortNumber();
                String string6 = String.valueOf(throwable.getMessage());
                this.logger.log(Level.FINEST, new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string6).length()).append("Couldn't connect to '").append(string).append(":").append(n).append("':\n").append(string6).toString(), throwable);
                string = this.formatHostString(this.connectionParams.hostName);
                n = this.connectionParams.getPortNumber();
                string6 = String.valueOf(throwable.getMessage());
                errorMessage = new StringBuilder(36 + String.valueOf(string).length() + String.valueOf(string6).length()).append("Couldn't connect to '").append(string).append(":").append(n).append("':\n").append(string6).toString();
            }
            if (errorMessage != null) {
                this.presenter.showConnectionErrorDialog(errorMessage);
            }
            this.presenter.clearMessage();
            this.presenter.connectionFailed();
        }
    }

    @Override
    public void setConnectionParams(ConnectionParams connectionParams) {
        this.connectionParams = connectionParams;
    }

    @Override
    public void setPresenter(ConnectionPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setHasSshSupport(boolean hasSshSupport) {
        this.hasSshSupport = hasSshSupport;
    }

    @Override
    public void setVncKeepAliveThread(VncKeepAliveThread vncKeepAliveThread) {
        this.vncKeepAliveThread = vncKeepAliveThread;
    }

    @Override
    public boolean cancel() {
        this.vncKeepAliveThread.setCrashed();
        return super.cancel(true);
    }
}

