/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.RestrictiveCodeVisitor;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.plugin.internal.InvalidPluginIdException;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.PluginDependencySpec;
import org.gradle.plugin.use.internal.DefaultPluginRequests;
import org.gradle.plugin.use.internal.PluginRequestCollector;
import org.gradle.plugin.use.internal.PluginRequests;

public class PluginUseScriptBlockMetadataExtractor {
    public static final String INVALID_ARGUMENT_LIST = "argument list must be exactly 1 literal non empty string";
    public static final String BASE_MESSAGE = "only id(String) method calls allowed in plugins {} script block";
    public static final String VERSION_MESSAGE = "only version(String) method calls allowed in plugins {} script block";
    private static final String NOT_LITERAL_METHOD_NAME = "method name must be literal (i.e. not a variable)";
    private static final String NOT_LITERAL_ID_METHOD_NAME = "only id(String) method calls allowed in plugins {} script block - method name must be literal (i.e. not a variable)";
    private final DocumentationRegistry documentationRegistry;
    private final PluginRequestCollector pluginRequestCollector;

    public PluginUseScriptBlockMetadataExtractor(ScriptSource scriptSource, DocumentationRegistry documentationRegistry) {
        this.pluginRequestCollector = new PluginRequestCollector(scriptSource);
        this.documentationRegistry = documentationRegistry;
    }

    public void extract(SourceUnit sourceUnit, ScriptBlock scriptBlock) {
        ClosureExpression closureArg = scriptBlock.getClosureExpression();
        closureArg.getCode().visit((GroovyCodeVisitor)new RestrictiveCodeVisitor(sourceUnit, this.formatErrorMessage(BASE_MESSAGE)){

            public void visitBlockStatement(BlockStatement block) {
                for (Statement statement : block.getStatements()) {
                    statement.visit((GroovyCodeVisitor)this);
                }
            }

            public void visitMethodCallExpression(MethodCallExpression call) {
                if (!call.isImplicitThis()) {
                    Expression target = call.getObjectExpression();
                    if (!(target instanceof MethodCallExpression)) {
                        this.restrict((ASTNode)target, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.BASE_MESSAGE));
                        return;
                    }
                    this.visitMethodCallExpression((MethodCallExpression)target);
                }
                if (call.getMethod() instanceof ConstantExpression) {
                    ConstantExpression methodName = (ConstantExpression)call.getMethod();
                    if (AstUtils.isString((ConstantExpression)methodName)) {
                        String methodNameText = methodName.getText();
                        if (methodNameText.equals("id") || methodNameText.equals("version")) {
                            ConstantExpression argumentExpression = this.hasSingleConstantStringArg(call);
                            if (argumentExpression == null) {
                                return;
                            }
                            String argStringValue = argumentExpression.getValue().toString();
                            if (argStringValue.length() == 0) {
                                this.restrict((ASTNode)argumentExpression, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.INVALID_ARGUMENT_LIST));
                                return;
                            }
                            if (methodName.getText().equals("id")) {
                                if (call.isImplicitThis()) {
                                    try {
                                        PluginId.validate(argStringValue);
                                        call.setNodeMetaData(PluginDependencySpec.class, (Object)PluginUseScriptBlockMetadataExtractor.this.pluginRequestCollector.createSpec(call.getLineNumber()).id(argStringValue));
                                    }
                                    catch (InvalidPluginIdException e) {
                                        this.restrict((ASTNode)argumentExpression, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(e.getReason()));
                                    }
                                } else {
                                    this.restrict((ASTNode)call, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.BASE_MESSAGE));
                                }
                            }
                            if (methodName.getText().equals("version")) {
                                Expression objectExpression = call.getObjectExpression();
                                if (objectExpression instanceof MethodCallExpression) {
                                    PluginDependencySpec spec = (PluginDependencySpec)objectExpression.getNodeMetaData(PluginDependencySpec.class);
                                    if (spec != null) {
                                        spec.version(argStringValue);
                                    }
                                } else {
                                    this.restrict((ASTNode)call, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.BASE_MESSAGE));
                                }
                            }
                        } else if (!call.isImplicitThis()) {
                            this.restrict((ASTNode)methodName, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.VERSION_MESSAGE));
                        } else {
                            this.restrict((ASTNode)methodName, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.BASE_MESSAGE));
                        }
                    } else {
                        this.restrict((ASTNode)methodName, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.NOT_LITERAL_ID_METHOD_NAME));
                    }
                } else {
                    this.restrict((ASTNode)call);
                }
            }

            private ConstantExpression hasSingleConstantStringArg(MethodCallExpression call) {
                ArgumentListExpression argumentList = (ArgumentListExpression)call.getArguments();
                if (argumentList.getExpressions().size() == 1) {
                    Expression argumentExpression = (Expression)argumentList.getExpressions().get(0);
                    if (argumentExpression instanceof ConstantExpression) {
                        ConstantExpression constantArgumentExpression = (ConstantExpression)argumentExpression;
                        if (AstUtils.isString((ConstantExpression)constantArgumentExpression)) {
                            return constantArgumentExpression;
                        }
                        this.restrict((ASTNode)constantArgumentExpression, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.INVALID_ARGUMENT_LIST));
                    } else {
                        this.restrict((ASTNode)argumentExpression, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.INVALID_ARGUMENT_LIST));
                    }
                } else {
                    this.restrict((ASTNode)argumentList, PluginUseScriptBlockMetadataExtractor.this.formatErrorMessage(PluginUseScriptBlockMetadataExtractor.INVALID_ARGUMENT_LIST));
                }
                return null;
            }

            public void visitExpressionStatement(ExpressionStatement statement) {
                statement.getExpression().visit((GroovyCodeVisitor)this);
            }
        });
    }

    public PluginRequests getRequests() {
        return new DefaultPluginRequests(this.pluginRequestCollector.getRequests());
    }

    public String formatErrorMessage(String message) {
        return String.format("%s%n%nSee %s for information on the plugins {} block%n%n", message, this.documentationRegistry.getDocumentationFor("plugins", "sec:plugins_block"));
    }
}

