/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.util.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.RelativePathSpec;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.util.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSpecFactory {
    public Spec<FileTreeElement> createSpec(PatternSet patternSet) {
        return Specs.and((Spec[])new Spec[]{this.createIncludeSpec(patternSet), Specs.not(this.createExcludeSpec(patternSet))});
    }

    public Spec<FileTreeElement> createIncludeSpec(PatternSet patternSet) {
        ArrayList<Spec<FileTreeElement>> allIncludeSpecs = new ArrayList<Spec<FileTreeElement>>(1 + patternSet.getIncludeSpecs().size());
        if (!patternSet.getIncludes().isEmpty()) {
            allIncludeSpecs.add(this.createSpec(patternSet.getIncludes(), true, patternSet.isCaseSensitive()));
        }
        allIncludeSpecs.addAll(patternSet.getIncludeSpecs());
        return Specs.or((boolean)true, allIncludeSpecs);
    }

    public Spec<FileTreeElement> createExcludeSpec(PatternSet patternSet) {
        List<String> defaultExcludes;
        ArrayList<Spec<FileTreeElement>> allExcludeSpecs = new ArrayList<Spec<FileTreeElement>>(2 + patternSet.getExcludeSpecs().size());
        if (!patternSet.getExcludes().isEmpty()) {
            allExcludeSpecs.add(this.createSpec(patternSet.getExcludes(), false, patternSet.isCaseSensitive()));
        }
        if (!(defaultExcludes = Arrays.asList(DirectoryScanner.getDefaultExcludes())).isEmpty()) {
            allExcludeSpecs.add(this.createSpec(defaultExcludes, false, patternSet.isCaseSensitive()));
        }
        allExcludeSpecs.addAll(patternSet.getExcludeSpecs());
        return Specs.or((boolean)false, allExcludeSpecs);
    }

    protected Spec<FileTreeElement> createSpec(Collection<String> patterns, boolean include, boolean caseSensitive) {
        ArrayList<RelativePathSpec> matchers = new ArrayList<RelativePathSpec>(patterns.size());
        for (String pattern : patterns) {
            Spec<RelativePath> patternMatcher = PatternMatcherFactory.getPatternMatcher(include, caseSensitive, pattern);
            matchers.add(new RelativePathSpec(patternMatcher));
        }
        return Specs.or((boolean)include, matchers);
    }
}

