/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassPresenceFilter
implements ClassVisitor {
    private final ClassPool classPool;
    private final ClassVisitor presentClassVisitor;
    private final ClassVisitor missingClassVisitor;

    public ClassPresenceFilter(ClassPool classPool, ClassVisitor presentClassVisitor, ClassVisitor missingClassVisitor) {
        this.classPool = classPool;
        this.presentClassVisitor = presentClassVisitor;
        this.missingClassVisitor = missingClassVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classFileVisitor = this.classFileVisitor(programClass);
        if (classFileVisitor != null) {
            classFileVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassVisitor classFileVisitor = this.classFileVisitor(libraryClass);
        if (classFileVisitor != null) {
            classFileVisitor.visitLibraryClass(libraryClass);
        }
    }

    private ClassVisitor classFileVisitor(Clazz clazz) {
        return this.classPool.getClass(clazz.getName()) != null ? this.presentClassVisitor : this.missingClassVisitor;
    }
}

