/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.google.common.collect.Lists;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.util.Range;
import com.intellij.xdebugger.XSourcePosition;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCollector {
    private final List<PsiMethod> myMethods;
    private Range<Integer> myLineRange;

    public MethodCollector(@NotNull Project project, @NotNull XSourcePosition pos) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/hybrid/MethodCollector", "<init>"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/android/tools/ndk/run/hybrid/MethodCollector", "<init>"));
        }
        this.myMethods = Lists.newLinkedList();
        this.doCollect(project, pos);
    }

    private void doCollect(@NotNull Project project, @NotNull XSourcePosition pos) {
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/hybrid/MethodCollector", "doCollect"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/android/tools/ndk/run/hybrid/MethodCollector", "doCollect"));
        }
        Document doc = FileDocumentManager.getInstance().getDocument(pos.getFile());
        if (doc == null) {
            return;
        }
        PsiElement element = DebuggerUtilsEx.findElementAt((PsiFile)PsiDocumentManager.getInstance((Project)project).getPsiFile(doc), (int)pos.getOffset());
        while ((parent = element.getParent()) != null && parent.getTextOffset() >= pos.getOffset()) {
            element = parent;
        }
        int line = pos.getLine();
        int startOffset = doc.getLineStartOffset(line);
        final TextRange exprRange = new TextRange(startOffset, doc.getLineEndOffset(line));
        final Ref refExprRange = new Ref((Object)exprRange);
        JavaRecursiveElementVisitor elementVisitor = new JavaRecursiveElementVisitor(){

            public void visitStatement(PsiStatement statement) {
                if (exprRange.intersects(statement.getTextRange())) {
                    super.visitStatement(statement);
                }
            }

            public void visitExpression(PsiExpression expression) {
                TextRange range = expression.getTextRange();
                if (exprRange.intersects(range)) {
                    refExprRange.set((Object)((TextRange)refExprRange.get()).union(range));
                }
                super.visitExpression(expression);
            }

            public void visitCallExpression(PsiCallExpression expression) {
                super.visitCallExpression(expression);
                PsiMethod psiMethod = expression.resolveMethod();
                if (psiMethod != null) {
                    MethodCollector.this.myMethods.add(psiMethod);
                }
            }
        };
        element.accept((PsiElementVisitor)elementVisitor);
        for (PsiElement sibling = element.getNextSibling(); sibling != null && exprRange.intersects(sibling.getTextRange()); sibling = sibling.getNextSibling()) {
            sibling.accept((PsiElementVisitor)elementVisitor);
        }
        this.myLineRange = new Range((Comparable)Integer.valueOf(doc.getLineNumber(exprRange.getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(exprRange.getEndOffset())));
    }

    @NotNull
    public List<PsiMethod> getMethods() {
        List<PsiMethod> list = this.myMethods;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/MethodCollector", "getMethods"));
        }
        return list;
    }

    @Nullable
    public Range<Integer> getLineRange() {
        return this.myLineRange;
    }
}

