/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestNGVersionChecker {
    public static boolean isVersionIncompatible(Project project, GlobalSearchScope scope) {
        String protocolClassMessageClass = TestResultMessage.class.getName();
        PsiClass psiProtocolClass = JavaPsiFacade.getInstance((Project)project).findClass(protocolClassMessageClass, scope);
        if (psiProtocolClass != null) {
            String instanceFieldName = "m_instanceName";
            try {
                boolean userHasNewJar = psiProtocolClass.findFieldByName("m_instanceName", false) != null;
                boolean ideaHasNewJar = true;
                Class<?> aClass = Class.forName(protocolClassMessageClass);
                try {
                    aClass.getDeclaredField("m_instanceName");
                }
                catch (NoSuchFieldException e) {
                    ideaHasNewJar = false;
                }
                return userHasNewJar != ideaHasNewJar;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

