/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.sdk.LoadStatus;
import com.android.io.IAbstractFile;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.tools.idea.rendering.LayoutLogWrapper;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.utils.ILogger;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.android.uipreview.RenderingException;
import org.jetbrains.android.uipreview.UnsupportedJavaRuntimeException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.BufferingFileWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutLibraryLoader {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.LayoutLibraryLoader");

    private LayoutLibraryLoader() {
    }

    @Nullable
    public static LayoutLibrary load(@NotNull IAndroidTarget target, @NotNull Map<String, Map<String, Integer>> enumMap) throws RenderingException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/uipreview/LayoutLibraryLoader", "load"));
        }
        if (enumMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumMap", "org/jetbrains/android/uipreview/LayoutLibraryLoader", "load"));
        }
        String layoutLibJarPath = FileUtil.toSystemIndependentName((String)target.getPath(10));
        VirtualFile layoutLibJar = LocalFileSystem.getInstance().findFileByPath(layoutLibJarPath);
        if (layoutLibJar == null || layoutLibJar.isDirectory()) {
            throw new RenderingException(AndroidBundle.message("android.file.not.exist.error", FileUtil.toSystemDependentName((String)layoutLibJarPath)), new Throwable[0]);
        }
        String resFolderPath = FileUtil.toSystemIndependentName((String)target.getPath(11));
        VirtualFile resFolder = LocalFileSystem.getInstance().findFileByPath(resFolderPath);
        if (resFolder == null || !resFolder.isDirectory()) {
            throw new RenderingException(AndroidBundle.message("android.directory.cannot.be.found.error", FileUtil.toSystemDependentName((String)resFolderPath)), new Throwable[0]);
        }
        String fontFolderPath = FileUtil.toSystemIndependentName((String)target.getPath(12));
        VirtualFile fontFolder = LocalFileSystem.getInstance().findFileByPath(fontFolderPath);
        if (fontFolder == null || !fontFolder.isDirectory()) {
            throw new RenderingException(AndroidBundle.message("android.directory.cannot.be.found.error", FileUtil.toSystemDependentName((String)fontFolderPath)), new Throwable[0]);
        }
        String platformFolderPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        File platformFolder = new File(platformFolderPath);
        if (!platformFolder.isDirectory()) {
            throw new RenderingException(AndroidBundle.message("android.directory.cannot.be.found.error", FileUtil.toSystemDependentName((String)platformFolderPath)), new Throwable[0]);
        }
        File buildProp = new File(platformFolder, "build.prop");
        if (!buildProp.isFile()) {
            throw new RenderingException(AndroidBundle.message("android.file.not.exist.error", FileUtil.toSystemDependentName((String)buildProp.getPath())), new Throwable[0]);
        }
        if (!SystemInfo.isJavaVersionAtLeast((String)"1.8") && target.getVersion().getFeatureLevel() >= 24) {
            throw new UnsupportedJavaRuntimeException(AndroidBundle.message("android.layout.preview.unsupported.jdk", SdkVersionInfo.getCodeName((int)target.getVersion().getFeatureLevel())));
        }
        LogWrapper logger = new LogWrapper(LOG);
        LayoutLibrary library = LayoutLibrary.load((String)layoutLibJar.getPath(), (ILogger)logger, (String)ApplicationNamesInfo.getInstance().getFullProductName());
        if (library.getStatus() != LoadStatus.LOADED) {
            throw new RenderingException(library.getLoadMessage(), new Throwable[0]);
        }
        Map buildPropMap = ProjectProperties.parsePropertyFile((IAbstractFile)new BufferingFileWrapper(buildProp), (ILogger)logger);
        LayoutLogWrapper layoutLog = new LayoutLogWrapper(LOG);
        if (library.init(buildPropMap, new File(fontFolder.getPath()), enumMap, (LayoutLog)layoutLog)) {
            return library;
        }
        return null;
    }
}

