/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.drawable;

import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.AndroidResourceDomFileDescription;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidDrawableDomUtil {
    private static final String[] DRAWABLE_ROOTS_V1 = new String[]{"selector", "bitmap", "nine-patch", "layer-list", "level-list", "transition", "inset", "clip", "scale", "shape", "animation-list", "animated-rotate", "rotate", "color"};
    private static final String[] DRAWABLE_ROOTS_V21 = new String[]{"ripple", "animated-selector", "vector", "animated-vector"};

    private AndroidDrawableDomUtil() {
    }

    public static boolean isDrawableResourceFile(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/dom/drawable/AndroidDrawableDomUtil", "isDrawableResourceFile"));
        }
        return AndroidResourceDomFileDescription.doIsMyFile(file, ResourceFolderType.DRAWABLE);
    }

    public static List<String> getPossibleRoots(AndroidFacet facet) {
        AndroidVersion sdkVersion = AndroidModuleInfo.get(facet).getBuildSdkVersion();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(DRAWABLE_ROOTS_V1.length + DRAWABLE_ROOTS_V21.length));
        Collections.addAll(result, DRAWABLE_ROOTS_V1);
        if (sdkVersion == null || sdkVersion.getFeatureLevel() >= 21 || ApplicationManager.getApplication().isUnitTestMode()) {
            Collections.addAll(result, DRAWABLE_ROOTS_V21);
        }
        return result;
    }
}

