/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.designSurface;

import com.android.tools.idea.configurations.RenderOptionsMenuBuilder;
import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.idea.rendering.RefreshRenderAction;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.SaveScreenshotAction;
import com.google.common.collect.Sets;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewLayout;
import com.intellij.designer.actions.DesignerActionPanel;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ZoomType;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.psi.SearchUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDesignerActionPanel
extends DesignerActionPanel {
    private DefaultActionGroup myPopupGroup;
    private final DefaultActionGroup myDynamicBeforeGroup = new DefaultActionGroup();
    private final DefaultActionGroup myDynamicAfterGroup = new DefaultActionGroup();

    public AndroidDesignerActionPanel(DesignerEditorPanel designer, JComponent shortcuts) {
        super(designer, shortcuts);
        DefaultActionGroup popupGroup = this.getPopupGroup();
        popupGroup.addSeparator();
        popupGroup.add((AnAction)new SaveScreenshotAction((AndroidDesignerEditorPanel)this.myDesigner));
    }

    protected JComponent createToolbar() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createBorder((int)8));
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("DesignerToolbar", (ActionGroup)this.getActionGroup(), true);
        actionToolbar.setLayoutPolicy(1);
        panel.add((Component)actionToolbar.getComponent(), "North");
        ActionToolbar layoutToolBar = actionManager.createActionToolbar("DesignerToolbar", (ActionGroup)this.getDynamicActionGroup(), true);
        layoutToolBar.setLayoutPolicy(1);
        layoutToolBar.setMiniMode(true);
        layoutToolBar.setMinimumButtonSize((Dimension)JBUI.size((int)22, (int)24));
        ActionToolbar zoomToolBar = actionManager.createActionToolbar("DesignerToolbar", this.getRhsActions(), true);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.add((Component)layoutToolBar.getComponent(), "West");
        AndroidDesignerEditorPanel context = (AndroidDesignerEditorPanel)this.myDesigner;
        RenderOptionsMenuBuilder optionsMenuBuilder = RenderOptionsMenuBuilder.create(context);
        ActionToolbar optionsToolBar = optionsMenuBuilder.addPreferXmlOption().addDeviceFrameOption().addRetinaOption().build();
        JPanel combined = new JPanel(new BorderLayout());
        combined.add((Component)zoomToolBar.getComponent(), "West");
        combined.add((Component)optionsToolBar.getComponent(), "East");
        bottom.add((Component)combined, "East");
        panel.add((Component)bottom, "South");
        return panel;
    }

    protected DefaultActionGroup createActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.getActionGroup());
        return group;
    }

    public void update() {
    }

    private ActionGroup getRhsActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ToggleAction(null, "Zoom to Fit (0)", AndroidIcons.ZoomFit){

            public boolean isSelected(AnActionEvent e) {
                return ((AndroidDesignerEditorPanel)AndroidDesignerActionPanel.this.myDesigner).isZoomToFit();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                AndroidDesignerActionPanel.this.myDesigner.zoom(ZoomType.FIT);
            }
        });
        group.add(new AnAction(null, "Reset Zoom to 100% (1)", AndroidIcons.ZoomActual){

            public void actionPerformed(AnActionEvent e) {
                AndroidDesignerActionPanel.this.myDesigner.zoom(ZoomType.ACTUAL);
            }
        });
        group.addSeparator();
        group.add(new AnAction(null, "Zoom In (+)", AndroidIcons.ZoomIn){

            public void actionPerformed(AnActionEvent e) {
                AndroidDesignerActionPanel.this.myDesigner.zoom(ZoomType.IN);
            }
        });
        group.add(new AnAction(null, "Zoom Out (-)", AndroidIcons.ZoomOut){

            public void actionPerformed(AnActionEvent e) {
                AndroidDesignerActionPanel.this.myDesigner.zoom(ZoomType.OUT);
            }
        });
        String description = "Jump to Source";
        KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut("GotoDeclaration");
        if (shortcut != null) {
            description = description + " (" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")";
        }
        group.add(new AnAction(null, description, AllIcons.FileTypes.Text){

            public void actionPerformed(AnActionEvent e) {
                List selection = AndroidDesignerActionPanel.this.myDesigner.getSurfaceArea().getSelection();
                if (!selection.isEmpty()) {
                    RadViewComponent component = (RadViewComponent)((Object)selection.get(0));
                    PsiNavigateUtil.navigate((PsiElement)component.getTag());
                }
            }

            public void update(AnActionEvent e) {
                List selection = AndroidDesignerActionPanel.this.myDesigner.getSurfaceArea().getSelection();
                e.getPresentation().setEnabled(!selection.isEmpty());
            }
        });
        AndroidDesignerEditorPanel designer = (AndroidDesignerEditorPanel)this.myDesigner;
        group.add((AnAction)new RefreshRenderAction(designer));
        return group;
    }

    protected void addSelectionActions(List<RadComponent> selection, DefaultActionGroup group) {
        if (!selection.isEmpty()) {
            Map siblingLists = RadComponent.groupSiblings(selection);
            for (Map.Entry entry : siblingLists.entrySet()) {
                RadLayout selected;
                RadComponent parent = (RadComponent)entry.getKey();
                List children = (List)entry.getValue();
                if (parent != null) {
                    RadLayout layout = parent.getLayout();
                    if (layout instanceof RadViewLayout) {
                        ((RadViewLayout)layout).addContainerSelectionActions(this.myDesigner, group, RadViewComponent.getViewComponents(children));
                        continue;
                    }
                    layout.addSelectionActions(this.myDesigner, group, this.getShortcuts(), children);
                    continue;
                }
                if (selection.size() != 1 || !((selected = selection.get(0).getLayout()) instanceof RadViewLayout)) continue;
                ((RadViewLayout)selected).addContainerSelectionActions(this.myDesigner, group, RadViewComponent.getViewComponents(children));
            }
            for (RadComponent component : selection) {
                component.addSelectionActions(this.myDesigner, group, this.getShortcuts(), Collections.singletonList(component));
            }
        }
    }

    public ActionGroup getPopupActions(EditableArea area) {
        ActionGroup superActions = super.getPopupActions(area);
        if (this.myPopupGroup == null) {
            this.myPopupGroup = new DefaultActionGroup();
            this.myPopupGroup.add((AnAction)this.myDynamicBeforeGroup);
            this.myPopupGroup.add((AnAction)superActions);
            this.myPopupGroup.add((AnAction)this.myDynamicAfterGroup);
        }
        if (this.myDynamicBeforeGroup.getChildrenCount() > 0) {
            this.myDynamicBeforeGroup.removeAll();
        }
        if (this.myDynamicAfterGroup.getChildrenCount() > 0) {
            this.myDynamicAfterGroup.removeAll();
        }
        this.addShowIncludedInContextMenuActions();
        this.addSelectionContextMenuActions(area);
        return this.myPopupGroup;
    }

    private void addSelectionContextMenuActions(EditableArea area) {
        RadComponent selected;
        List selection = area.getSelection();
        if (selection.size() == 1 && (selected = (RadComponent)selection.get(0)) instanceof RadViewComponent) {
            RadViewComponent viewComponent = (RadViewComponent)selected;
            AndroidDesignerEditorPanel designer = (AndroidDesignerEditorPanel)this.myDesigner;
            viewComponent.addPopupActions(designer, this.myDynamicBeforeGroup, this.myDynamicAfterGroup, (JComponent)((Object)designer), selection);
            for (RadComponent current = selected.getParent(); current != null && current instanceof RadViewComponent; current = current.getParent()) {
                DefaultActionGroup container = new DefaultActionGroup(((RadViewComponent)current).getId(), true);
                if (!((RadViewComponent)current).addPopupActions(designer, container, container, (JComponent)((Object)designer), selection)) continue;
                this.myDynamicAfterGroup.add((AnAction)container);
            }
        }
    }

    private void addShowIncludedInContextMenuActions() {
        GlobalSearchScope useScope;
        GlobalSearchScope scope;
        DefaultActionGroup targetGroup = this.myDynamicBeforeGroup;
        AndroidDesignerEditorPanel designer = (AndroidDesignerEditorPanel)this.myDesigner;
        XmlFile xmlFile = designer.getXmlFile();
        Iterable allReferences = SearchUtils.findAllReferences((PsiElement)xmlFile, (SearchScope)(scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)(useScope = GlobalSearchScope.projectScope((Project)designer.getProject())), (FileType[])new FileType[]{StdFileTypes.XML})));
        Iterator iterator = allReferences.iterator();
        if (iterator.hasNext()) {
            boolean needSeparator = false;
            VirtualFile skip = null;
            String includingLayout = IncludeReference.getIncludingLayout(designer.getXmlFile());
            if (includingLayout != null) {
                IncludeReference includedWithin;
                targetGroup.add((AnAction)new ShowIncludedIn(designer, null, "Hide Including Layout"));
                targetGroup.addSeparator();
                RenderResult lastResult = designer.getLastRenderResult();
                if (lastResult != null && (includedWithin = lastResult.getIncludedWithin()) != null && includedWithin != IncludeReference.NONE) {
                    skip = includedWithin.getFromFile();
                }
            }
            HashSet files = Sets.newHashSet();
            while (iterator.hasNext()) {
                VirtualFile fromFile;
                PsiFile file;
                PsiReference reference = (PsiReference)iterator.next();
                PsiElement referenceElement = reference.getElement();
                if (referenceElement == null || (file = referenceElement.getContainingFile()) == null || file == xmlFile || (fromFile = file.getVirtualFile()) == null || fromFile == skip) continue;
                files.add(fromFile);
            }
            if (!files.isEmpty()) {
                ArrayList sorted = new ArrayList(files);
                Collections.sort(sorted, new Comparator<VirtualFile>(){

                    @Override
                    public int compare(VirtualFile f1, VirtualFile f2) {
                        VirtualFile p1 = f1.getParent();
                        VirtualFile p2 = f2.getParent();
                        if (p1 != null && p2 != null) {
                            return p1.getName().compareTo(p2.getName());
                        }
                        return f1.getName().compareTo(f2.getName());
                    }
                });
                for (VirtualFile fromFile : sorted) {
                    VirtualFile toFile = designer.getVirtualFile();
                    IncludeReference includeReference = IncludeReference.create(designer.getModule(), fromFile, toFile);
                    String title = String.format("Show Included In %1$s", includeReference.getFromDisplayName());
                    targetGroup.add((AnAction)new ShowIncludedIn(designer, includeReference, title));
                    needSeparator = true;
                }
                if (needSeparator) {
                    targetGroup.addSeparator();
                }
            }
        }
    }

    private static class ShowIncludedIn
    extends AnAction {
        private final IncludeReference myReference;
        private final AndroidDesignerEditorPanel myPanel;

        private ShowIncludedIn(@NotNull AndroidDesignerEditorPanel panel, @Nullable IncludeReference reference, @NotNull String title) {
            if (panel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/android/designer/designSurface/AndroidDesignerActionPanel$ShowIncludedIn", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/android/designer/designSurface/AndroidDesignerActionPanel$ShowIncludedIn", "<init>"));
            }
            super(title);
            this.myPanel = panel;
            this.myReference = reference;
        }

        public void actionPerformed(AnActionEvent e) {
            String layout = this.myReference != null ? this.myReference.getFromResourceUrl() : null;
            IncludeReference.setIncludingLayout(this.myPanel.getProject(), this.myPanel.getXmlFile(), layout);
            this.myPanel.requestRender();
        }
    }
}

