/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.Revision;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdk
extends InstallableComponent {
    public static final long SIZE = 265L * Storage.Unit.MiB.getNumberOfBytes();

    public AndroidSdk(@NotNull ScopedStateStore store) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/AndroidSdk", "<init>"));
        }
        super(store, "Android SDK", SIZE, "The collection of Android platform APIs, tools and utilities that enables you to debug, profile, and compile your apps.\n\nThe setup wizard will update your current Android SDK installation (if necessary) or install a new version.", FileOpUtils.create());
    }

    @Nullable
    private static Revision getLatestCompatibleBuildToolsRevision(@NotNull Map<String, RemotePackage> packages) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/welcome/install/AndroidSdk", "getLatestCompatibleBuildToolsRevision"));
        }
        Revision revision = null;
        for (RemotePackage p : packages.values()) {
            Revision fullRevision;
            if (!p.getPath().startsWith("build-tools") || (fullRevision = p.getVersion()).isPreview() || revision != null && fullRevision.compareTo(revision) <= 0) continue;
            revision = fullRevision;
        }
        return revision;
    }

    @Override
    @NotNull
    public Collection<String> getRequiredSdkPackages(@Nullable Map<String, RemotePackage> remotePackages) {
        Revision revision;
        ArrayList result = Lists.newArrayList();
        result.add("tools");
        result.add("platform-tools");
        if (remotePackages != null && (revision = AndroidSdk.getLatestCompatibleBuildToolsRevision(remotePackages)) != null) {
            result.add("build-tools;" + revision.toString());
        }
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            result.add(repository.getRepositoryLocation(new File(""), false).getPath().substring(1).replace(File.separatorChar, ';'));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/AndroidSdk", "getRequiredSdkPackages"));
        }
        return arrayList;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/install/AndroidSdk", "configure"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/AndroidSdk", "configure"));
        }
    }

    @Override
    protected boolean isOptionalForSdkLocation(@Nullable AndroidSdkHandler handler) {
        return false;
    }
}

