/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.tools.idea.sdk.wizard.HandleSkippedInstallationsModel;
import com.android.tools.idea.sdk.wizard.InstallMissingPackagesStep;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.sdkv2.StudioDownloader;
import com.android.tools.idea.sdkv2.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdkv2.StudioProgressRunner;
import com.android.tools.idea.sdkv2.StudioSettingsController;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.android.actions.RunAndroidSdkManagerAction;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkQuickfixUtils {
    private static final ProgressIndicator REPO_LOGGER = new StudioLoggerProgressIndicator(SdkQuickfixUtils.class);

    @Nullable
    public static ModelWizardDialog createDialogForPaths(@Nullable Component parent, @NotNull Collection<String> requestedPaths) {
        if (requestedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPaths", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "createDialogForPaths"));
        }
        return SdkQuickfixUtils.createDialog(null, parent, requestedPaths, null, SdkQuickfixUtils.getSdkHandler());
    }

    @Nullable
    public static ModelWizardDialog createDialogForPackages(@Nullable Component parent, @NotNull Collection<UpdatablePackage> requestedPackages) {
        if (requestedPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPackages", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "createDialogForPackages"));
        }
        return SdkQuickfixUtils.createDialog(null, parent, null, requestedPackages, SdkQuickfixUtils.getSdkHandler());
    }

    @Nullable
    public static ModelWizardDialog createDialogForPaths(@Nullable Project project, @NotNull Collection<String> requestedPaths) {
        if (requestedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPaths", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "createDialogForPaths"));
        }
        return SdkQuickfixUtils.createDialog(project, null, requestedPaths, null, SdkQuickfixUtils.getSdkHandler());
    }

    private static AndroidSdkHandler getSdkHandler() {
        AndroidSdkData data = AndroidSdkUtils.tryToChooseAndroidSdk();
        if (data == null) {
            String title = "SDK Problem";
            String msg = "<html>Your Android SDK is missing or out of date.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            return null;
        }
        return data.getSdkHandler();
    }

    @Nullable
    static ModelWizardDialog createDialog(@Nullable Project project, @Nullable Component parent, @Nullable Collection<String> requestedPaths, @Nullable Collection<UpdatablePackage> requestedPackages, @Nullable AndroidSdkHandler sdkHandler) {
        ArrayList skippedInstallRequests;
        ArrayList installRequests;
        if (sdkHandler == null) {
            return null;
        }
        RepoManager mgr = sdkHandler.getSdkManager(REPO_LOGGER);
        if (mgr.getLocalPath() == null) {
            String title = "SDK Problem";
            String msg = "<html>Your Android SDK is missing or out of date.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            Messages.showErrorDialog((String)msg, (String)title);
            return null;
        }
        ArrayList unknownPaths = Lists.newArrayList();
        ArrayList resolvedPackages = Lists.newArrayList();
        String error = SdkQuickfixUtils.resolve(requestedPaths, requestedPackages, mgr, resolvedPackages, unknownPaths);
        if (error != null) {
            Messages.showErrorDialog((String)error, (String)"Error Resolving Packages");
            return null;
        }
        ArrayList unavailableDownloads = Lists.newArrayList();
        SdkQuickfixUtils.verifyAvailability(resolvedPackages, unavailableDownloads);
        if (!unknownPaths.isEmpty() || !unavailableDownloads.isEmpty()) {
            String title = "Packages Unavailable";
            HtmlBuilder builder = new HtmlBuilder();
            builder.openHtmlBody().add(String.format("%1$s packages are not available for download!", resolvedPackages.isEmpty() ? "All" : "Some")).newline().newline().add("The following packages are not available:").beginList();
            for (Object p : unavailableDownloads) {
                builder.listItem().add(p.getRepresentative().getDisplayName());
            }
            for (Object p : unknownPaths) {
                builder.listItem().add("Package id " + (String)p);
            }
            builder.endList().closeHtmlBody();
            Messages.showErrorDialog((String)builder.getHtml(), (String)title);
            if (resolvedPackages.isEmpty()) {
                return null;
            }
        }
        if (!SdkQuickfixUtils.checkForProblems(project, parent, resolvedPackages, installRequests = Lists.newArrayList(), skippedInstallRequests = Lists.newArrayList(), sdkHandler)) {
            SdkQuickfixUtils.startSdkManagerAndExit(project, mgr.getLocalPath());
        }
        if (installRequests.isEmpty()) {
            return null;
        }
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        wizardBuilder.addStep(new LicenseAgreementStep(new LicenseAgreementModel(mgr.getLocalPath()), installRequests));
        wizardBuilder.addStep(new InstallSelectedPackagesStep(installRequests, mgr, sdkHandler));
        if (!skippedInstallRequests.isEmpty()) {
            HandleSkippedInstallationsModel handleSkippedInstallationsModel = new HandleSkippedInstallationsModel(project, skippedInstallRequests, mgr.getLocalPath());
            wizardBuilder.addStep(new InstallMissingPackagesStep(handleSkippedInstallationsModel));
        }
        ModelWizard wizard = wizardBuilder.build();
        String title = "SDK Quickfix Installation";
        return new StudioWizardDialogBuilder(wizard, title, parent).setProject(project).setModalityType(DialogWrapper.IdeModalityType.IDE).build();
    }

    private static void verifyAvailability(List<UpdatablePackage> requestedPackages, List<UpdatablePackage> unavailableDownloads) {
        ListIterator<UpdatablePackage> iter = requestedPackages.listIterator();
        while (iter.hasNext()) {
            UpdatablePackage p = (UpdatablePackage)iter.next();
            if (p.hasRemote()) continue;
            iter.remove();
            unavailableDownloads.add(p);
        }
    }

    private static boolean checkForProblems(@Nullable Project project, @Nullable Component parent, @NotNull List<UpdatablePackage> requestedPackages, @NotNull List<RemotePackage> installRequests, @NotNull List<RemotePackage> skippedInstalls, @NotNull AndroidSdkHandler handler) {
        if (requestedPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedPackages", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "checkForProblems"));
        }
        if (installRequests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installRequests", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "checkForProblems"));
        }
        if (skippedInstalls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedInstalls", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "checkForProblems"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "checkForProblems"));
        }
        HashSet problems = Sets.newHashSet();
        SdkQuickfixUtils.findProblemPackages(requestedPackages, handler, problems, installRequests);
        InstallSdkOption selectedOption = InstallSdkOption.ATTEMPT_ALL;
        if (!problems.isEmpty()) {
            StringBuilder warningBuilder = new StringBuilder("Due to your system configuration and the packages to be installed, \nit is likely that the following packages cannot be successfully installed while ");
            warningBuilder.append(ApplicationNamesInfo.getInstance().getFullProductName());
            warningBuilder.append(" is running. \n\nPlease exit and install the following packages using the standalone SDK manager:");
            for (RepoPackage problemPkg : problems) {
                warningBuilder.append("\n    -");
                warningBuilder.append(problemPkg.getDisplayName());
            }
            InstallSdkOption[] options = problems.size() == requestedPackages.size() ? new InstallSdkOption[]{InstallSdkOption.CANCEL, InstallSdkOption.ATTEMPT_ALL, InstallSdkOption.EXIT_AND_LAUNCH_STANDALONE} : new InstallSdkOption[]{InstallSdkOption.EXIT_AND_LAUNCH_STANDALONE, InstallSdkOption.ATTEMPT_ALL, InstallSdkOption.INSTALL_SAFE};
            String[] optionNames = new String[options.length];
            for (int i = 0; i < options.length; ++i) {
                optionNames[i] = options[i].getDescription();
            }
            int result = parent != null ? Messages.showDialog((Component)parent, (String)warningBuilder.toString(), (String)"Warning", (String[])optionNames, (int)(optionNames.length - 1), (Icon)AllIcons.General.Warning) : Messages.showDialog((Project)project, (String)warningBuilder.toString(), (String)"Warning", (String[])optionNames, (int)(optionNames.length - 1), (Icon)AllIcons.General.Warning);
            selectedOption = result == -1 ? InstallSdkOption.CANCEL : options[result];
        }
        if (selectedOption == InstallSdkOption.EXIT_AND_LAUNCH_STANDALONE) {
            installRequests.clear();
            skippedInstalls.clear();
            return false;
        }
        if (selectedOption == InstallSdkOption.INSTALL_SAFE) {
            skippedInstalls.addAll(problems);
        } else if (selectedOption == InstallSdkOption.ATTEMPT_ALL) {
            installRequests.addAll(problems);
        } else if (selectedOption == InstallSdkOption.CANCEL) {
            installRequests.clear();
            skippedInstalls.clear();
        }
        return true;
    }

    public static String resolve(@Nullable Collection<String> requestedPaths, @Nullable Collection<UpdatablePackage> requestedPackages, RepoManager mgr, List<UpdatablePackage> result, List<String> notFound) {
        mgr.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, null, null, (ProgressRunner)new StudioProgressRunner(true, false, true, "Loading Remote Packages...", false, null), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), true);
        Map packages = mgr.getPackages().getConsolidatedPkgs();
        if (requestedPackages == null) {
            requestedPackages = Lists.newArrayList();
        }
        ArrayList resolved = Lists.newArrayList((Iterable)requestedPackages);
        if (requestedPaths != null) {
            for (String string : requestedPaths) {
                UpdatablePackage p = (UpdatablePackage)packages.get(string);
                if (p == null || !p.hasRemote()) {
                    notFound.add(string);
                    continue;
                }
                resolved.add(p);
            }
        }
        ArrayList remotes = Lists.newArrayList();
        for (UpdatablePackage p : resolved) {
            if (!p.hasRemote()) continue;
            remotes.add(p.getRemote());
        }
        final AtomicReference atomicReference = new AtomicReference();
        ProgressIndicatorAdapter errorCollector = new ProgressIndicatorAdapter(){

            public void logWarning(String s) {
                atomicReference.set(s);
            }
        };
        List withDependencies = InstallerUtil.computeRequiredPackages((Collection)remotes, (RepositoryPackages)mgr.getPackages(), (ProgressIndicator)errorCollector);
        if (withDependencies == null) {
            return (String)atomicReference.get();
        }
        for (RemotePackage remote : withDependencies) {
            result.add((UpdatablePackage)packages.get(remote.getPath()));
        }
        return null;
    }

    private static void findProblemPackages(List<UpdatablePackage> installRequests, AndroidSdkHandler handler, Set<RemotePackage> problems, List<RemotePackage> nonProblems) {
        boolean isWindows = handler.getFileOp().isWindows();
        for (UpdatablePackage p : installRequests) {
            RemotePackage remote = p.getRemote();
            if (isWindows && p.isUpdate()) {
                problems.add(remote);
                continue;
            }
            nonProblems.add(remote);
        }
    }

    public static void startSdkManagerAndExit(final @Nullable Project project, final @NotNull File sdkPath) {
        if (sdkPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkPath", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils", "startSdkManagerAndExit"));
        }
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        MessageBusConnection connection = app.getMessageBus().connect((Disposable)app);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            public void appClosing() {
                RunAndroidSdkManagerAction.runSpecificSdkManagerSynchronously(project, sdkPath);
            }
        });
        app.exit(true, true);
    }

    private static enum InstallSdkOption {
        EXIT_AND_LAUNCH_STANDALONE(String.format("Exit %s and launch SDK Manager", ApplicationNamesInfo.getInstance().getProductName())),
        ATTEMPT_ALL("Attempt to install all packages"),
        INSTALL_SAFE("Install safe packages"),
        CANCEL("Cancel");

        private String myDescription;

        private InstallSdkOption(String description) {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils$InstallSdkOption", "<init>"));
            }
            this.myDescription = description;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }
}

