/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.ConsolePrinter;
import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessHandlerConsolePrinter
implements ConsolePrinter {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final List<Message> myStoredMessages = Lists.newArrayList();
    @Nullable
    private ProcessHandler myProcessHandler;

    public ProcessHandlerConsolePrinter(@Nullable ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    @Override
    public void stdout(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/run/ProcessHandlerConsolePrinter", "stdout"));
        }
        this.print(text, ProcessOutputTypes.STDOUT);
    }

    @Override
    public void stderr(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/run/ProcessHandlerConsolePrinter", "stderr"));
        }
        this.print(text, ProcessOutputTypes.STDERR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessHandler(@NotNull ProcessHandler processHandler) {
        ArrayList storedMessages;
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/android/tools/idea/run/ProcessHandlerConsolePrinter", "setProcessHandler"));
        }
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            this.myProcessHandler = processHandler;
            storedMessages = Lists.newArrayList(this.myStoredMessages);
            this.myStoredMessages.clear();
        }
        for (Message message : storedMessages) {
            this.print(message.text, message.outputType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(@NotNull String text, @NotNull Key outputType) {
        ProcessHandler processHandler;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/run/ProcessHandlerConsolePrinter", "print"));
        }
        if (outputType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/android/tools/idea/run/ProcessHandlerConsolePrinter", "print"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProcessHandler == null) {
                this.myStoredMessages.add(new Message(text, outputType));
                return;
            }
            processHandler = this.myProcessHandler;
        }
        assert (!Thread.holdsLock(this.myLock));
        processHandler.notifyTextAvailable(text + '\n', outputType);
    }

    private static class Message {
        @NotNull
        final String text;
        @NotNull
        final Key outputType;

        Message(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/run/ProcessHandlerConsolePrinter$Message", "<init>"));
            }
            if (outputType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputType", "com/android/tools/idea/run/ProcessHandlerConsolePrinter$Message", "<init>"));
            }
            this.text = text;
            this.outputType = outputType;
        }
    }
}

