/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.tools.idea.npw.assetstudio.AssetStudioAssetGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public final class ImageAsset
extends BaseAsset {
    @NotNull
    private final ObjectProperty<File> myImagePath;

    public ImageAsset() {
        String pathToSampleImageInTemplate = FileUtil.join((String[])new String[]{"gradle-projects", "NewAndroidModule", "root", "res", "mipmap-xxxhdpi", "ic_launcher.png"});
        this.myImagePath = new ObjectValueProperty<File>(new File(TemplateManager.getTemplateRootFolder(), pathToSampleImageInTemplate));
    }

    @NotNull
    public ObjectProperty<File> imagePath() {
        ObjectProperty<File> objectProperty = this.myImagePath;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ImageAsset", "imagePath"));
        }
        return objectProperty;
    }

    @Override
    @NotNull
    protected BufferedImage createAsImage(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/npw/assetstudio/assets/ImageAsset", "createAsImage"));
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read((File)this.myImagePath.get());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (image == null) {
            image = AssetStudioAssetGenerator.createDummyImage();
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ImageAsset", "createAsImage"));
        }
        return bufferedImage;
    }
}

