/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.ide.common.util.AssetUtil;
import com.android.tools.idea.rendering.ImageUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public final class AssetStudioAssetGenerator
implements GraphicGeneratorContext {
    private static Cache<String, BufferedImage> ourImageCache = CacheBuilder.newBuilder().build();

    private static Logger getLog() {
        return Logger.getInstance(AssetStudioAssetGenerator.class);
    }

    @NotNull
    public static BufferedImage createDummyImage() {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "createDummyImage"));
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage getStencilImage(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "getStencilImage"));
        }
        BufferedImage image = GraphicGenerator.getStencilImage((String)path);
        if (image == null) {
            image = AssetStudioAssetGenerator.createDummyImage();
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "getStencilImage"));
        }
        return bufferedImage;
    }

    @NotNull
    public static Map<String, Map<String, BufferedImage>> newAssetMap() {
        HashMap hashMap = Maps.newHashMap();
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "newAssetMap"));
        }
        return hashMap;
    }

    @NotNull
    public static BufferedImage trim(@NotNull BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "trim"));
        }
        BufferedImage cropped = ImageUtils.cropBlank(image, null, 2);
        BufferedImage bufferedImage = cropped != null ? cropped : image;
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "trim"));
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage pad(@NotNull BufferedImage image, int paddingPercent) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "pad"));
        }
        if (image.getWidth() <= 1 || image.getHeight() <= 1) {
            BufferedImage bufferedImage = image;
            if (bufferedImage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "pad"));
            }
            return bufferedImage;
        }
        if (paddingPercent > 100) {
            paddingPercent = 100;
        }
        int largerSide = Math.max(image.getWidth(), image.getHeight());
        int smallerSide = Math.min(image.getWidth(), image.getHeight());
        int padding = largerSide * paddingPercent / 100;
        padding = Math.max(-(smallerSide / 2 - 1), padding);
        BufferedImage bufferedImage = AssetUtil.paddedImage((BufferedImage)image, (int)padding);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "pad"));
        }
        return bufferedImage;
    }

    public BufferedImage loadImageResource(final @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "loadImageResource"));
        }
        try {
            return (BufferedImage)ourImageCache.get((Object)path, (Callable)new Callable<BufferedImage>(){

                @Override
                public BufferedImage call() throws Exception {
                    return AssetStudioAssetGenerator.getStencilImage(path);
                }
            });
        }
        catch (ExecutionException e) {
            AssetStudioAssetGenerator.getLog().error((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateIconsIntoPath(@NotNull Map<File, BufferedImage> pathIconMap) {
        if (pathIconMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathIconMap", "com/android/tools/idea/npw/assetstudio/AssetStudioAssetGenerator", "generateIconsIntoPath"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (Map.Entry<File, BufferedImage> fileImageEntry : pathIconMap.entrySet()) {
            File file = fileImageEntry.getKey();
            BufferedImage image = fileImageEntry.getValue();
            try {
                VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
                VirtualFile imageFile = directory.findChild(file.getName());
                if (imageFile == null || !imageFile.exists()) {
                    imageFile = directory.createChildData((Object)this, file.getName());
                }
                OutputStream outputStream = imageFile.getOutputStream((Object)this);
                try {
                    ImageIO.write((RenderedImage)image, "PNG", outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                AssetStudioAssetGenerator.getLog().error((Throwable)e);
            }
        }
    }
}

