/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.model;

import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.List;

public class PsiModelMethod
extends ModelMethod {
    PsiMethod myPsiMethod;

    public PsiModelMethod(PsiMethod psiMethod) {
        this.myPsiMethod = psiMethod;
    }

    public ModelClass getDeclaringClass() {
        PsiClass containingClass = this.myPsiMethod.getContainingClass();
        return containingClass == null ? null : new PsiModelClass((PsiType)PsiTypesUtil.getClassType((PsiClass)containingClass));
    }

    public PsiMethod getPsiMethod() {
        return this.myPsiMethod;
    }

    public ModelClass[] getParameterTypes() {
        PsiParameterList parameterList = this.myPsiMethod.getParameterList();
        ModelClass[] modelClasses = new ModelClass[parameterList.getParameters().length];
        for (int i = 0; i < parameterList.getParametersCount(); ++i) {
            PsiParameter param = parameterList.getParameters()[i];
            modelClasses[i] = new PsiModelClass(param.getType());
        }
        return modelClasses;
    }

    public String getName() {
        return this.myPsiMethod.getName();
    }

    public ModelClass getReturnType(List<ModelClass> list) {
        PsiType returnType = this.myPsiMethod.getReturnType();
        return returnType != null ? new PsiModelClass(returnType) : null;
    }

    public boolean isVoid() {
        return PsiType.VOID.equals((Object)this.myPsiMethod.getReturnType());
    }

    public boolean isPublic() {
        return this.myPsiMethod.hasModifierProperty("public");
    }

    public boolean isProtected() {
        return this.myPsiMethod.hasModifierProperty("protected");
    }

    public boolean isStatic() {
        return this.myPsiMethod.hasModifierProperty("static");
    }

    public boolean isAbstract() {
        return this.myPsiMethod.hasModifierProperty("abstract");
    }

    public boolean isBindable() {
        return false;
    }

    public int getMinApi() {
        return 0;
    }

    public String getJniDescription() {
        return this.myPsiMethod.getName();
    }

    public boolean isVarArgs() {
        return this.myPsiMethod.isVarArgs();
    }
}

