/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.model;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.configurables.model.ArtifactDependencyMergedModel;
import com.android.tools.idea.gradle.structure.configurables.model.Coordinates;
import com.android.tools.idea.gradle.structure.configurables.model.DependencyMergedModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Objects;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleMergedModel {
    @NotNull
    private static final Map<String, String> ARTIFACT_TO_SCOPE_MAP = Maps.newHashMap();
    @NotNull
    final GradleBuildModel buildModel;
    @NotNull
    final AndroidProject androidProject;
    @NotNull
    final Module module;
    @NotNull
    private final List<DependencyMergedModel> myDependencyModels;

    @Nullable
    public static ModuleMergedModel get(@NotNull Module module) {
        AndroidGradleModel androidModel;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "get"));
        }
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel != null && (androidModel = AndroidGradleModel.get(module)) != null) {
            return new ModuleMergedModel(buildModel, androidModel.getAndroidProject(), module);
        }
        return null;
    }

    private ModuleMergedModel(@NotNull GradleBuildModel buildModel, @NotNull AndroidProject androidProject, @NotNull Module module) {
        if (buildModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildModel", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "<init>"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "<init>"));
        }
        this.myDependencyModels = Lists.newArrayList();
        this.buildModel = buildModel;
        this.androidProject = androidProject;
        this.module = module;
        this.populate();
    }

    private void populate() {
        LogicalArtifactDependencies logicalDependencies = new LogicalArtifactDependencies();
        for (Variant variant : this.androidProject.getVariants()) {
            AndroidArtifact mainArtifact = variant.getMainArtifact();
            ModuleMergedModel.collectArtifactDependencies(variant, (BaseArtifact)mainArtifact, logicalDependencies);
            for (BaseArtifact artifact : variant.getExtraAndroidArtifacts()) {
                ModuleMergedModel.collectArtifactDependencies(variant, artifact, logicalDependencies);
            }
            for (BaseArtifact artifact : variant.getExtraJavaArtifacts()) {
                ModuleMergedModel.collectArtifactDependencies(variant, artifact, logicalDependencies);
            }
        }
        DependenciesModel dependenciesModel = this.buildModel.dependencies();
        if (dependenciesModel != null) {
            for (DependencyModel dependencyModel : dependenciesModel.all()) {
                if (!(dependencyModel instanceof ArtifactDependencyModel)) continue;
                this.addDependency((ArtifactDependencyModel)dependencyModel, logicalDependencies);
            }
        }
    }

    private static void collectArtifactDependencies(@NotNull Variant variant, @NotNull BaseArtifact artifact, @NotNull LogicalArtifactDependencies logicalDependencies) {
        LogicalArtifactDependency dependency;
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "collectArtifactDependencies"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "collectArtifactDependencies"));
        }
        if (logicalDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalDependencies", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "collectArtifactDependencies"));
        }
        String scopeName = ModuleMergedModel.getScopeName(artifact);
        if (StringUtil.isEmpty((String)scopeName)) {
            return;
        }
        Dependencies dependencies = artifact.getDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            dependency = LogicalArtifactDependency.create((Library)library);
            logicalDependencies.add(variant, scopeName, dependency);
        }
        for (AndroidLibrary library : dependencies.getJavaLibraries()) {
            dependency = LogicalArtifactDependency.create((Library)library);
            logicalDependencies.add(variant, scopeName, dependency);
        }
    }

    @Nullable
    private static String getScopeName(@NotNull BaseArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "getScopeName"));
        }
        return ARTIFACT_TO_SCOPE_MAP.get(artifact.getName());
    }

    private void addDependency(@NotNull ArtifactDependencyModel parsedDependency, @NotNull LogicalArtifactDependencies logicalDependencies) {
        ArtifactDependencyMergedModel model;
        String configurationName;
        Collection<LogicalArtifactDependency> dependenciesInConfiguration;
        if (parsedDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsedDependency", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "addDependency"));
        }
        if (logicalDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalDependencies", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "addDependency"));
        }
        GradleCoordinate parsedCoordinate = GradleCoordinate.parseCoordinateString((String)parsedDependency.getSpec().compactNotation());
        if (parsedCoordinate != null && !(dependenciesInConfiguration = logicalDependencies.getByConfigurationName(configurationName = parsedDependency.configurationName())).isEmpty()) {
            ArrayList fromGradleModel = Lists.newArrayList();
            for (LogicalArtifactDependency dependency : dependenciesInConfiguration) {
                GradleCoordinate logicalCoordinate = dependency.coordinate;
                if (!Coordinates.areEqual(logicalCoordinate, parsedCoordinate)) continue;
                fromGradleModel.add(dependency);
                logicalDependencies.markAsFound(dependency);
            }
            if (!fromGradleModel.isEmpty()) {
                ArtifactDependencyMergedModel model2 = ArtifactDependencyMergedModel.create(this, fromGradleModel, parsedDependency);
                if (model2 != null) {
                    this.myDependencyModels.add(model2);
                }
                return;
            }
        }
        if ((model = ArtifactDependencyMergedModel.create(this, parsedDependency)) != null) {
            this.myDependencyModels.add(model);
        }
    }

    @NotNull
    public String getModuleName() {
        String string = this.module.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        if (!this.module.isDisposed()) {
            Icon icon = GradleUtil.getModuleIcon(this.module);
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "getIcon"));
            }
            return icon;
        }
        Icon icon = AllIcons.Nodes.Module;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public AndroidProject getAndroidProject() {
        AndroidProject androidProject = this.androidProject;
        if (androidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "getAndroidProject"));
        }
        return androidProject;
    }

    @NotNull
    public List<DependencyMergedModel> getDependencies() {
        List<DependencyMergedModel> list = this.myDependencyModels;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel", "getDependencies"));
        }
        return list;
    }

    static {
        ARTIFACT_TO_SCOPE_MAP.put("_main_", "compile");
        ARTIFACT_TO_SCOPE_MAP.put("_android_test_", "androidTest");
        ARTIFACT_TO_SCOPE_MAP.put("_unit_test_", "testCompile");
    }

    static class LogicalArtifactDependency {
        @NotNull
        final GradleCoordinate coordinate;
        @NotNull
        final Library dependency;
        @NotNull
        final List<Variant> containers;

        @Nullable
        static LogicalArtifactDependency create(@NotNull Library dependency) {
            if (dependency == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel$LogicalArtifactDependency", "create"));
            }
            MavenCoordinates resolved = dependency.getResolvedCoordinates();
            if (resolved != null) {
                return new LogicalArtifactDependency(Coordinates.convert(resolved), dependency);
            }
            return null;
        }

        LogicalArtifactDependency(@NotNull GradleCoordinate coordinate, @NotNull Library dependency) {
            if (coordinate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinate", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel$LogicalArtifactDependency", "<init>"));
            }
            if (dependency == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel$LogicalArtifactDependency", "<init>"));
            }
            this.containers = Lists.newArrayList();
            this.coordinate = coordinate;
            this.dependency = dependency;
        }

        void addContainer(@NotNull Variant container) {
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel$LogicalArtifactDependency", "addContainer"));
            }
            this.containers.add(container);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogicalArtifactDependency that = (LogicalArtifactDependency)o;
            return Objects.equal((Object)this.coordinate.toString(), (Object)that.coordinate.toString());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.coordinate.toString()});
        }

        public String toString() {
            return this.coordinate.toString();
        }
    }

    private static class LogicalArtifactDependencies {
        @NotNull
        private final Multimap<String, LogicalArtifactDependency> myDependenciesByScope = LinkedHashMultimap.create();
        @NotNull
        private final Map<String, LogicalArtifactDependency> myDependenciesByCoordinate = Maps.newHashMap();
        @NotNull
        private final Set<LogicalArtifactDependency> myDependencies = Sets.newHashSet(this.myDependenciesByCoordinate.values());

        private LogicalArtifactDependencies() {
        }

        void add(@NotNull Variant variant, @NotNull String scopeName, @Nullable LogicalArtifactDependency dependency) {
            if (variant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel$LogicalArtifactDependencies", "add"));
            }
            if (scopeName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel$LogicalArtifactDependencies", "add"));
            }
            if (dependency != null) {
                LogicalArtifactDependency existing = this.myDependenciesByCoordinate.get(dependency.toString());
                if (existing != null) {
                    dependency = existing;
                } else {
                    this.myDependenciesByCoordinate.put(dependency.toString(), dependency);
                }
                dependency.addContainer(variant);
                this.myDependenciesByScope.put((Object)scopeName, (Object)dependency);
                scopeName = StringUtil.capitalize((String)scopeName);
                for (String flavor : variant.getProductFlavors()) {
                    String flavorScope = flavor + scopeName;
                    this.myDependenciesByScope.put((Object)flavorScope, (Object)dependency);
                }
                this.myDependenciesByScope.put((Object)(variant.getBuildType() + scopeName), (Object)dependency);
                this.myDependencies.add(dependency);
            }
        }

        @NotNull
        Collection<LogicalArtifactDependency> getByConfigurationName(String configurationName) {
            Collection collection = this.myDependenciesByScope.get((Object)configurationName);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel$LogicalArtifactDependencies", "getByConfigurationName"));
            }
            return collection;
        }

        void markAsFound(LogicalArtifactDependency dependency) {
            this.myDependencies.remove(dependency);
        }

        @NotNull
        Set<LogicalArtifactDependency> getNotFound() {
            Set<LogicalArtifactDependency> set = this.myDependencies;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/model/ModuleMergedModel$LogicalArtifactDependencies", "getNotFound"));
            }
            return set;
        }
    }
}

