/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.editor;

import com.android.tools.idea.gradle.structure.configurables.editor.ModuleConfigurationEditor;
import com.android.tools.idea.gradle.structure.configurables.editor.ModuleEditor;
import com.android.tools.idea.gradle.structure.configurables.model.ModuleMergedModel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedModuleEditor
extends ModuleEditor {
    @NonNls
    private static final String SELECTED_EDITOR_KEY = TabbedModuleEditor.class.getName() + ".selectedEditor";
    private TabbedPaneWrapper myTabbedPane;

    public TabbedModuleEditor(@NotNull ModuleMergedModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/editor/TabbedModuleEditor", "<init>"));
        }
        super(model);
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        this.myTabbedPane = new TabbedPaneWrapper((Disposable)this);
        for (ModuleConfigurationEditor editor : this.getEditors()) {
            this.myTabbedPane.addTab(editor.getDisplayName(), editor.createComponent());
            editor.reset();
        }
        this.restoreSelectedEditor();
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedModuleEditor.this.saveSelectedEditor();
                History history = TabbedModuleEditor.this.getHistory();
                if (history != null) {
                    history.pushQueryPlace();
                }
            }
        });
        JComponent jComponent = this.myTabbedPane.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/editor/TabbedModuleEditor", "createCenterPanel"));
        }
        return jComponent;
    }

    @Override
    protected void restoreSelectedEditor() {
        this.selectEditor(TabbedModuleEditor.getSavedSelectedEditor());
    }

    @Override
    @Nullable
    public ModuleConfigurationEditor getSelectedEditor() {
        if (this.myTabbedPane == null) {
            return null;
        }
        String title = this.myTabbedPane.getSelectedTitle();
        if (title == null) {
            return null;
        }
        return this.getEditor(title);
    }

    private int getEditorTabIndex(@NotNull String editorName) {
        if (editorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorName", "com/android/tools/idea/gradle/structure/configurables/editor/TabbedModuleEditor", "getEditorTabIndex"));
        }
        if (this.myTabbedPane != null) {
            int tabCount = this.myTabbedPane.getTabCount();
            for (int index = 0; index < tabCount; ++index) {
                if (!editorName.equals(this.myTabbedPane.getTitleAt(index))) continue;
                return index;
            }
        }
        return -1;
    }

    @Override
    @Nullable
    public ModuleConfigurationEditor getEditor(@NotNull String displayName) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/gradle/structure/configurables/editor/TabbedModuleEditor", "getEditor"));
        }
        return null;
    }

    @Override
    protected void disposeCenterPanel() {
        if (this.myTabbedPane != null) {
            this.saveSelectedEditor();
            this.myTabbedPane = null;
        }
    }

    @Nullable
    private String getSelectedTabName() {
        if (this.myTabbedPane != null) {
            int index = this.myTabbedPane.getSelectedIndex();
            return index != -1 ? this.myTabbedPane.getTitleAt(index) : null;
        }
        return null;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        if (place != null) {
            this.selectEditor((String)place.getPath("selectedEditor"));
        }
        return ActionCallback.DONE;
    }

    @Override
    public void selectEditor(@Nullable String displayName) {
        if (displayName != null) {
            this.getPanel();
            int editorTabIndex = this.getEditorTabIndex(displayName);
            if (editorTabIndex >= 0 && editorTabIndex < this.myTabbedPane.getTabCount()) {
                this.myTabbedPane.setSelectedIndex(editorTabIndex);
                this.saveSelectedEditor();
            }
        }
    }

    private void saveSelectedEditor() {
        String selectedTabName = this.getSelectedTabName();
        if (selectedTabName != null) {
            PropertiesComponent.getInstance().setValue(SELECTED_EDITOR_KEY, selectedTabName);
        }
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/gradle/structure/configurables/editor/TabbedModuleEditor", "queryPlace"));
        }
        place.putPath("selectedEditor", (Object)TabbedModuleEditor.getSavedSelectedEditor());
    }

    @Nullable
    private static String getSavedSelectedEditor() {
        return PropertiesComponent.getInstance().getValue(SELECTED_EDITOR_KEY);
    }
}

